//////////////////////////////////////////////////////////////////
//
//    TC problem.
//
//    Learn a T and a C drawn in a 3 pixel rect and roteated
//    by 90 degrees between each pattern
//
//  T's
//
//  ###  #     #     #
//   #   ###   #   ###
//   #   #    ###    #
//
//  C's
//
//  ###  ###  ###  # #
//  #    # #    #  # #
//  ###  # #  ###  ###
//
//////////////////////////////////////////////////////////////////

import jaNet.backprop.*;

public class myTC{

    public static final double FIRE =  1.0;
    public static final double DOWN = -1.0;
    
    public static void main(String args[]){
        BPN myBPN = null;
        try{
            System.out.println("____________________________________________________\n\n");
            System.out.println("     Read TC problem from tc.bpn file");
            System.out.println("\n____________________________________________________\n");
            //
            // Input table, 8 nine input patterns
            //
            double in[][] = {{FIRE,  FIRE,  FIRE,  DOWN,  FIRE,  DOWN,  DOWN,  FIRE,  DOWN}, // T
                             {DOWN,  DOWN,  FIRE,  FIRE,  FIRE,  FIRE,  DOWN,  DOWN,  FIRE}, // T
                             {DOWN,  FIRE,  DOWN,  DOWN,  FIRE,  DOWN,  FIRE,  FIRE,  FIRE}, // T
                             {FIRE,  DOWN,  DOWN,  FIRE,  FIRE,  FIRE,  FIRE,  DOWN,  DOWN}, // T
                             {FIRE,  FIRE,  FIRE,  FIRE,  DOWN,  DOWN,  FIRE,  FIRE,  FIRE}, // C
                             {FIRE,  FIRE,  FIRE,  FIRE,  DOWN,  FIRE,  FIRE,  DOWN,  FIRE}, // C
                             {FIRE,  FIRE,  FIRE,  DOWN,  DOWN,  FIRE,  FIRE,  FIRE,  FIRE}, // C
                             {FIRE,  DOWN,  FIRE,  FIRE,  DOWN,  FIRE,  FIRE,  FIRE,  FIRE}  // C
                            };
            //
            // Target table, 8 one output patterns
            //
            double out[][] = {{DOWN},{DOWN},{DOWN},{DOWN},{FIRE},{FIRE},{FIRE},{FIRE}};
            
            System.out.println("load ./tc.bpn and check if it works still good ...");
            
            //
            // Load the network structure from the file tc.bpn
            //
            myBPN = new BPN(".","tc.bpn");
            
            //
            // test each input pattern, it should give output pattern table correctly
            //
            for(int i=0; i<in.length; i++){
            
                //
                // Take 'i'th pattern from input table and make it
                // propagate through the network
                //
                myBPN.propagate(in[i]);
                
                //
                // print this input pattern
                //
                double input[] = in[i];
                System.out.print("input = {");
                for(int h=0; h<input.length; h++)
                    System.out.print(" "+bool(input[h]));
                System.out.print(" }  ");
                
                //
                // Fetch output result from the network
                //
                double output[] = myBPN.getOutputVector();
                
                //
                // print computed output
                //
                System.out.print("output = {");
                for(int h=0; h<output.length; h++)
                    System.out.print(" "+bool(output[h]));
                
                //
                // print output table (right result)
                //
                System.out.println(" }    right is "+bool(out[i][0]));
            }            

        }catch(BPNException bpne){
            //
            // If an error should rise then print it
            //
            System.out.println(bpne);
        }
    }
    
    //
    // return true, false or unfef
    //
    public static String bool(double x){
        return (x>0.5)? "true ":(x< -0.5)? "false": "undef";
    }
    


}
