/*
	A basic extension of the java.awt.Frame class
 */

import java.awt.*;
import java.io.*;
import java.awt.image.*;

import symantec.itools.multimedia.ImageViewer;
public class ImageFrame extends Frame
{
   
    Image img;  //spatial image
    boolean verbose=false;
    
    
	public ImageFrame()
	{
	    
		// This code is automatically generated by Visual Cafe when you add
		// components to the visual environment. It instantiates and initializes
		// the components. To modify the code, only use code syntax that matches
		// what Visual Cafe can generate, or Visual Cafe may be unable to back
		// parse your Java file into its visual environment.
		//{{INIT_CONTROLS
		setLayout(null);
		setBackground(java.awt.Color.white);
		setForeground(java.awt.Color.black);
		setSize(281,285);
		setVisible(false);
		button_Hide.setLabel("Hide");
		add(button_Hide);
		button_Hide.setBackground(java.awt.Color.lightGray);
		button_Hide.setBounds(0,0,48,24);
		add(imageViewer);
		imageViewer.setBounds(36,36,195,168);
		saveFileDialog1.setMode(FileDialog.SAVE);
		saveFileDialog1.setTitle("Save");
		saveFileDialog1.setFile("*.raw");
		//$$ saveFileDialog1.move(0,0);
		button1.setLabel("button");
		add(button1);
		button1.setBackground(java.awt.Color.lightGray);
		button1.setBounds(132,120,8,8);
		setTitle("Input");
		//}}

		//{{INIT_MENUS
		menu1.setLabel("File");
		menu1.add(miSave);
		miSave.setLabel("Save Raw Data");
		miSave.setShortcut(new MenuShortcut(java.awt.event.KeyEvent.VK_S,false));
		menu1.add(miHide);
		miHide.setLabel("Hide");
		mainMenuBar.add(menu1);
		//$$ mainMenuBar.move(48,0);
		setMenuBar(mainMenuBar);
		//}}

		//{{REGISTER_LISTENERS
		SymWindow aSymWindow = new SymWindow();
		this.addWindowListener(aSymWindow);
		SymAction lSymAction = new SymAction();
		button_Hide.addActionListener(lSymAction);
		miSave.addActionListener(lSymAction);
		miHide.addActionListener(lSymAction);
		SymItem lSymItem = new SymItem();
		//}}
	}

	public ImageFrame(String title)
	{
		this();
		setTitle(title);
	}
	/**
	 *Stores the spatial image in case want to toggle
	 * the display between this and wavelet image
	 */
	public void setImage(Image image)
	{  img = image;
	   try{
	    imageViewer.setImage(img);
	    }catch(Exception e)
	    { }
	    try{
	        imageViewer.setSize(img.getWidth(this),img.getHeight(this));
	        this.setSize(img.getWidth(this)+200, img.getHeight(this)+200);
	        repaint();       
	    } catch(Exception e) {}   
	}    
	
	
	   
	   
	/**
	 *Stores the currently displayed image data into
	 * a file as raw GREYSCALE image data format
	 */
	public void storeGreyscaleImage(String filename)throws IOException
	{ 
	  
	    int rows, cols, pixel, alpha, red, green,blue;
	    
	    
            
	        
        //Open up file	
        FileOutputStream file_output = new FileOutputStream(filename);
        DataOutputStream DO = new DataOutputStream(file_output);
 
 
        //Write out each pixel as integers
        rows = img.getHeight(this);
        cols = img.getWidth(this);
        int pixels[] = new int[rows*cols];
        PixelGrabber pg = new PixelGrabber(img, 0,0, cols, rows, pixels, 0, rows);
        try{ pg.grabPixels();}
        catch(InterruptedException e) {
    	    System.err.println("interrupted waiting for pixels!");
    	}
	
         
        for(int r=0; r<rows; r++)
	    for(int c=0; c<cols; c++) {
            pixel = pixels[r*cols + c];
	        alpha = (pixel >> 24) & 0xff;
            red   = (pixel >> 16) & 0xff;
            green = (pixel >>  8) & 0xff;
            blue  = (pixel      ) & 0xff;
            
            if(verbose)
    	        {System.out.println("value: " + (int)((red+green+blue)/3));
    	         System.out.println(" R,G,B: " + red +"," + green +"," + blue); }
	   
 	        DO.writeByte((int)((red+green+blue)/3));	
 	        
        }	

        //flush Stream
        DO.flush();
        //close Stream
        DO.close();

    }
    
    
    /**
	 *Stores the currently displayed image data into
	 * a file as COLOR raw image data format
	 */
	public void storeColorImage(String filename)throws IOException
	{ 
	    
	    int rows, cols, pixel, alpha, red, green,blue;
	    
	   
            
	        
        //Open up file	
        FileOutputStream file_output = new FileOutputStream(filename);
        DataOutputStream DO = new DataOutputStream(file_output);
 
 
        //Write out each pixel as integers
        rows = img.getHeight(this);
        cols = img.getWidth(this);
        int pixels[] = new int[rows*cols];
        PixelGrabber pg = new PixelGrabber(img, 0,0, cols, rows, pixels, 0, cols);
        try{ pg.grabPixels();}
        catch(InterruptedException e) {
    	    System.err.println("interrupted waiting for pixels!");
    	}
	
        System.out.println("...storing as color, "+rows +" x " + cols);
        
        for(int r=0; r<rows; r++)
	    for(int c=0; c<cols; c++) {
            pixel = pixels[r*cols + c];
	        alpha = (pixel >> 24) & 0xff;
            red   = (pixel >> 16) & 0xff;
            green = (pixel >>  8) & 0xff;
            blue  = (pixel      ) & 0xff;
            if(verbose)//verbose
    	        {System.out.println("value: " + (int)((red+green+blue)/3));
    	         System.out.println(" R,G,B: " + red +"," + green +"," + blue); }
	   
 	        DO.writeByte(red);
 	        DO.writeByte(green);
 	        DO.writeByte(blue);
        }	

        //flush Stream
        DO.flush();
        //close Stream
        DO.close();

    }
    

    /**
     * Shows or hides the component depending on the boolean flag b.
     * @param b  if true, show the component; otherwise, hide the component.
     * @see java.awt.Component#isVisible
     */
    public void setVisible(boolean b)
	{
		if(b)
		{
			setLocation(50, 50);
		}
		super.setVisible(b);
	}

	static public void main(String args[])
	{
		(new ImageFrame()).setVisible(true);
	}
	
	public void addNotify()
	{
	    // Record the size of the window prior to calling parents addNotify.
	    Dimension d = getSize();
	    
		super.addNotify();

		if (fComponentsAdjusted)
			return;

		// Adjust components according to the insets
		setSize(insets().left + insets().right + d.width, insets().top + insets().bottom + d.height);
		Component components[] = getComponents();
		for (int i = 0; i < components.length; i++)
		{
			Point p = components[i].getLocation();
			p.translate(insets().left, insets().top);
			components[i].setLocation(p);
		}
		fComponentsAdjusted = true;
	}

    // Used for addNotify check.
	boolean fComponentsAdjusted = false;

	//{{DECLARE_CONTROLS
	java.awt.Button button_Hide = new java.awt.Button();
	symantec.itools.multimedia.ImageViewer imageViewer = new symantec.itools.multimedia.ImageViewer();
	java.awt.FileDialog saveFileDialog1 = new java.awt.FileDialog(this);
	java.awt.Button button1 = new java.awt.Button();
	//}}

	//{{DECLARE_MENUS
	java.awt.MenuBar mainMenuBar = new java.awt.MenuBar();
	java.awt.Menu menu1 = new java.awt.Menu();
	java.awt.MenuItem miSave = new java.awt.MenuItem();
	java.awt.MenuItem miHide = new java.awt.MenuItem();
	//}}

	class SymWindow extends java.awt.event.WindowAdapter
	{
		public void windowOpened(java.awt.event.WindowEvent event)
		{
			Object object = event.getSource();
			if (object == ImageFrame.this)
				ImageFrame_WindowOpened(event);
		}

		public void windowClosing(java.awt.event.WindowEvent event)
		{
			Object object = event.getSource();
			if (object == ImageFrame.this)
				Frame1_WindowClosing(event);
		}
	}
	
	void Frame1_WindowClosing(java.awt.event.WindowEvent event)
	{
		setVisible(false);		 // hide the Frame
	}

	class SymAction implements java.awt.event.ActionListener
	{
		public void actionPerformed(java.awt.event.ActionEvent event)
		{
			Object object = event.getSource();
			if (object == button_Hide)
				buttonHide_ActionPerformed(event);
			else if (object == miSave)
				miSave_ActionPerformed(event);
			else if (object == miHide)
				miHide_ActionPerformed(event);
			
		}
	}

	void buttonHide_ActionPerformed(java.awt.event.ActionEvent event)
	{
		// to do: code goes here.
			 
		//{{CONNECTION
		// Hide the Frame
		setVisible(false);
		//}}
	}

    /**
      *Save Image data in raw format
      */
	void miSave_ActionPerformed(java.awt.event.ActionEvent event)
	{
		// to do: code goes here.
		String Save_filename;	 
			 
		//{{CONNECTION
		// Show the SaveFileDialog
		saveFileDialog1.setVisible(true);
		//}}
		
		//GET FILENAME
		Save_filename = (saveFileDialog1.getDirectory()).concat(saveFileDialog1.getFile()); 
		System.out.println("Save info: " + Save_filename);
		
		//Store currently displayed info
		try {
    		storeColorImage(Save_filename);
        } catch (IOException e)
        {}
		
	}

	void miHide_ActionPerformed(java.awt.event.ActionEvent event)
	{
		// to do: code goes here.
			 
		//{{CONNECTION
		// Hide the Frame
		setVisible(false);
		//}}
	}

	class SymItem implements java.awt.event.ItemListener
	{
		public void itemStateChanged(java.awt.event.ItemEvent event)
		{
		}
	}
	

	void ImageFrame_WindowOpened(java.awt.event.WindowEvent event)
	{
		// to do: code goes here.
	}
}
