/*
 * modified class from java tutorials:
 * http://www.java2s.com/Code/Java/Event/Dragswithintheimage.htm
 */


import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.event.MouseInputAdapter;
import java.awt.*;
import java.awt.event.MouseEvent;


public class SelectionArea extends JLabel
{
    Rectangle currentRect = null;
    Rectangle rectToDraw = null;
    Rectangle previousRectDrawn = new Rectangle();
    ImageApplication imageApp;

    int maxX, maxY;	//Max coordinates for our drawing area
    
    public void setxMax(int x)
    {maxX=x;}
    
    public void setyMax(int y)
    {maxY=y;}
    
    public void setImage(ImageIcon image)
    {
    	currentRect=null;
    	setIcon(image);
    	setSize(image.getIconWidth(),image.getIconHeight());
    }
    public Rectangle getRectangle()
    {
     return currentRect;
    }
    
    public SelectionArea(ImageApplication imgApp)
    {
    	imageApp=imgApp;
        MyListener myListener = new MyListener();
        addMouseListener(myListener);
        addMouseMotionListener(myListener);
    }
    
    private class MyListener extends MouseInputAdapter {
      public void mousePressed(MouseEvent e) {
    	  
        int x = e.getX();
        int y = e.getY();
        imageApp.roiMenuItem.setEnabled(false);
	        if (x <= maxX && y <= maxY)
	        {
		        currentRect = new Rectangle(x, y, 0, 0);
		        updateDrawableRect(getWidth(), getHeight());
		        repaint(); 
	        }
      }

      public void mouseDragged(MouseEvent e) {
        updateSize(e);
      }

      public void mouseReleased(MouseEvent e) {
    	if (currentRect!=null)
    		if (!(currentRect.getWidth()==0 && currentRect.getHeight()==0))
    		 imageApp.roiMenuItem.setEnabled(true);
        updateSize(e);
      }

      /*
       * Update the size of the current rectangle and call repaint.
       * Because currentRect always has the same origin, translate it if
       * the width or height is negative.
       * 
       * For efficiency (though that isn't an issue for this program),
       * specify the painting region using arguments to the repaint()
       * call.
       *  
       */
      void updateSize(MouseEvent e) 
      {
        int x = e.getX();
        int y = e.getY();
        
	        if (currentRect!=null && (x <= maxX && y <= maxY) )
	        { 
		        currentRect.setSize(x - currentRect.x, y - currentRect.y);
		        updateDrawableRect(getWidth(), getHeight());
		        Rectangle totalRepaint = rectToDraw.union(previousRectDrawn);
		        repaint(totalRepaint.x, totalRepaint.y, totalRepaint.width,
		            totalRepaint.height);
	        }
	        else  imageApp.roiMenuItem.setEnabled(false);
      }
    }

    protected void paintComponent(Graphics g) 
    {
      super.paintComponent(g); //paints the background and image
      
      //If currentRect exists, paint a box on top.
      if (currentRect != null) {
        //Draw a rectangle on top of the image.
        g.setXORMode(Color.white); //Color of line varies
        //depending on image colors
        g.drawRect(rectToDraw.x, rectToDraw.y, rectToDraw.width - 1,
            rectToDraw.height - 1);
      }
      else imageApp.roiMenuItem.setEnabled(false);
    }
	
    private void updateDrawableRect(int compWidth, int compHeight) {
      int x = currentRect.x;
      int y = currentRect.y;
      int width = currentRect.width;
      int height = currentRect.height;
      
      //Make the width and height positive, if necessary.
      if (width < 0) {
        width = 0 - width;
        x = x - width + 1;
        if (x < 0) {
          width += x;
          x = 0;
        }
      }
      if (height < 0) {
        height = 0 - height;
        y = y - height + 1;
        if (y < 0) {
          height += y;
          y = 0;
        }
      }

      //The rectangle shouldn't extend past the drawing area.
      if ((x + width) > compWidth) {
        width = compWidth - x;
      }
      if ((y + height) > compHeight) {
        height = compHeight - y;
      }

      //Update rectToDraw after saving old value.
      if (rectToDraw != null) {
        previousRectDrawn.setBounds(rectToDraw.x, rectToDraw.y,
            rectToDraw.width, rectToDraw.height);
        rectToDraw.setBounds(x, y, width, height);
      } 
      else 
        rectToDraw = new Rectangle(x, y, width, height);
    }
  }