/*
	This simple extension of the java.awt.Frame class
	contains all the elements necessary to act as the
	main window of an application.
 */

import java.awt.*;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

import javax.imageio.ImageIO;
import javax.swing.*;

public class ImageApplication extends Frame
{
    Image img; 					//represents current image working on.
    ImageIcon imageIcon;

    ImageData ActiveImage, BackupImage;
    
    SelectionArea area;	// for ROI drawing
    boolean verbose=false;
    
	public ImageApplication()
	{
		//{{INIT_CONTROLS
		setSize(405,305);
		setResizable(false);		
		openFileDialog1.setMode(FileDialog.LOAD);
		openFileDialog1.setTitle("Open");
		setTitle("Project 2 Phase 1");
		//}}
		
		//{{INIT_MENUS
		menu1.setLabel("File");
		menu2.setLabel("Edit");
		menu1.add(openMenuItem);
		menu2.add(undoMenuItem);
		menu2.add(roiMenuItem);
		openMenuItem.setLabel("Open...");
		openMenuItem.setShortcut(new MenuShortcut(java.awt.event.KeyEvent.VK_O,false));
		menu1.add(saveMenuItem);
		saveMenuItem.setEnabled(false);
		undoMenuItem.setEnabled(false);
		roiMenuItem.setEnabled(false);
		saveMenuItem.setLabel("Save As..");
		undoMenuItem.setLabel("Undo");
		roiMenuItem.setLabel("ROI");
		undoMenuItem.setShortcut(new MenuShortcut(java.awt.event.KeyEvent.VK_Z,false));
		saveMenuItem.setShortcut(new MenuShortcut(java.awt.event.KeyEvent.VK_S,false));
		menu1.add(separatorMenuItem);
		separatorMenuItem.setLabel("-");
		menu1.add(exitMenuItem);
		exitMenuItem.setLabel("Exit");
		mainMenuBar.add(menu1);
		mainMenuBar.add(menu2);
		menu3.setLabel("Help");
		menu3.add(aboutMenuItem);
		aboutMenuItem.setLabel("About...");
		mainMenuBar.add(menu3);
		//$$ mainMenuBar.move(0,312);
		setMenuBar(mainMenuBar);
		
		saveFileDialog1.setMode(FileDialog.SAVE);
		saveFileDialog1.setTitle("Save");
		saveFileDialog1.setFile("");
		//}}
		
		//{{REGISTER_LISTENERS
		SymWindow aSymWindow = new SymWindow();
		this.addWindowListener(aSymWindow);
		SymAction lSymAction = new SymAction();
		openMenuItem.addActionListener(lSymAction);
		exitMenuItem.addActionListener(lSymAction);
		aboutMenuItem.addActionListener(lSymAction);
		saveMenuItem.addActionListener(lSymAction);
		roiMenuItem.addActionListener(lSymAction);
		undoMenuItem.addActionListener(lSymAction);
		//}}

		imageIcon=new ImageIcon();	//imageicon for image display
	    area =new SelectionArea(this); //initialize one selection area
	    add(area);						//add the component
	}
	
	public ImageApplication(String title)
	{
		this();
		setTitle(title);
	}
	
    /**
     * Shows or hides the component depending on the boolean flag b.
     * @param b  if true, show the component; otherwise, hide the component.
     * @see java.awt.Component#isVisible
     */
    public void setVisible(boolean b)
	{
		if(b)
		{
			setLocation(50, 50);
		}	
		super.setVisible(b);
	}
	
	static public void main(String args[])
	{
		try
		{
			//Create a new instance of our application's frame, and make it visible.
    		(new ImageApplication()).setVisible(true);
		}
		catch (Throwable t)
		{
			System.err.println(t);
			t.printStackTrace();
			//Ensure the application exits with an error condition.
			System.exit(1);
		}
	}
	
    /**
     * Sets the image and calls the gui model, repainting the imageicon in the process
     * @param image the image to set to
     */
	public void setImage(Image image)
	{ 
			  img = image;
	          createAndShowGUI();				
	          saveMenuItem.setEnabled(true);	//now can save an image
	}
	
    /**
     * Main gui model which interacts with SelectionArea
     */    
	public void createAndShowGUI()
	{
			   imageIcon.setImage(img);
			   
			   area.setImage(imageIcon);
			   area.setxMax(img.getWidth(this));
			   area.setyMax(img.getHeight(this));

			   pack();
	}
	public void addNotify()
	{
		// Record the size of the window prior to calling parents addNotify.
		Dimension d = getSize();
		
		super.addNotify();
	
		if (fComponentsAdjusted)
			return;
	
		// Adjust components according to the insets
		setSize(getInsets().left + getInsets().right + d.width, getInsets().top + getInsets().bottom + d.height);
		Component components[] = getComponents();
		for (int i = 0; i < components.length; i++)
		{
			Point p = components[i].getLocation();
			p.translate(getInsets().left, getInsets().top);
			components[i].setLocation(p);
		}
		fComponentsAdjusted = true;

	}
	
	// Used for addNotify check.
	boolean fComponentsAdjusted = false;
	
	//{{DECLARE_CONTROLS
	java.awt.FileDialog openFileDialog1 = new java.awt.FileDialog(this);
	java.awt.Label label_title = new java.awt.Label();
	//}}
	
	//{{DECLARE_MENUS
	java.awt.MenuBar mainMenuBar = new java.awt.MenuBar();
	java.awt.Menu menu1 = new java.awt.Menu();
	java.awt.Menu menu2 = new java.awt.Menu();
	java.awt.MenuItem openMenuItem = new java.awt.MenuItem();
	java.awt.MenuItem saveMenuItem = new java.awt.MenuItem();
	java.awt.MenuItem separatorMenuItem = new java.awt.MenuItem();
	java.awt.MenuItem exitMenuItem = new java.awt.MenuItem();
	java.awt.Menu menu3 = new java.awt.Menu();
	java.awt.MenuItem aboutMenuItem = new java.awt.MenuItem();
	java.awt.MenuItem undoMenuItem= new java.awt.MenuItem();
	java.awt.MenuItem roiMenuItem= new java.awt.MenuItem();
	java.awt.FileDialog saveFileDialog1 = new java.awt.FileDialog(this);
	//}}
	
	class SymWindow extends java.awt.event.WindowAdapter
	{
		public void windowClosing(java.awt.event.WindowEvent event)
		{
			Object object = event.getSource();
			if (object == ImageApplication.this)
				ImageApplication_WindowClosing(event);
		}
	}
	
	void ImageApplication_WindowClosing(java.awt.event.WindowEvent event)
	{
		// to do: code goes here.
			 
		ImageApplication_WindowClosing_Interaction1(event);
	}


	void ImageApplication_WindowClosing_Interaction1(java.awt.event.WindowEvent event)
	{
		try {
			this.dispose();
			// QuitDialog Create and show as modal
		//	(new QuitDialog(this, true)).setVisible(true);
		} catch (Exception e) {
		}
	}

	
	class SymAction implements java.awt.event.ActionListener
	{
		public void actionPerformed(java.awt.event.ActionEvent event)
		{
			Object object = event.getSource();
			if (object == openMenuItem)
				openMenuItem_ActionPerformed(event);
			else if (object == aboutMenuItem)
				aboutMenuItem_ActionPerformed(event);
			else if (object == saveMenuItem)
				saveMenuItem_ActionPerformed(event);
			else if (object == exitMenuItem)
				exitMenuItem_ActionPerformed(event);
			else if (object == roiMenuItem)
				roiMenuItem_ActionPerformed(event);
			else if (object == undoMenuItem)
				undoMenuItem_ActionPerformed(event);
		}
	}
	
	void openMenuItem_ActionPerformed(java.awt.event.ActionEvent event)
	{
		// to do: code goes here.	 
		openMenuItem_ActionPerformed_Interaction1(event);
	}

    //Method to open Image, either JPEG or GIF
    //loads image into img class variable and
    //calls method to display the image in a
    //new frame, called frame_image_display.

	void openMenuItem_ActionPerformed_Interaction1(java.awt.event.ActionEvent event)
	{
		try {
			// OpenFileDialog Create and show as modal
		    int		defMode         = openFileDialog1.getMode();
		    String	defTitle        = openFileDialog1.getTitle();
		    String defDirectory     = openFileDialog1.getDirectory();
		    String defFile          = "*.jpg;*.gif";

		    openFileDialog1 = new java.awt.FileDialog(this, defTitle, defMode);
		    openFileDialog1.setDirectory(defDirectory);
		    openFileDialog1.setFile(defFile);
		    openFileDialog1.setVisible(true);
		    
		    //Print out to console the name of file selected
		    String Filename1 = (openFileDialog1.getDirectory()).concat(openFileDialog1.getFile());
		    System.out.println("Opening: " + Filename1);
			 
		    img = (java.awt.Toolkit.getDefaultToolkit()).getImage(Filename1);
		    MediaTracker tracker = new MediaTracker(this);
	        tracker.addImage(img, 0);
	        try {
                tracker.waitForID(0); //wait until image loaded
            }catch (InterruptedException e)
             { System.out.println("Can't load image " + Filename1); 
               return; }
            
		     ActiveImage = 
			    	new ImageData(img, "JPEG", img.getHeight(this), img.getWidth(this));
		     BackupImage=ActiveImage;
		     
            setImage(img);
            repaint();
		
		} catch (Exception e) {
		}
	}


	void aboutMenuItem_ActionPerformed(java.awt.event.ActionEvent event)
	{
		// to do: code goes here.	 
		aboutMenuItem_ActionPerformed_Interaction1(event);
	}


	void aboutMenuItem_ActionPerformed_Interaction1(java.awt.event.ActionEvent event)
	{
		try {
			// AboutDialog Create and show as modal
			(new AboutDialog(this, true)).setVisible(true);
		} catch (Exception e) {
		}
	}
	
	
	void exitMenuItem_ActionPerformed(java.awt.event.ActionEvent event)
	{
		// to do: code goes here.
			 
		exitMenuItem_ActionPerformed_Interaction1(event);
	}


	void exitMenuItem_ActionPerformed_Interaction1(java.awt.event.ActionEvent event)
	{
		try {
			// QuitDialog Create and show as modal
			this.dispose();
		//    (new QuitDialog(this, true)).setVisible(true);
		} catch (Exception e) {
		}
	}
	void saveMenuItem_ActionPerformed(java.awt.event.ActionEvent event)
	{
		// to do: code goes here.
		String Save_filename;	 
			 
		//{{CONNECTION
		// Show the SaveFileDialog
		saveFileDialog1.setVisible(true);
		//}}
		
		//GET FILENAME
		Save_filename = (saveFileDialog1.getDirectory()).concat(saveFileDialog1.getFile()); 
		System.out.println("Save info: " + Save_filename);
		
		//Store currently displayed info
		try {
    		storeColorImage(Save_filename);
        } catch (IOException e)
        {}
		
	}
	void undoMenuItem_ActionPerformed(java.awt.event.ActionEvent event)
	{
		ActiveImage=BackupImage;
		img=BackupImage.createImage();
		setImage(img);
		undoMenuItem.setEnabled(false);
	}
	
	void roiMenuItem_ActionPerformed(java.awt.event.ActionEvent event)
	{
		Rectangle drawnRect =area.getRectangle();
		int xpos, ypos, width, height;
		
		if (drawnRect==null)
		 System.out.println("null");
		else 
		{
			xpos=drawnRect.x;
			ypos=drawnRect.y;
			width=drawnRect.width;
			height=drawnRect.height;
			
			if (width <0 && height >0)
			{ 	xpos=xpos+width; width=-width;}
			else if (width<0 && height <0)
			{ 	xpos=xpos+width; ypos=ypos+height; width=-width; height=-height;}
			else if (width > 0 && height < 0)
			{ 	ypos=ypos+height; height=-height;}
			
			BackupImage=new ImageData(ActiveImage.rows, ActiveImage.cols, ActiveImage,
					0, 0);
			ActiveImage=new ImageData(height, width, ActiveImage, ypos, xpos);
			undoMenuItem.setEnabled(true);
			img=ActiveImage.createImage();
			setImage(img);
		}
	}
	
	
	public void storeColorImage(String filename)throws IOException
	{ 
	    
	    int rows, cols, pixel, alpha, red, green,blue;
	    
	    BufferedImage bImg=Pictures.toBufferedImage(img);
	    
	    String type=filename.substring(filename.length()-3);
	    
	    if ( (type.toUpperCase().equals("GIF") ||
	    		type.toUpperCase().equals("JPG") || type.toUpperCase().equals("JPEG")))
	    	ImageIO.write(bImg, type, new File(filename+"."));
	    else ImageIO.write(bImg, "jpg", new File(filename+".jpg"));
	}
	
	public void storeGreyscaleImage(String filename)throws IOException
	{ 
	  
	    int rows, cols, pixel, alpha, red, green,blue;
	    
        //Open up file	
        FileOutputStream file_output = new FileOutputStream(filename);
        DataOutputStream DO = new DataOutputStream(file_output);
 
 
        //Write out each pixel as integers
        rows = img.getHeight(this);
        cols = img.getWidth(this);
        int pixels[] = new int[rows*cols];
        PixelGrabber pg = new PixelGrabber(img, 0,0, cols, rows, pixels, 0, rows);
        try{ pg.grabPixels();}
        catch(InterruptedException e) {
    	    System.err.println("interrupted waiting for pixels!");
    	}
	
         
        for(int r=0; r<rows; r++)
	    for(int c=0; c<cols; c++) {
            pixel = pixels[r*cols + c];
	        alpha = (pixel >> 24) & 0xff;
            red   = (pixel >> 16) & 0xff;
            green = (pixel >>  8) & 0xff;
            blue  = (pixel      ) & 0xff;
            
            if(verbose)
    	        {System.out.println("value: " + (int)((red+green+blue)/3));
    	         System.out.println(" R,G,B: " + red +"," + green +"," + blue); }
	   
 	        DO.writeByte((int)((red+green+blue)/3));	
 	        
        }	

        //flush Stream
        DO.flush();
        //close Stream
        DO.close();

    }
}

