﻿# Contributing

You don't need to be a developer to make a significant
impact on TensorFlow documentation and examples-—just a
[GitHub account](https://github.com/). 

Questions about TensorFlow usage are best addressed on
[StackOverflow](https://stackoverflow.com/questions/tagged/tensorflow) or the
[discuss@tensorflow.org](https://groups.google.com/a/tensorflow.org/forum/#!forum/discuss)
mailing list.

To contribute to the TensorFlow code repositories, see the
[Contributing to TensorFlow](https://www.tensorflow.org/community/contributing) guide
and the
[TensorFlow contribution guidelines](https://github.com/tensorflow/tensorflow/blob/master/CONTRIBUTING.md).

## Contributor License Agreements

We love patches! To publish your changes, you must sign either the individual or
corporate Contributor License Agreement (CLA):

* If you are an individual writing original documentation or source code and
  you're sure you own the intellectual property, sign an
  [individual CLA](http://code.google.com/legal/individual-cla-v1.0.html).
* If you work for a company that wants to allow you to contribute your work, sign
  a [corporate CLA](http://code.google.com/legal/corporate-cla-v1.0.html).

We can accept your pull requests after you sign the CLA. We can only receive
original documentation and source code from you and other people that have
signed the CLA.


# Pull requests

To contribute documentation or code, please send us a pull request. If you are new to
pull requests, read GitHub's
[Creating a pull request from a fork](https://help.github.com/articles/creating-a-pull-request-from-a-fork/)
guide.

Notebooks can be viewed, edited, and run in
[Colab](https://colab.research.google.com/notebooks/welcome.ipynb) by passing
the GitHub path as a URL parameter. For example, open the notebook at
https://github.com/tensorflow/docs/blob/r1.11/site/en/tutorials/keras/basic_classification.ipynb
in Colab here:
https://colab.research.google.com/github/tensorflow/docs/blob/r1.11/site/en/tutorials/keras/basic_classification.ipynb

The [Open in Colab](https://chrome.google.com/webstore/detail/open-in-colab/iogfkhleblhcpcekbiedikdehleodpjo)
Chrome extension will automatically perform the URL substitution.
