package computervision.grewe.opencv3_android_app;

import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Spinner;

import org.opencv.android.BaseLoaderCallback;
import org.opencv.android.CameraBridgeViewBase;
import org.opencv.android.LoaderCallbackInterface;
import org.opencv.android.OpenCVLoader;
import org.opencv.android.CameraBridgeViewBase.CvCameraViewListener2;
import org.opencv.core.Mat;
import org.opencv.android.CameraBridgeViewBase.CvCameraViewFrame;
import org.opencv.imgproc.Imgproc;

import android.widget.AdapterView.OnItemSelectedListener;

import java.util.Random;


public class HelloOpenCvActivity extends AppCompatActivity implements CvCameraViewListener2, OnItemSelectedListener
{


    CameraBridgeViewBase mOpenCvCameraView;// will point to our View widget for our image
    Spinner spinner_menu;

    //grab array of possible menu items from strings.xml file
    String[] menu_items;

    String menu_item_selected;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_hello_open_cv);

        //setup menu from strings.xml file
        this.menu_items = getResources().getStringArray(R.array.spinner_menu);
        this.menu_item_selected = menu_items[0];  //initialize to first item in arry
       Log.i("SPINNER", "menu item is " + this.menu_item_selected);


        //grab a handle to spinner_menu in the XML interface
        spinner_menu = (Spinner)findViewById(R.id.spinner_menu);
        // Create an ArrayAdapter using the string array and a default spinner layout
        ArrayAdapter<CharSequence> adapter = ArrayAdapter.createFromResource(this, R.array.spinner_menu, android.R.layout.simple_spinner_item);
        // Specify the layout to use when the list of choices appears
        adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        // Apply the adapter to the spinner
        spinner_menu.setAdapter(adapter);
        spinner_menu.setSelection(0);//initialize to first item in menu
        //set this activity to listen to the menu choice in spinner
        spinner_menu.setOnItemSelectedListener(this);

        //grab a "handle" to the OpenCV class responsible for viewing Image
        // look at the XML the id of our CamerBridgeViewBase is HelloOpenCVView
        mOpenCvCameraView = (CameraBridgeViewBase) findViewById(R.id.HelloOpenCvView);
        mOpenCvCameraView.setVisibility(CameraBridgeViewBase.VISIBLE);
        mOpenCvCameraView.setCvCameraViewListener(this);  //the activity will listen to events on Camera
        }


    //Code will tell us when camera connected it will enable the mOpenCVCameraView
    private BaseLoaderCallback mLoaderCallback = new BaseLoaderCallback(this) {
        @Override
        public void onManagerConnected(int status) {
            switch (status) {
                case LoaderCallbackInterface.SUCCESS:
                {
                    Log.i("OPENCV", "OpenCV loaded successfully");

                    mOpenCvCameraView.enableView();
                } break;
                default:
                {
                    super.onManagerConnected(status);
                } break;
            }
        }
    };


    @Override  public void onResume()  {
        super.onResume();
        OpenCVLoader.initAsync(OpenCVLoader.OPENCV_VERSION_3_1_0, this, mLoaderCallback);
    }


    @Override
    public void onPause()   {
        super.onPause();
        if (mOpenCvCameraView != null)
            mOpenCvCameraView.disableView();
    }


    public void onDestroy() {
        super.onDestroy();
        if (mOpenCvCameraView != null)
            mOpenCvCameraView.disableView();   }

    public void onCameraViewStarted(int width, int height) {   }

    public void onCameraViewStopped() {   }

    // THIS IS THE main method that is called each time you get a new Frame/Image
    // it should return a Mat that will be displayed in the corresponding JavaCameraView widget that should be part of the
    //  xml interface for this activity that is associated with this class's variable mOpenCvCameraView  which is
    //  associated with JavaCameraView widget (see onCreate method above)
    public Mat onCameraFrame(CameraBridgeViewBase.CvCameraViewFrame inputFrame) {
        Mat imageMat = inputFrame.rgba();


        Mat gray = inputFrame.gray();


        // now you use the Mat class to represent the Image and you can use method calls

           // make calls like to get a pixel at i,j   imageMat.get
           // double pixel[] = new double[3];
           // pixel = imageMat.get(20,10);  this wil retrieve pixel and column = 20, row =10
        //similarly can set a pixel in Mat  via imageMat.set(i,j,pixel);
        // read API on Mat class for OPenCV

        // A VERY USEFUL class to call image processing routines is ImagProc
        // This code in comments shows how to do the Sobel Edge Detection on our image in imageMat
       /*
            Mat gray = inputFrame.gray();
            Mat mIntermediateMat = new Mat();
            Imgproc.Sobel(gray, mIntermediateMat, CvType.CV_8U, 1, 1);
            Core.convertScaleAbs(mIntermediateMat, mIntermediateMat, 10, 0);
            Imgproc.cvtColor(mIntermediateMat, imageMat, Imgproc.COLOR_GRAY2BGRA, 4);

         */


      //Based on spinner menu selected item stored as this.menu_item_selected perform appropriate
        // operation and return a Mat
        if(this.menu_item_selected.equals("Random")) {   //Random

            //return imageMat;
            //create random number 0 to 1 and return color if < .5 and grey otherwise
            Random rand = new Random(System.currentTimeMillis());

            if (rand.nextDouble() < 0.5)
            {    Log.d("SPINNER", "return color");  return imageMat;}
            else
            {    Log.d("SPINNER", "return greyscale"); return gray;}
        }
        else if(this.menu_item_selected.equals("Greyscale")) { //Greyscale
            Log.d("SPINNER", "return greyscale");
            return gray;
        }
        else if(this.menu_item_selected.equals("Threshold")) {  //currently always threshold the greyscale image at value of 50

            /* FROM OPENCV DOCUMENTATION :   threshold(Mat src,Mat dst,double thresh, double maxval,int type)

               The function applies fixed-level thresholding to a single-channel array.
               The function is typically used to get a bi-level (binary) image out of a grayscale image


                type = THRESH_BINARY
                   if src(x,y) > thresh  then dest(x,y) = maxval; 0 otherwise
            */
            Log.i("SPINNER", "performing thresholding");
            Imgproc.threshold(gray,gray, 50.0, 255.0, Imgproc.THRESH_BINARY );
            return gray;

        }
        else  //for now return color for all other choices
        {
            return gray;
        }

    }



    //Spinner Menu Selection response method
    public void onItemSelected(AdapterView<?> parent, View view, int pos, long id) {
        // An item was selected. You can retrieve the selected item using
        this.menu_item_selected = parent.getItemAtPosition(pos).toString();

        Log.i("SPINNER", "choice is" + this.menu_item_selected);


    }


    public void onNothingSelected(AdapterView<?> parent) {
        this.menu_item_selected = this.menu_items[0];
    }







}
