/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.dnn;

import java.util.List;
import org.opencv.core.Mat;
import org.opencv.core.MatOfByte;
import org.opencv.core.MatOfFloat;
import org.opencv.core.MatOfInt;
import org.opencv.core.MatOfRect;
import org.opencv.core.MatOfRect2d;
import org.opencv.core.MatOfRotatedRect;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.dnn.Net;
import org.opencv.utils.Converters;

public class Dnn {
    public static final int DNN_BACKEND_DEFAULT = 0;
    public static final int DNN_BACKEND_HALIDE = 1;
    public static final int DNN_BACKEND_INFERENCE_ENGINE = 2;
    public static final int DNN_BACKEND_OPENCV = 3;
    public static final int DNN_BACKEND_VKCOM = 4;
    public static final int DNN_TARGET_CPU = 0;
    public static final int DNN_TARGET_OPENCL = 1;
    public static final int DNN_TARGET_OPENCL_FP16 = 2;
    public static final int DNN_TARGET_MYRIAD = 3;
    public static final int DNN_TARGET_VULKAN = 4;
    public static final int DNN_TARGET_FPGA = 5;

    public static Mat blobFromImage(Mat image, double scalefactor, Size size, Scalar mean, boolean swapRB, boolean crop, int ddepth) {
        Mat retVal = new Mat(Dnn.blobFromImage_0(image.nativeObj, scalefactor, size.width, size.height, mean.val[0], mean.val[1], mean.val[2], mean.val[3], swapRB, crop, ddepth));
        return retVal;
    }

    public static Mat blobFromImage(Mat image, double scalefactor, Size size, Scalar mean, boolean swapRB, boolean crop) {
        Mat retVal = new Mat(Dnn.blobFromImage_1(image.nativeObj, scalefactor, size.width, size.height, mean.val[0], mean.val[1], mean.val[2], mean.val[3], swapRB, crop));
        return retVal;
    }

    public static Mat blobFromImage(Mat image, double scalefactor, Size size, Scalar mean, boolean swapRB) {
        Mat retVal = new Mat(Dnn.blobFromImage_2(image.nativeObj, scalefactor, size.width, size.height, mean.val[0], mean.val[1], mean.val[2], mean.val[3], swapRB));
        return retVal;
    }

    public static Mat blobFromImage(Mat image, double scalefactor, Size size, Scalar mean) {
        Mat retVal = new Mat(Dnn.blobFromImage_3(image.nativeObj, scalefactor, size.width, size.height, mean.val[0], mean.val[1], mean.val[2], mean.val[3]));
        return retVal;
    }

    public static Mat blobFromImage(Mat image, double scalefactor, Size size) {
        Mat retVal = new Mat(Dnn.blobFromImage_4(image.nativeObj, scalefactor, size.width, size.height));
        return retVal;
    }

    public static Mat blobFromImage(Mat image, double scalefactor) {
        Mat retVal = new Mat(Dnn.blobFromImage_5(image.nativeObj, scalefactor));
        return retVal;
    }

    public static Mat blobFromImage(Mat image) {
        Mat retVal = new Mat(Dnn.blobFromImage_6(image.nativeObj));
        return retVal;
    }

    public static Mat blobFromImages(List<Mat> images, double scalefactor, Size size, Scalar mean, boolean swapRB, boolean crop, int ddepth) {
        Mat images_mat = Converters.vector_Mat_to_Mat(images);
        Mat retVal = new Mat(Dnn.blobFromImages_0(images_mat.nativeObj, scalefactor, size.width, size.height, mean.val[0], mean.val[1], mean.val[2], mean.val[3], swapRB, crop, ddepth));
        return retVal;
    }

    public static Mat blobFromImages(List<Mat> images, double scalefactor, Size size, Scalar mean, boolean swapRB, boolean crop) {
        Mat images_mat = Converters.vector_Mat_to_Mat(images);
        Mat retVal = new Mat(Dnn.blobFromImages_1(images_mat.nativeObj, scalefactor, size.width, size.height, mean.val[0], mean.val[1], mean.val[2], mean.val[3], swapRB, crop));
        return retVal;
    }

    public static Mat blobFromImages(List<Mat> images, double scalefactor, Size size, Scalar mean, boolean swapRB) {
        Mat images_mat = Converters.vector_Mat_to_Mat(images);
        Mat retVal = new Mat(Dnn.blobFromImages_2(images_mat.nativeObj, scalefactor, size.width, size.height, mean.val[0], mean.val[1], mean.val[2], mean.val[3], swapRB));
        return retVal;
    }

    public static Mat blobFromImages(List<Mat> images, double scalefactor, Size size, Scalar mean) {
        Mat images_mat = Converters.vector_Mat_to_Mat(images);
        Mat retVal = new Mat(Dnn.blobFromImages_3(images_mat.nativeObj, scalefactor, size.width, size.height, mean.val[0], mean.val[1], mean.val[2], mean.val[3]));
        return retVal;
    }

    public static Mat blobFromImages(List<Mat> images, double scalefactor, Size size) {
        Mat images_mat = Converters.vector_Mat_to_Mat(images);
        Mat retVal = new Mat(Dnn.blobFromImages_4(images_mat.nativeObj, scalefactor, size.width, size.height));
        return retVal;
    }

    public static Mat blobFromImages(List<Mat> images, double scalefactor) {
        Mat images_mat = Converters.vector_Mat_to_Mat(images);
        Mat retVal = new Mat(Dnn.blobFromImages_5(images_mat.nativeObj, scalefactor));
        return retVal;
    }

    public static Mat blobFromImages(List<Mat> images) {
        Mat images_mat = Converters.vector_Mat_to_Mat(images);
        Mat retVal = new Mat(Dnn.blobFromImages_6(images_mat.nativeObj));
        return retVal;
    }

    public static Mat readTensorFromONNX(String path) {
        Mat retVal = new Mat(Dnn.readTensorFromONNX_0(path));
        return retVal;
    }

    public static Mat readTorchBlob(String filename, boolean isBinary) {
        Mat retVal = new Mat(Dnn.readTorchBlob_0(filename, isBinary));
        return retVal;
    }

    public static Mat readTorchBlob(String filename) {
        Mat retVal = new Mat(Dnn.readTorchBlob_1(filename));
        return retVal;
    }

    public static Net readNet(String framework, MatOfByte bufferModel, MatOfByte bufferConfig) {
        MatOfByte bufferModel_mat = bufferModel;
        MatOfByte bufferConfig_mat = bufferConfig;
        Net retVal = new Net(Dnn.readNet_0(framework, bufferModel_mat.nativeObj, bufferConfig_mat.nativeObj));
        return retVal;
    }

    public static Net readNet(String framework, MatOfByte bufferModel) {
        MatOfByte bufferModel_mat = bufferModel;
        Net retVal = new Net(Dnn.readNet_1(framework, bufferModel_mat.nativeObj));
        return retVal;
    }

    public static Net readNet(String model, String config, String framework) {
        Net retVal = new Net(Dnn.readNet_2(model, config, framework));
        return retVal;
    }

    public static Net readNet(String model, String config) {
        Net retVal = new Net(Dnn.readNet_3(model, config));
        return retVal;
    }

    public static Net readNet(String model) {
        Net retVal = new Net(Dnn.readNet_4(model));
        return retVal;
    }

    public static Net readNetFromCaffe(String prototxt, String caffeModel) {
        Net retVal = new Net(Dnn.readNetFromCaffe_0(prototxt, caffeModel));
        return retVal;
    }

    public static Net readNetFromCaffe(String prototxt) {
        Net retVal = new Net(Dnn.readNetFromCaffe_1(prototxt));
        return retVal;
    }

    public static Net readNetFromCaffe(MatOfByte bufferProto, MatOfByte bufferModel) {
        MatOfByte bufferProto_mat = bufferProto;
        MatOfByte bufferModel_mat = bufferModel;
        Net retVal = new Net(Dnn.readNetFromCaffe_2(bufferProto_mat.nativeObj, bufferModel_mat.nativeObj));
        return retVal;
    }

    public static Net readNetFromCaffe(MatOfByte bufferProto) {
        MatOfByte bufferProto_mat = bufferProto;
        Net retVal = new Net(Dnn.readNetFromCaffe_3(bufferProto_mat.nativeObj));
        return retVal;
    }

    public static Net readNetFromDarknet(String cfgFile, String darknetModel) {
        Net retVal = new Net(Dnn.readNetFromDarknet_0(cfgFile, darknetModel));
        return retVal;
    }

    public static Net readNetFromDarknet(String cfgFile) {
        Net retVal = new Net(Dnn.readNetFromDarknet_1(cfgFile));
        return retVal;
    }

    public static Net readNetFromDarknet(MatOfByte bufferCfg, MatOfByte bufferModel) {
        MatOfByte bufferCfg_mat = bufferCfg;
        MatOfByte bufferModel_mat = bufferModel;
        Net retVal = new Net(Dnn.readNetFromDarknet_2(bufferCfg_mat.nativeObj, bufferModel_mat.nativeObj));
        return retVal;
    }

    public static Net readNetFromDarknet(MatOfByte bufferCfg) {
        MatOfByte bufferCfg_mat = bufferCfg;
        Net retVal = new Net(Dnn.readNetFromDarknet_3(bufferCfg_mat.nativeObj));
        return retVal;
    }

    public static Net readNetFromModelOptimizer(String xml, String bin) {
        Net retVal = new Net(Dnn.readNetFromModelOptimizer_0(xml, bin));
        return retVal;
    }

    public static Net readNetFromONNX(String onnxFile) {
        Net retVal = new Net(Dnn.readNetFromONNX_0(onnxFile));
        return retVal;
    }

    public static Net readNetFromTensorflow(String model, String config) {
        Net retVal = new Net(Dnn.readNetFromTensorflow_0(model, config));
        return retVal;
    }

    public static Net readNetFromTensorflow(String model) {
        Net retVal = new Net(Dnn.readNetFromTensorflow_1(model));
        return retVal;
    }

    public static Net readNetFromTensorflow(MatOfByte bufferModel, MatOfByte bufferConfig) {
        MatOfByte bufferModel_mat = bufferModel;
        MatOfByte bufferConfig_mat = bufferConfig;
        Net retVal = new Net(Dnn.readNetFromTensorflow_2(bufferModel_mat.nativeObj, bufferConfig_mat.nativeObj));
        return retVal;
    }

    public static Net readNetFromTensorflow(MatOfByte bufferModel) {
        MatOfByte bufferModel_mat = bufferModel;
        Net retVal = new Net(Dnn.readNetFromTensorflow_3(bufferModel_mat.nativeObj));
        return retVal;
    }

    public static Net readNetFromTorch(String model, boolean isBinary, boolean evaluate) {
        Net retVal = new Net(Dnn.readNetFromTorch_0(model, isBinary, evaluate));
        return retVal;
    }

    public static Net readNetFromTorch(String model, boolean isBinary) {
        Net retVal = new Net(Dnn.readNetFromTorch_1(model, isBinary));
        return retVal;
    }

    public static Net readNetFromTorch(String model) {
        Net retVal = new Net(Dnn.readNetFromTorch_2(model));
        return retVal;
    }

    public static void NMSBoxes(MatOfRect bboxes, MatOfFloat scores, float score_threshold, float nms_threshold, MatOfInt indices, float eta, int top_k) {
        MatOfRect bboxes_mat = bboxes;
        MatOfFloat scores_mat = scores;
        MatOfInt indices_mat = indices;
        Dnn.NMSBoxes_0(bboxes_mat.nativeObj, scores_mat.nativeObj, score_threshold, nms_threshold, indices_mat.nativeObj, eta, top_k);
    }

    public static void NMSBoxes(MatOfRect bboxes, MatOfFloat scores, float score_threshold, float nms_threshold, MatOfInt indices, float eta) {
        MatOfRect bboxes_mat = bboxes;
        MatOfFloat scores_mat = scores;
        MatOfInt indices_mat = indices;
        Dnn.NMSBoxes_1(bboxes_mat.nativeObj, scores_mat.nativeObj, score_threshold, nms_threshold, indices_mat.nativeObj, eta);
    }

    public static void NMSBoxes(MatOfRect bboxes, MatOfFloat scores, float score_threshold, float nms_threshold, MatOfInt indices) {
        MatOfRect bboxes_mat = bboxes;
        MatOfFloat scores_mat = scores;
        MatOfInt indices_mat = indices;
        Dnn.NMSBoxes_2(bboxes_mat.nativeObj, scores_mat.nativeObj, score_threshold, nms_threshold, indices_mat.nativeObj);
    }

    public static void NMSBoxes(MatOfRect2d bboxes, MatOfFloat scores, float score_threshold, float nms_threshold, MatOfInt indices, float eta, int top_k) {
        MatOfRect2d bboxes_mat = bboxes;
        MatOfFloat scores_mat = scores;
        MatOfInt indices_mat = indices;
        Dnn.NMSBoxes_3(bboxes_mat.nativeObj, scores_mat.nativeObj, score_threshold, nms_threshold, indices_mat.nativeObj, eta, top_k);
    }

    public static void NMSBoxes(MatOfRect2d bboxes, MatOfFloat scores, float score_threshold, float nms_threshold, MatOfInt indices, float eta) {
        MatOfRect2d bboxes_mat = bboxes;
        MatOfFloat scores_mat = scores;
        MatOfInt indices_mat = indices;
        Dnn.NMSBoxes_4(bboxes_mat.nativeObj, scores_mat.nativeObj, score_threshold, nms_threshold, indices_mat.nativeObj, eta);
    }

    public static void NMSBoxes(MatOfRect2d bboxes, MatOfFloat scores, float score_threshold, float nms_threshold, MatOfInt indices) {
        MatOfRect2d bboxes_mat = bboxes;
        MatOfFloat scores_mat = scores;
        MatOfInt indices_mat = indices;
        Dnn.NMSBoxes_5(bboxes_mat.nativeObj, scores_mat.nativeObj, score_threshold, nms_threshold, indices_mat.nativeObj);
    }

    public static void NMSBoxesRotated(MatOfRotatedRect bboxes, MatOfFloat scores, float score_threshold, float nms_threshold, MatOfInt indices, float eta, int top_k) {
        MatOfRotatedRect bboxes_mat = bboxes;
        MatOfFloat scores_mat = scores;
        MatOfInt indices_mat = indices;
        Dnn.NMSBoxesRotated_0(bboxes_mat.nativeObj, scores_mat.nativeObj, score_threshold, nms_threshold, indices_mat.nativeObj, eta, top_k);
    }

    public static void NMSBoxesRotated(MatOfRotatedRect bboxes, MatOfFloat scores, float score_threshold, float nms_threshold, MatOfInt indices, float eta) {
        MatOfRotatedRect bboxes_mat = bboxes;
        MatOfFloat scores_mat = scores;
        MatOfInt indices_mat = indices;
        Dnn.NMSBoxesRotated_1(bboxes_mat.nativeObj, scores_mat.nativeObj, score_threshold, nms_threshold, indices_mat.nativeObj, eta);
    }

    public static void NMSBoxesRotated(MatOfRotatedRect bboxes, MatOfFloat scores, float score_threshold, float nms_threshold, MatOfInt indices) {
        MatOfRotatedRect bboxes_mat = bboxes;
        MatOfFloat scores_mat = scores;
        MatOfInt indices_mat = indices;
        Dnn.NMSBoxesRotated_2(bboxes_mat.nativeObj, scores_mat.nativeObj, score_threshold, nms_threshold, indices_mat.nativeObj);
    }

    public static void imagesFromBlob(Mat blob_, List<Mat> images_) {
        Mat images__mat = new Mat();
        Dnn.imagesFromBlob_0(blob_.nativeObj, images__mat.nativeObj);
        Converters.Mat_to_vector_Mat(images__mat, images_);
        images__mat.release();
    }

    public static void resetMyriadDevice() {
        Dnn.resetMyriadDevice_0();
    }

    public static void shrinkCaffeModel(String src, String dst, List<String> layersTypes) {
        Dnn.shrinkCaffeModel_0(src, dst, layersTypes);
    }

    public static void shrinkCaffeModel(String src, String dst) {
        Dnn.shrinkCaffeModel_1(src, dst);
    }

    public static void writeTextGraph(String model, String output) {
        Dnn.writeTextGraph_0(model, output);
    }

    private static native long blobFromImage_0(long var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14, boolean var16, boolean var17, int var18);

    private static native long blobFromImage_1(long var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14, boolean var16, boolean var17);

    private static native long blobFromImage_2(long var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14, boolean var16);

    private static native long blobFromImage_3(long var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14);

    private static native long blobFromImage_4(long var0, double var2, double var4, double var6);

    private static native long blobFromImage_5(long var0, double var2);

    private static native long blobFromImage_6(long var0);

    private static native long blobFromImages_0(long var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14, boolean var16, boolean var17, int var18);

    private static native long blobFromImages_1(long var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14, boolean var16, boolean var17);

    private static native long blobFromImages_2(long var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14, boolean var16);

    private static native long blobFromImages_3(long var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14);

    private static native long blobFromImages_4(long var0, double var2, double var4, double var6);

    private static native long blobFromImages_5(long var0, double var2);

    private static native long blobFromImages_6(long var0);

    private static native long readTensorFromONNX_0(String var0);

    private static native long readTorchBlob_0(String var0, boolean var1);

    private static native long readTorchBlob_1(String var0);

    private static native long readNet_0(String var0, long var1, long var3);

    private static native long readNet_1(String var0, long var1);

    private static native long readNet_2(String var0, String var1, String var2);

    private static native long readNet_3(String var0, String var1);

    private static native long readNet_4(String var0);

    private static native long readNetFromCaffe_0(String var0, String var1);

    private static native long readNetFromCaffe_1(String var0);

    private static native long readNetFromCaffe_2(long var0, long var2);

    private static native long readNetFromCaffe_3(long var0);

    private static native long readNetFromDarknet_0(String var0, String var1);

    private static native long readNetFromDarknet_1(String var0);

    private static native long readNetFromDarknet_2(long var0, long var2);

    private static native long readNetFromDarknet_3(long var0);

    private static native long readNetFromModelOptimizer_0(String var0, String var1);

    private static native long readNetFromONNX_0(String var0);

    private static native long readNetFromTensorflow_0(String var0, String var1);

    private static native long readNetFromTensorflow_1(String var0);

    private static native long readNetFromTensorflow_2(long var0, long var2);

    private static native long readNetFromTensorflow_3(long var0);

    private static native long readNetFromTorch_0(String var0, boolean var1, boolean var2);

    private static native long readNetFromTorch_1(String var0, boolean var1);

    private static native long readNetFromTorch_2(String var0);

    private static native void NMSBoxes_0(long var0, long var2, float var4, float var5, long var6, float var8, int var9);

    private static native void NMSBoxes_1(long var0, long var2, float var4, float var5, long var6, float var8);

    private static native void NMSBoxes_2(long var0, long var2, float var4, float var5, long var6);

    private static native void NMSBoxes_3(long var0, long var2, float var4, float var5, long var6, float var8, int var9);

    private static native void NMSBoxes_4(long var0, long var2, float var4, float var5, long var6, float var8);

    private static native void NMSBoxes_5(long var0, long var2, float var4, float var5, long var6);

    private static native void NMSBoxesRotated_0(long var0, long var2, float var4, float var5, long var6, float var8, int var9);

    private static native void NMSBoxesRotated_1(long var0, long var2, float var4, float var5, long var6, float var8);

    private static native void NMSBoxesRotated_2(long var0, long var2, float var4, float var5, long var6);

    private static native void imagesFromBlob_0(long var0, long var2);

    private static native void resetMyriadDevice_0();

    private static native void shrinkCaffeModel_0(String var0, String var1, List<String> var2);

    private static native void shrinkCaffeModel_1(String var0, String var1);

    private static native void writeTextGraph_0(String var0, String var1);
}

