/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.views.jsp.iterator;

import javax.servlet.jsp.JspException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.util.IteratorGenerator;
import org.apache.struts2.views.annotations.StrutsTag;
import org.apache.struts2.views.annotations.StrutsTagAttribute;
import org.apache.struts2.views.jsp.StrutsBodyTagSupport;

@StrutsTag(name="generator", tldTagClass="org.apache.struts2.views.jsp.iterator.IteratorGeneratorTag", description="Generate an iterator for a iterable source.")
public class IteratorGeneratorTag
extends StrutsBodyTagSupport {
    private static final long serialVersionUID = 2968037295463973936L;
    public static final String DEFAULT_SEPARATOR = ",";
    private static final Log _log = LogFactory.getLog(IteratorGeneratorTag.class);
    String countAttr;
    String separatorAttr;
    String valueAttr;
    String converterAttr;
    IteratorGenerator iteratorGenerator = null;

    @StrutsTagAttribute(type="Integer", description="The max number entries to be in the iterator")
    public void setCount(String count) {
        this.countAttr = count;
    }

    @StrutsTagAttribute(required=true, description="The separator to be used in separating the <i>val</i> into entries of the iterator")
    public void setSeparator(String separator) {
        this.separatorAttr = separator;
    }

    @StrutsTagAttribute(required=true, description="The source to be parsed into an iterator")
    public void setVal(String val) {
        this.valueAttr = val;
    }

    @StrutsTagAttribute(type="org.apache.struts2.util.IteratorGenerator.Converter", description="The converter to convert the String entry parsed from <i>val</i> into an object")
    public void setConverter(String aConverter) {
        this.converterAttr = aConverter;
    }

    @StrutsTagAttribute(description="The id to store the resultant iterator into page context, if such id is supplied")
    public void setId(String string) {
        super.setId(string);
    }

    public int doStartTag() throws JspException {
        Object value = this.findValue(this.valueAttr);
        String separator = DEFAULT_SEPARATOR;
        if (this.separatorAttr != null && this.separatorAttr.length() > 0) {
            separator = this.findString(this.separatorAttr);
        }
        int count = 0;
        if (this.countAttr != null && this.countAttr.length() > 0) {
            Object countObj = this.findValue(this.countAttr);
            if (countObj instanceof Integer) {
                count = (Integer)countObj;
            } else if (countObj instanceof Float) {
                count = ((Float)countObj).intValue();
            } else if (countObj instanceof Long) {
                count = ((Long)countObj).intValue();
            } else if (countObj instanceof Double) {
                count = ((Long)countObj).intValue();
            } else if (countObj instanceof String) {
                try {
                    count = Integer.parseInt((String)countObj);
                }
                catch (NumberFormatException e) {
                    _log.warn((Object)("unable to convert count attribute [" + countObj + "] to number, ignore count attribute"), (Throwable)e);
                }
            }
        }
        IteratorGenerator.Converter converter = null;
        if (this.converterAttr != null && this.converterAttr.length() > 0) {
            converter = (IteratorGenerator.Converter)this.findValue(this.converterAttr);
        }
        this.iteratorGenerator = new IteratorGenerator();
        this.iteratorGenerator.setValues(value);
        this.iteratorGenerator.setCount(count);
        this.iteratorGenerator.setSeparator(separator);
        this.iteratorGenerator.setConverter(converter);
        this.iteratorGenerator.execute();
        this.getStack().push((Object)this.iteratorGenerator);
        if (this.getId() != null && this.getId().length() > 0) {
            this.pageContext.setAttribute(this.getId(), (Object)this.iteratorGenerator);
        }
        return 1;
    }

    public int doEndTag() throws JspException {
        this.getStack().pop();
        this.iteratorGenerator = null;
        return 6;
    }
}

