/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.dispatcher;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.util.profiling.UtilTimerStack;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.dispatcher.Dispatcher;

public class ActionContextCleanUp
implements Filter {
    private static final Log LOG = LogFactory.getLog(ActionContextCleanUp.class);
    private static final String COUNTER = "__cleanup_recursion_counter";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        String timerKey = "ActionContextCleanUp_doFilter: ";
        try {
            UtilTimerStack.push((String)timerKey);
            try {
                Integer count = (Integer)request.getAttribute(COUNTER);
                count = count == null ? new Integer(1) : new Integer(count + 1);
                request.setAttribute(COUNTER, (Object)count);
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
            finally {
                int counterVal = (Integer)request.getAttribute(COUNTER);
                request.setAttribute(COUNTER, (Object)new Integer(--counterVal));
                ActionContextCleanUp.cleanUp((ServletRequest)request);
            }
        }
        finally {
            UtilTimerStack.pop((String)timerKey);
        }
    }

    protected static void cleanUp(ServletRequest req) {
        Integer count = (Integer)req.getAttribute(COUNTER);
        if (count != null && count > 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("skipping cleanup counter=" + count));
            }
            return;
        }
        ActionContext.setContext(null);
        Dispatcher.setInstance(null);
    }

    public void destroy() {
    }

    public void init(FilterConfig arg0) throws ServletException {
    }
}

