package com.schreiner.eric.dummybikeapp;


import android.app.Fragment;
import android.content.Intent;
import android.os.Bundle;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.DynamoDBMapper;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.DynamoDBQueryExpression;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.PaginatedQueryList;

import org.w3c.dom.Text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import static android.os.Build.VERSION_CODES.M;

/**
 * Created by Kevin Aylesworth on 11/15/2016.
 */

public class RouteListFragment extends Fragment {

    private RecyclerView mRouteRecyclerView;
    private RouteAdapter mRouteAdapter;
    private List<Route> mRoutes;

    @Override
    public void onCreate(Bundle savedBundleInstance){
        super.onCreate(savedBundleInstance);
        setHasOptionsMenu(true);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()){
            case R.id.menu_item_new_route:
                Intent intent = new Intent(getActivity().getApplicationContext(), NewRouteActivity.class);
                intent.putExtra("username", UserClass.getMyUsername());
                startActivity(intent);
                return true;
            default:
                return super.onOptionsItemSelected(item);
        }
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_route_list, container, false);
        mRouteRecyclerView = (RecyclerView) view.findViewById(R.id.route_recycler_view);
        mRouteRecyclerView.setLayoutManager(new LinearLayoutManager(getActivity()));

        updateUI();
        return view;
    }

    @Override
    public void onResume() {
        super.onResume();
        updateUI();
    }

    @Override
    public void onCreateOptionsMenu(Menu menu, MenuInflater inflater){
        super.onCreateOptionsMenu(menu, inflater);
        inflater.inflate(R.menu.fragment_route_list, menu);
    }

    private void updateUI(){
        mRoutes = null;
        Runnable runnable = new Runnable() {
            public void run() {
                mRoutes = getRoutes(myMapper.getMyMapper(getActivity().getApplicationContext()), UserClass.getMyUsername());
            }
        };
        Thread mythread = new Thread(runnable);
        mythread.start();
        while(mRoutes == null) {
            //wait;
        }

        if (mRouteAdapter == null){
            mRouteAdapter = new RouteAdapter(mRoutes);
            mRouteRecyclerView.setAdapter(mRouteAdapter);
        }
        else {
            mRouteAdapter.setRoutes(mRoutes);
            mRouteAdapter.notifyDataSetChanged();
        }
    }

    private class RouteHolder extends RecyclerView.ViewHolder {
        private TextView mRouteName;
        private TextView mStartLat;
        private TextView mStartLon;
        private TextView mEndLat;
        private TextView mEndLon;
        private TextView mUsed;
        private Button mGoButton;
        private Route mRoute;

        public RouteHolder(View itemView){
            super(itemView);
            //itemView.setOnClickListener(this);
            mRouteName = (TextView) itemView.findViewById(R.id.routeNameTextView);
            mStartLat = (TextView) itemView.findViewById(R.id.startLatTextView);
            mStartLon = (TextView) itemView.findViewById(R.id.startLonTextView);
            mEndLat = (TextView) itemView.findViewById(R.id.endLatTextView);
            mEndLon = (TextView) itemView.findViewById(R.id.endLonTextView);
            mUsed = (TextView) itemView.findViewById(R.id.usedTextView);
            mGoButton = (Button) itemView.findViewById(R.id.routeGoButton);
        }

        public void bindRoute(Route route){
            mRoute = route;

            mRouteName.setText(mRoute.getRouteName());
            mStartLat.setText(mRoute.getStartLatitude());
            mStartLon.setText(mRoute.getStartLongitude());
            mEndLat.setText(mRoute.getEndLatitude());
            mEndLon.setText(mRoute.getEndLongitude());
            mUsed.setText(String.valueOf(mRoute.getUsed()));
            mGoButton.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v){
                    Runnable runnable2 = new Runnable() {
                        public void run() {
                            useRoute(myMapper.getMyMapper(getActivity().getApplicationContext()), mRoute);                }
                    };
                    Thread mythread2 = new Thread(runnable2);
                    mythread2.start();
                    Toast.makeText(getActivity().getApplicationContext(), mRoute.getRouteName() + " used #" +
                            (mRoute.getUsed()+1) + "\nat " + mRoute.getDate() + "\nStart: "
                            + mRoute.getStartLatitude() + ", " + mRoute.getStartLongitude()
                            + "\nEnd: " + mRoute.getEndLatitude() + ", " + mRoute.getEndLongitude(), Toast.LENGTH_LONG).show();
                    updateUI();
                }
            });
        }

    }

    private class RouteAdapter extends RecyclerView.Adapter<RouteHolder> {
        private List<Route> mRoutes;

        public RouteAdapter(List<Route> routes) {
            mRoutes = routes;
        }

        @Override
        public RouteHolder onCreateViewHolder(ViewGroup parent, int viewType){
            LayoutInflater layoutInflater = LayoutInflater.from(getActivity());
            View view = layoutInflater.inflate(R.layout.list_item_route, parent, false);
            return new RouteHolder(view);
        }

        @Override
        public void onBindViewHolder(RouteHolder holder, int position){
            Route route = mRoutes.get(position);
            holder.bindRoute(route);
        }

        @Override
        public int getItemCount(){
            return mRoutes.size();
        }

        public void setRoutes(List<Route> routes) {
            mRoutes = routes;
        }
    }

    // get routeId from button
    public void useRoute(DynamoDBMapper mapper, Route route) {
        route.setUsed(route.getUsed()+1);
        storeRoute(mapper, route);
    }

    /*
   create new route for user (need to get attributes from views to new route class first)
    */
    public void storeRoute(DynamoDBMapper mapper, Route route) {
        mapper.save(route);
    }


    public List<Route> getRoutes(DynamoDBMapper mapper, String userId) {

        Route userRoute = new Route();
        userRoute.setUserId(userId);

        DynamoDBQueryExpression<Route> queryExpression = new DynamoDBQueryExpression<Route>().withHashKeyValues(userRoute)
                .withConsistentRead(false).withIndexName("getRoutes");
        Log.d("ListActivity", "about to run query for getRoutes");
        PaginatedQueryList<Route> queryRoutes = mapper.query(Route.class, queryExpression);
        Log.d("ListActivity", "first returned route:" + queryRoutes.size());
        for (Route router: queryRoutes){
            Log.d("RouteListActivity", router.getDate().toString());
        }

        List<Route> routes = new ArrayList<>();
        int returnSize = queryRoutes.size();
        for (int i = 0; i < returnSize; i++) {
            Route temproute = new Route();
            temproute.setDate(queryRoutes.get(i).getDate().toString());
            temproute.setUserId(queryRoutes.get(i).getUserId().toString());
            temproute.setRouteId(queryRoutes.get(i).getRouteId().toString());
            temproute.setRouteName(queryRoutes.get(i).getRouteName().toString());
            temproute.setStartLatitude(queryRoutes.get(i).getStartLatitude().toString());
            temproute.setStartLongitude(queryRoutes.get(i).getStartLongitude().toString());
            temproute.setEndLatitude(queryRoutes.get(i).getEndLatitude().toString());
            temproute.setEndLongitude(queryRoutes.get(i).getEndLongitude().toString());
            temproute.setUsed(queryRoutes.get(i).getUsed());
            routes.add(temproute);
            Collections.sort(routes, new RouteComparator());
        }

        for (int i = 0; i < routes.size(); i++) {
            Log.d("RouteListActivity", "2-RouteName: " + routes.get(i).getRouteName() + ", Used: " + routes.get(i).getUsed());
        }
        while (routes.size() > 10) {
            routes.remove(10);
        }
        return routes;
    }
}