package com.schreiner.eric.dummybikeapp;

import android.content.Intent;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import com.amazonaws.auth.CognitoCachingCredentialsProvider;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.DynamoDBMapper;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClient;

import java.util.Date;

public class NewRouteActivity extends AppCompatActivity {

    TextView mRouteNameField;
    TextView mStartLatField;
    TextView mStartLongField;
    TextView mEndLatField;
    TextView mEndLongField;
    Button mAddRouteButton;
    Button mBackButton;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_new_route);

        UserClass.setMyUsername(getIntent().getStringExtra("username"));

        mRouteNameField = (TextView) findViewById(R.id.routeName_editText);
        mStartLatField = (TextView) findViewById(R.id.start_lat_editText);
        mStartLongField = (TextView) findViewById(R.id.start_long_editText);
        mEndLatField = (TextView) findViewById(R.id.end_lat_editText);
        mEndLongField = (TextView) findViewById(R.id.end_long_editText);

        mBackButton = (Button) findViewById(R.id.back_button);
        mBackButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent intent = new Intent(getApplicationContext(), RouteListActivity.class);
                intent.putExtra("username", UserClass.getMyUsername());
                startActivity(intent);
            }
        });

        mAddRouteButton = (Button) findViewById(R.id.add_route_button);
        mAddRouteButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                final Route route = new Route();
                route.setRouteName(mRouteNameField.getText().toString());
                route.setStartLatitude(mStartLatField.getText().toString());
                route.setStartLongitude(mStartLongField.getText().toString());
                route.setEndLatitude(mEndLatField.getText().toString());
                route.setEndLongitude(mEndLongField.getText().toString());
                route.setRouteId(UserClass.getMyUsername() + route.getRouteName());
                route.setUserId(UserClass.getMyUsername());
                route.setDate(new Date().toString());
                route.setUsed(0);

                Log.d("NewRouteActivity", "running storeRoute");
                Runnable runnable = new Runnable() {
                    public void run() {
                        storeRoute(myMapper.getMyMapper(getApplicationContext()), route);
                    }
                };
                Thread mythread = new Thread(runnable);
                mythread.start();
                Toast.makeText(getApplicationContext(), route.getRouteName() + " added to database\n at " + route.getDate(), Toast.LENGTH_LONG).show();
            }
        });
    }

    /*
   create new route for user (need to get attributes from views to new route class first)
    */
    public void storeRoute(DynamoDBMapper mapper, Route route) {
        mapper.save(route);
    }

    @Override
    public void onPause() {
        super.onPause();

        // Remove the activity when its off the screen
        finish();
    }
}
