package com.schreiner.eric.dummybikeapp;

import android.content.Intent;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;

import com.amazonaws.auth.CognitoCachingCredentialsProvider;
import com.amazonaws.regions.Region;
import com.amazonaws.services.dynamodbv2.*;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.*;
import com.amazonaws.regions.Regions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class MainActivity extends AppCompatActivity {

    private Button mAccountButton;
    private Button mRoutesButton;
    private Button mLoginButton;
    private EditText mUsernameField;
    private EditText mPasswordField;
    private EditText mFirstNameField;
    private EditText mLastNameField;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        mAccountButton = (Button) findViewById(R.id.main_account_button);
        mAccountButton.setEnabled(false);

        mRoutesButton = (Button) findViewById(R.id.main_routes_button);
        if (UserClass.isNull()) {
            mRoutesButton.setEnabled(false);
        }
        mRoutesButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent intent = new Intent(getApplicationContext(), RouteListActivity.class);
                intent.putExtra("username", UserClass.getMyUsername());
                startActivity(intent);
            }
        });

        mUsernameField = (EditText) findViewById(R.id.username_editText);
        mPasswordField = (EditText) findViewById(R.id.password_editText);
        mFirstNameField = (EditText) findViewById(R.id.firstName_editText);
        mLastNameField = (EditText) findViewById(R.id.lastName_editText);

        mLoginButton = (Button) findViewById(R.id.login_button);
        mLoginButton.setEnabled(true);
        mLoginButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                final Biker biker = new Biker();
                biker.setUserId(mUsernameField.getText().toString());
                biker.setPassword(mPasswordField.getText().toString());
                biker.setFirstName(mFirstNameField.getText().toString());
                biker.setLastName(mLastNameField.getText().toString());
                biker.setDate(new Date().toString());

                Runnable runnable = new Runnable() {
                    public void run() {
                        createUser(myMapper.getMyMapper(getApplicationContext()), biker);
                    }
                };
                Thread mythread = new Thread(runnable);
                mythread.start();
                mRoutesButton.setEnabled(true);
                UserClass.setMyUsername(mUsernameField.getText().toString());
                Toast.makeText(getApplicationContext(),("Logged in as " + UserClass.getMyUsername() + " at " + biker.getDate()), Toast.LENGTH_LONG).show();
            }
        });


    }

    /*
    create user from Biker class (need to get attributes from views to new biker class first)
     */
    public void createUser(DynamoDBMapper mapper, Biker biker) {
        mapper.save(biker);
    }

}
