/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.media.session;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.Bitmap;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.SystemClock;
import android.support.v4.media.MediaDescriptionCompat;
import android.support.v4.media.MediaMetadataCompat;
import android.support.v4.media.RatingCompat;
import android.support.v4.media.VolumeProviderCompat;
import android.support.v4.media.session.IMediaControllerCallback;
import android.support.v4.media.session.IMediaSession;
import android.support.v4.media.session.MediaControllerCompat;
import android.support.v4.media.session.MediaSessionCompatApi14;
import android.support.v4.media.session.MediaSessionCompatApi18;
import android.support.v4.media.session.MediaSessionCompatApi19;
import android.support.v4.media.session.MediaSessionCompatApi21;
import android.support.v4.media.session.MediaSessionCompatApi22;
import android.support.v4.media.session.MediaSessionCompatApi23;
import android.support.v4.media.session.MediaSessionCompatApi8;
import android.support.v4.media.session.ParcelableVolumeInfo;
import android.support.v4.media.session.PlaybackStateCompat;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

public class MediaSessionCompat {
    private static final String TAG = "MediaSessionCompat";
    private final MediaSessionImpl mImpl;
    private final MediaControllerCompat mController;
    private final ArrayList<OnActiveChangeListener> mActiveListeners = new ArrayList();
    public static final int FLAG_HANDLES_MEDIA_BUTTONS = 1;
    public static final int FLAG_HANDLES_TRANSPORT_CONTROLS = 2;
    public static final String ACTION_PLAY_FROM_URI = "android.support.v4.media.session.action.PLAY_FROM_URI";
    public static final String ACTION_ARGUMENT_URI = "android.support.v4.media.session.action.ARGUMENT_URI";
    public static final String ACTION_ARGUMENT_EXTRAS = "android.support.v4.media.session.action.ARGUMENT_EXTRAS";

    public MediaSessionCompat(Context context, String tag) {
        this(context, tag, null, null);
    }

    public MediaSessionCompat(Context context, String tag, ComponentName mediaButtonEventReceiver, PendingIntent mbrIntent) {
        if (context == null) {
            throw new IllegalArgumentException("context must not be null");
        }
        if (TextUtils.isEmpty((CharSequence)tag)) {
            throw new IllegalArgumentException("tag must not be null or empty");
        }
        if (mediaButtonEventReceiver == null) {
            Intent queryIntent = new Intent("android.intent.action.MEDIA_BUTTON");
            queryIntent.setPackage(context.getPackageName());
            PackageManager pm = context.getPackageManager();
            List resolveInfos = pm.queryBroadcastReceivers(queryIntent, 0);
            if (resolveInfos.size() == 1) {
                ResolveInfo resolveInfo = (ResolveInfo)resolveInfos.get(0);
                mediaButtonEventReceiver = new ComponentName(resolveInfo.activityInfo.packageName, resolveInfo.activityInfo.name);
            } else if (resolveInfos.size() > 1) {
                Log.w((String)TAG, (String)"More than one BroadcastReceiver that handles android.intent.action.MEDIA_BUTTON was found, using null. Provide a specific ComponentName to use as this session's media button receiver");
            }
        }
        if (mediaButtonEventReceiver != null && mbrIntent == null) {
            Intent mediaButtonIntent = new Intent("android.intent.action.MEDIA_BUTTON");
            mediaButtonIntent.setComponent(mediaButtonEventReceiver);
            mbrIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)mediaButtonIntent, (int)0);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.mImpl = new MediaSessionImplApi21(context, tag);
            this.mImpl.setMediaButtonReceiver(mbrIntent);
        } else {
            this.mImpl = new MediaSessionImplBase(context, tag, mediaButtonEventReceiver, mbrIntent);
        }
        this.mController = new MediaControllerCompat(context, this);
    }

    private MediaSessionCompat(Context context, MediaSessionImpl impl) {
        this.mImpl = impl;
        this.mController = new MediaControllerCompat(context, this);
    }

    public void setCallback(Callback callback) {
        this.setCallback(callback, null);
    }

    public void setCallback(Callback callback, Handler handler) {
        this.mImpl.setCallback(callback, handler != null ? handler : new Handler());
    }

    public void setSessionActivity(PendingIntent pi) {
        this.mImpl.setSessionActivity(pi);
    }

    public void setMediaButtonReceiver(PendingIntent mbr) {
        this.mImpl.setMediaButtonReceiver(mbr);
    }

    public void setFlags(int flags) {
        this.mImpl.setFlags(flags);
    }

    public void setPlaybackToLocal(int stream) {
        this.mImpl.setPlaybackToLocal(stream);
    }

    public void setPlaybackToRemote(VolumeProviderCompat volumeProvider) {
        if (volumeProvider == null) {
            throw new IllegalArgumentException("volumeProvider may not be null!");
        }
        this.mImpl.setPlaybackToRemote(volumeProvider);
    }

    public void setActive(boolean active) {
        this.mImpl.setActive(active);
        for (OnActiveChangeListener listener : this.mActiveListeners) {
            listener.onActiveChanged();
        }
    }

    public boolean isActive() {
        return this.mImpl.isActive();
    }

    public void sendSessionEvent(String event, Bundle extras) {
        if (TextUtils.isEmpty((CharSequence)event)) {
            throw new IllegalArgumentException("event cannot be null or empty");
        }
        this.mImpl.sendSessionEvent(event, extras);
    }

    public void release() {
        this.mImpl.release();
    }

    public Token getSessionToken() {
        return this.mImpl.getSessionToken();
    }

    public MediaControllerCompat getController() {
        return this.mController;
    }

    public void setPlaybackState(PlaybackStateCompat state) {
        this.mImpl.setPlaybackState(state);
    }

    public void setMetadata(MediaMetadataCompat metadata) {
        this.mImpl.setMetadata(metadata);
    }

    public void setQueue(List<QueueItem> queue) {
        this.mImpl.setQueue(queue);
    }

    public void setQueueTitle(CharSequence title) {
        this.mImpl.setQueueTitle(title);
    }

    public void setRatingType(int type) {
        this.mImpl.setRatingType(type);
    }

    public void setExtras(Bundle extras) {
        this.mImpl.setExtras(extras);
    }

    public Object getMediaSession() {
        return this.mImpl.getMediaSession();
    }

    public Object getRemoteControlClient() {
        return this.mImpl.getRemoteControlClient();
    }

    public void addOnActiveChangeListener(OnActiveChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener may not be null");
        }
        this.mActiveListeners.add(listener);
    }

    public void removeOnActiveChangeListener(OnActiveChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener may not be null");
        }
        this.mActiveListeners.remove(listener);
    }

    public static MediaSessionCompat obtain(Context context, Object mediaSession) {
        return new MediaSessionCompat(context, new MediaSessionImplApi21(mediaSession));
    }

    static class MediaSessionImplApi21
    implements MediaSessionImpl {
        private final Object mSessionObj;
        private final Token mToken;
        private PendingIntent mMediaButtonIntent;

        public MediaSessionImplApi21(Context context, String tag) {
            this.mSessionObj = MediaSessionCompatApi21.createSession((Context)context, (String)tag);
            this.mToken = new Token(MediaSessionCompatApi21.getSessionToken((Object)this.mSessionObj));
        }

        public MediaSessionImplApi21(Object mediaSession) {
            this.mSessionObj = MediaSessionCompatApi21.verifySession((Object)mediaSession);
            this.mToken = new Token(MediaSessionCompatApi21.getSessionToken((Object)this.mSessionObj));
        }

        @Override
        public void setCallback(Callback callback, Handler handler) {
            MediaSessionCompatApi21.setCallback((Object)this.mSessionObj, (Object)(callback == null ? null : callback.mCallbackObj), (Handler)handler);
        }

        @Override
        public void setFlags(int flags) {
            MediaSessionCompatApi21.setFlags((Object)this.mSessionObj, (int)flags);
        }

        @Override
        public void setPlaybackToLocal(int stream) {
            MediaSessionCompatApi21.setPlaybackToLocal((Object)this.mSessionObj, (int)stream);
        }

        @Override
        public void setPlaybackToRemote(VolumeProviderCompat volumeProvider) {
            MediaSessionCompatApi21.setPlaybackToRemote((Object)this.mSessionObj, (Object)volumeProvider.getVolumeProvider());
        }

        @Override
        public void setActive(boolean active) {
            MediaSessionCompatApi21.setActive((Object)this.mSessionObj, (boolean)active);
        }

        @Override
        public boolean isActive() {
            return MediaSessionCompatApi21.isActive((Object)this.mSessionObj);
        }

        @Override
        public void sendSessionEvent(String event, Bundle extras) {
            MediaSessionCompatApi21.sendSessionEvent((Object)this.mSessionObj, (String)event, (Bundle)extras);
        }

        @Override
        public void release() {
            MediaSessionCompatApi21.release((Object)this.mSessionObj);
        }

        @Override
        public Token getSessionToken() {
            return this.mToken;
        }

        @Override
        public void setPlaybackState(PlaybackStateCompat state) {
            MediaSessionCompatApi21.setPlaybackState((Object)this.mSessionObj, (Object)(state == null ? null : state.getPlaybackState()));
        }

        @Override
        public void setMetadata(MediaMetadataCompat metadata) {
            MediaSessionCompatApi21.setMetadata((Object)this.mSessionObj, (Object)(metadata == null ? null : metadata.getMediaMetadata()));
        }

        @Override
        public void setSessionActivity(PendingIntent pi) {
            MediaSessionCompatApi21.setSessionActivity((Object)this.mSessionObj, (PendingIntent)pi);
        }

        @Override
        public void setMediaButtonReceiver(PendingIntent mbr) {
            this.mMediaButtonIntent = mbr;
            MediaSessionCompatApi21.setMediaButtonReceiver((Object)this.mSessionObj, (PendingIntent)mbr);
        }

        @Override
        public void setQueue(List<QueueItem> queue) {
            ArrayList<Object> queueObjs = null;
            if (queue != null) {
                queueObjs = new ArrayList<Object>();
                for (QueueItem item : queue) {
                    queueObjs.add(item.getQueueItem());
                }
            }
            MediaSessionCompatApi21.setQueue((Object)this.mSessionObj, queueObjs);
        }

        @Override
        public void setQueueTitle(CharSequence title) {
            MediaSessionCompatApi21.setQueueTitle((Object)this.mSessionObj, (CharSequence)title);
        }

        @Override
        public void setRatingType(int type) {
            if (Build.VERSION.SDK_INT >= 22) {
                MediaSessionCompatApi22.setRatingType((Object)this.mSessionObj, (int)type);
            }
        }

        @Override
        public void setExtras(Bundle extras) {
            MediaSessionCompatApi21.setExtras((Object)this.mSessionObj, (Bundle)extras);
        }

        @Override
        public Object getMediaSession() {
            return this.mSessionObj;
        }

        @Override
        public Object getRemoteControlClient() {
            return null;
        }
    }

    static class MediaSessionImplBase
    implements MediaSessionImpl {
        private final Context mContext;
        private final ComponentName mComponentName;
        private final PendingIntent mMediaButtonEventReceiver;
        private final Object mRccObj;
        private final MediaSessionStub mStub;
        private final Token mToken;
        private final String mPackageName;
        private final String mTag;
        private final AudioManager mAudioManager;
        private final Object mLock = new Object();
        private final RemoteCallbackList<IMediaControllerCallback> mControllerCallbacks = new RemoteCallbackList();
        private MessageHandler mHandler;
        private boolean mDestroyed = false;
        private boolean mIsActive = false;
        private boolean mIsRccRegistered = false;
        private boolean mIsMbrRegistered = false;
        private volatile Callback mCallback;
        private int mFlags;
        private MediaMetadataCompat mMetadata;
        private PlaybackStateCompat mState;
        private PendingIntent mSessionActivity;
        private List<QueueItem> mQueue;
        private CharSequence mQueueTitle;
        private int mRatingType;
        private Bundle mExtras;
        private int mVolumeType;
        private int mLocalStream;
        private VolumeProviderCompat mVolumeProvider;
        private VolumeProviderCompat.Callback mVolumeCallback = new VolumeProviderCompat.Callback(){

            @Override
            public void onVolumeChanged(VolumeProviderCompat volumeProvider) {
                if (MediaSessionImplBase.this.mVolumeProvider != volumeProvider) {
                    return;
                }
                ParcelableVolumeInfo info = new ParcelableVolumeInfo(MediaSessionImplBase.this.mVolumeType, MediaSessionImplBase.this.mLocalStream, volumeProvider.getVolumeControl(), volumeProvider.getMaxVolume(), volumeProvider.getCurrentVolume());
                MediaSessionImplBase.this.sendVolumeInfoChanged(info);
            }
        };

        public MediaSessionImplBase(Context context, String tag, ComponentName mbrComponent, PendingIntent mbr) {
            if (mbrComponent == null) {
                throw new IllegalArgumentException("MediaButtonReceiver component may not be null.");
            }
            this.mContext = context;
            this.mPackageName = context.getPackageName();
            this.mAudioManager = (AudioManager)context.getSystemService("audio");
            this.mTag = tag;
            this.mComponentName = mbrComponent;
            this.mMediaButtonEventReceiver = mbr;
            this.mStub = new MediaSessionStub();
            this.mToken = new Token(this.mStub);
            this.mRatingType = 0;
            this.mVolumeType = 1;
            this.mLocalStream = 3;
            this.mRccObj = Build.VERSION.SDK_INT >= 14 ? MediaSessionCompatApi14.createRemoteControlClient((PendingIntent)mbr) : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCallback(Callback callback, Handler handler) {
            this.mCallback = callback;
            if (callback == null) {
                if (Build.VERSION.SDK_INT >= 18) {
                    MediaSessionCompatApi18.setOnPlaybackPositionUpdateListener((Object)this.mRccObj, null);
                }
                if (Build.VERSION.SDK_INT >= 19) {
                    MediaSessionCompatApi19.setOnMetadataUpdateListener((Object)this.mRccObj, null);
                }
            } else {
                if (handler == null) {
                    handler = new Handler();
                }
                Object object = this.mLock;
                synchronized (object) {
                    this.mHandler = new MessageHandler(handler.getLooper());
                }
                MediaSessionCompatApi19.Callback cb19 = new MediaSessionCompatApi19.Callback(){

                    public void onSetRating(Object ratingObj) {
                        MediaSessionImplBase.this.postToHandler(12, RatingCompat.fromRating(ratingObj));
                    }

                    public void onSeekTo(long pos) {
                        MediaSessionImplBase.this.postToHandler(11, pos);
                    }
                };
                if (Build.VERSION.SDK_INT >= 18) {
                    Object onPositionUpdateObj = MediaSessionCompatApi18.createPlaybackPositionUpdateListener((MediaSessionCompatApi18.Callback)cb19);
                    MediaSessionCompatApi18.setOnPlaybackPositionUpdateListener((Object)this.mRccObj, (Object)onPositionUpdateObj);
                }
                if (Build.VERSION.SDK_INT >= 19) {
                    Object onMetadataUpdateObj = MediaSessionCompatApi19.createMetadataUpdateListener((MediaSessionCompatApi19.Callback)cb19);
                    MediaSessionCompatApi19.setOnMetadataUpdateListener((Object)this.mRccObj, (Object)onMetadataUpdateObj);
                }
            }
        }

        private void postToHandler(int what) {
            this.postToHandler(what, null);
        }

        private void postToHandler(int what, Object obj) {
            this.postToHandler(what, obj, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void postToHandler(int what, Object obj, Bundle extras) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mHandler != null) {
                    this.mHandler.post(what, obj, extras);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setFlags(int flags) {
            Object object = this.mLock;
            synchronized (object) {
                this.mFlags = flags;
            }
            this.update();
        }

        @Override
        public void setPlaybackToLocal(int stream) {
            if (this.mVolumeProvider != null) {
                this.mVolumeProvider.setCallback(null);
            }
            this.mVolumeType = 1;
            ParcelableVolumeInfo info = new ParcelableVolumeInfo(this.mVolumeType, this.mLocalStream, 2, this.mAudioManager.getStreamMaxVolume(this.mLocalStream), this.mAudioManager.getStreamVolume(this.mLocalStream));
            this.sendVolumeInfoChanged(info);
        }

        @Override
        public void setPlaybackToRemote(VolumeProviderCompat volumeProvider) {
            if (volumeProvider == null) {
                throw new IllegalArgumentException("volumeProvider may not be null");
            }
            if (this.mVolumeProvider != null) {
                this.mVolumeProvider.setCallback(null);
            }
            this.mVolumeType = 2;
            this.mVolumeProvider = volumeProvider;
            ParcelableVolumeInfo info = new ParcelableVolumeInfo(this.mVolumeType, this.mLocalStream, this.mVolumeProvider.getVolumeControl(), this.mVolumeProvider.getMaxVolume(), this.mVolumeProvider.getCurrentVolume());
            this.sendVolumeInfoChanged(info);
            volumeProvider.setCallback(this.mVolumeCallback);
        }

        @Override
        public void setActive(boolean active) {
            if (active == this.mIsActive) {
                return;
            }
            this.mIsActive = active;
            if (this.update()) {
                this.setMetadata(this.mMetadata);
                this.setPlaybackState(this.mState);
            }
        }

        @Override
        public boolean isActive() {
            return this.mIsActive;
        }

        @Override
        public void sendSessionEvent(String event, Bundle extras) {
            this.sendEvent(event, extras);
        }

        @Override
        public void release() {
            this.mIsActive = false;
            this.mDestroyed = true;
            this.update();
            this.sendSessionDestroyed();
        }

        @Override
        public Token getSessionToken() {
            return this.mToken;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setPlaybackState(PlaybackStateCompat state) {
            Object object = this.mLock;
            synchronized (object) {
                this.mState = state;
            }
            this.sendState(state);
            if (!this.mIsActive) {
                return;
            }
            if (state == null) {
                if (Build.VERSION.SDK_INT >= 14) {
                    MediaSessionCompatApi14.setState((Object)this.mRccObj, (int)0);
                    MediaSessionCompatApi14.setTransportControlFlags((Object)this.mRccObj, (long)0L);
                }
            } else {
                if (Build.VERSION.SDK_INT >= 18) {
                    MediaSessionCompatApi18.setState((Object)this.mRccObj, (int)state.getState(), (long)state.getPosition(), (float)state.getPlaybackSpeed(), (long)state.getLastPositionUpdateTime());
                } else if (Build.VERSION.SDK_INT >= 14) {
                    MediaSessionCompatApi14.setState((Object)this.mRccObj, (int)state.getState());
                }
                if (Build.VERSION.SDK_INT >= 19) {
                    MediaSessionCompatApi19.setTransportControlFlags((Object)this.mRccObj, (long)state.getActions());
                } else if (Build.VERSION.SDK_INT >= 18) {
                    MediaSessionCompatApi18.setTransportControlFlags((Object)this.mRccObj, (long)state.getActions());
                } else if (Build.VERSION.SDK_INT >= 14) {
                    MediaSessionCompatApi14.setTransportControlFlags((Object)this.mRccObj, (long)state.getActions());
                }
            }
        }

        private MediaMetadataCompat cloneMetadataIfNeeded(MediaMetadataCompat metadata) {
            Bitmap albumArtBitmap;
            if (metadata == null) {
                return null;
            }
            if (!metadata.containsKey("android.media.metadata.ART") && !metadata.containsKey("android.media.metadata.ALBUM_ART")) {
                return metadata;
            }
            MediaMetadataCompat.Builder builder = new MediaMetadataCompat.Builder(metadata);
            Bitmap artBitmap = metadata.getBitmap("android.media.metadata.ART");
            if (artBitmap != null) {
                builder.putBitmap("android.media.metadata.ART", artBitmap.copy(artBitmap.getConfig(), false));
            }
            if ((albumArtBitmap = metadata.getBitmap("android.media.metadata.ALBUM_ART")) != null) {
                builder.putBitmap("android.media.metadata.ALBUM_ART", albumArtBitmap.copy(albumArtBitmap.getConfig(), false));
            }
            return builder.build();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setMetadata(MediaMetadataCompat metadata) {
            if (Build.VERSION.SDK_INT >= 14 && metadata != null) {
                metadata = this.cloneMetadataIfNeeded(metadata);
            }
            Object object = this.mLock;
            synchronized (object) {
                this.mMetadata = metadata;
            }
            this.sendMetadata(metadata);
            if (!this.mIsActive) {
                return;
            }
            if (Build.VERSION.SDK_INT >= 19) {
                MediaSessionCompatApi19.setMetadata((Object)this.mRccObj, (Bundle)(metadata == null ? null : metadata.getBundle()), (long)(this.mState == null ? 0L : this.mState.getActions()));
            } else if (Build.VERSION.SDK_INT >= 14) {
                MediaSessionCompatApi14.setMetadata((Object)this.mRccObj, (Bundle)(metadata == null ? null : metadata.getBundle()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setSessionActivity(PendingIntent pi) {
            Object object = this.mLock;
            synchronized (object) {
                this.mSessionActivity = pi;
            }
        }

        @Override
        public void setMediaButtonReceiver(PendingIntent mbr) {
        }

        @Override
        public void setQueue(List<QueueItem> queue) {
            this.mQueue = queue;
            this.sendQueue(queue);
        }

        @Override
        public void setQueueTitle(CharSequence title) {
            this.mQueueTitle = title;
            this.sendQueueTitle(title);
        }

        @Override
        public Object getMediaSession() {
            return null;
        }

        @Override
        public Object getRemoteControlClient() {
            return this.mRccObj;
        }

        @Override
        public void setRatingType(int type) {
            this.mRatingType = type;
        }

        @Override
        public void setExtras(Bundle extras) {
            this.mExtras = extras;
        }

        private boolean update() {
            boolean registeredRcc = false;
            if (this.mIsActive) {
                if (Build.VERSION.SDK_INT >= 8) {
                    if (!this.mIsMbrRegistered && (this.mFlags & 1) != 0) {
                        if (Build.VERSION.SDK_INT >= 18) {
                            MediaSessionCompatApi18.registerMediaButtonEventReceiver((Context)this.mContext, (PendingIntent)this.mMediaButtonEventReceiver, (ComponentName)this.mComponentName);
                        } else {
                            MediaSessionCompatApi8.registerMediaButtonEventReceiver((Context)this.mContext, (ComponentName)this.mComponentName);
                        }
                        this.mIsMbrRegistered = true;
                    } else if (this.mIsMbrRegistered && (this.mFlags & 1) == 0) {
                        if (Build.VERSION.SDK_INT >= 18) {
                            MediaSessionCompatApi18.unregisterMediaButtonEventReceiver((Context)this.mContext, (PendingIntent)this.mMediaButtonEventReceiver, (ComponentName)this.mComponentName);
                        } else {
                            MediaSessionCompatApi8.unregisterMediaButtonEventReceiver((Context)this.mContext, (ComponentName)this.mComponentName);
                        }
                        this.mIsMbrRegistered = false;
                    }
                }
                if (Build.VERSION.SDK_INT >= 14) {
                    if (!this.mIsRccRegistered && (this.mFlags & 2) != 0) {
                        MediaSessionCompatApi14.registerRemoteControlClient((Context)this.mContext, (Object)this.mRccObj);
                        this.mIsRccRegistered = true;
                        registeredRcc = true;
                    } else if (this.mIsRccRegistered && (this.mFlags & 2) == 0) {
                        MediaSessionCompatApi14.setState((Object)this.mRccObj, (int)0);
                        MediaSessionCompatApi14.unregisterRemoteControlClient((Context)this.mContext, (Object)this.mRccObj);
                        this.mIsRccRegistered = false;
                    }
                }
            } else {
                if (this.mIsMbrRegistered) {
                    if (Build.VERSION.SDK_INT >= 18) {
                        MediaSessionCompatApi18.unregisterMediaButtonEventReceiver((Context)this.mContext, (PendingIntent)this.mMediaButtonEventReceiver, (ComponentName)this.mComponentName);
                    } else {
                        MediaSessionCompatApi8.unregisterMediaButtonEventReceiver((Context)this.mContext, (ComponentName)this.mComponentName);
                    }
                    this.mIsMbrRegistered = false;
                }
                if (this.mIsRccRegistered) {
                    MediaSessionCompatApi14.setState((Object)this.mRccObj, (int)0);
                    MediaSessionCompatApi14.unregisterRemoteControlClient((Context)this.mContext, (Object)this.mRccObj);
                    this.mIsRccRegistered = false;
                }
            }
            return registeredRcc;
        }

        private void adjustVolume(int direction, int flags) {
            if (this.mVolumeType == 2) {
                if (this.mVolumeProvider != null) {
                    this.mVolumeProvider.onAdjustVolume(direction);
                }
            } else {
                this.mAudioManager.adjustStreamVolume(this.mLocalStream, direction, flags);
            }
        }

        private void setVolumeTo(int value, int flags) {
            if (this.mVolumeType == 2) {
                if (this.mVolumeProvider != null) {
                    this.mVolumeProvider.onSetVolumeTo(value);
                }
            } else {
                this.mAudioManager.setStreamVolume(this.mLocalStream, value, flags);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private PlaybackStateCompat getStateWithUpdatedPosition() {
            PlaybackStateCompat state;
            long duration = -1L;
            Object object = this.mLock;
            synchronized (object) {
                state = this.mState;
                if (this.mMetadata != null && this.mMetadata.containsKey("android.media.metadata.DURATION")) {
                    duration = this.mMetadata.getLong("android.media.metadata.DURATION");
                }
            }
            PlaybackStateCompat result = null;
            if (state != null && (state.getState() == 3 || state.getState() == 4 || state.getState() == 5)) {
                long updateTime = state.getLastPositionUpdateTime();
                long currentTime = SystemClock.elapsedRealtime();
                if (updateTime > 0L) {
                    long position = (long)(state.getPlaybackSpeed() * (float)(currentTime - updateTime)) + state.getPosition();
                    if (duration >= 0L && position > duration) {
                        position = duration;
                    } else if (position < 0L) {
                        position = 0L;
                    }
                    PlaybackStateCompat.Builder builder = new PlaybackStateCompat.Builder(state);
                    builder.setState(state.getState(), position, state.getPlaybackSpeed(), currentTime);
                    result = builder.build();
                }
            }
            return result == null ? state : result;
        }

        private void sendVolumeInfoChanged(ParcelableVolumeInfo info) {
            int size = this.mControllerCallbacks.beginBroadcast();
            for (int i = size - 1; i >= 0; --i) {
                IMediaControllerCallback cb = (IMediaControllerCallback)this.mControllerCallbacks.getBroadcastItem(i);
                try {
                    cb.onVolumeInfoChanged(info);
                    continue;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            this.mControllerCallbacks.finishBroadcast();
        }

        private void sendSessionDestroyed() {
            int size = this.mControllerCallbacks.beginBroadcast();
            for (int i = size - 1; i >= 0; --i) {
                IMediaControllerCallback cb = (IMediaControllerCallback)this.mControllerCallbacks.getBroadcastItem(i);
                try {
                    cb.onSessionDestroyed();
                    continue;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            this.mControllerCallbacks.finishBroadcast();
            this.mControllerCallbacks.kill();
        }

        private void sendEvent(String event, Bundle extras) {
            int size = this.mControllerCallbacks.beginBroadcast();
            for (int i = size - 1; i >= 0; --i) {
                IMediaControllerCallback cb = (IMediaControllerCallback)this.mControllerCallbacks.getBroadcastItem(i);
                try {
                    cb.onEvent(event, extras);
                    continue;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            this.mControllerCallbacks.finishBroadcast();
        }

        private void sendState(PlaybackStateCompat state) {
            int size = this.mControllerCallbacks.beginBroadcast();
            for (int i = size - 1; i >= 0; --i) {
                IMediaControllerCallback cb = (IMediaControllerCallback)this.mControllerCallbacks.getBroadcastItem(i);
                try {
                    cb.onPlaybackStateChanged(state);
                    continue;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            this.mControllerCallbacks.finishBroadcast();
        }

        private void sendMetadata(MediaMetadataCompat metadata) {
            int size = this.mControllerCallbacks.beginBroadcast();
            for (int i = size - 1; i >= 0; --i) {
                IMediaControllerCallback cb = (IMediaControllerCallback)this.mControllerCallbacks.getBroadcastItem(i);
                try {
                    cb.onMetadataChanged(metadata);
                    continue;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            this.mControllerCallbacks.finishBroadcast();
        }

        private void sendQueue(List<QueueItem> queue) {
            int size = this.mControllerCallbacks.beginBroadcast();
            for (int i = size - 1; i >= 0; --i) {
                IMediaControllerCallback cb = (IMediaControllerCallback)this.mControllerCallbacks.getBroadcastItem(i);
                try {
                    cb.onQueueChanged(queue);
                    continue;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            this.mControllerCallbacks.finishBroadcast();
        }

        private void sendQueueTitle(CharSequence queueTitle) {
            int size = this.mControllerCallbacks.beginBroadcast();
            for (int i = size - 1; i >= 0; --i) {
                IMediaControllerCallback cb = (IMediaControllerCallback)this.mControllerCallbacks.getBroadcastItem(i);
                try {
                    cb.onQueueTitleChanged(queueTitle);
                    continue;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            this.mControllerCallbacks.finishBroadcast();
        }

        private class MessageHandler
        extends Handler {
            private static final int MSG_PLAY = 1;
            private static final int MSG_PLAY_MEDIA_ID = 2;
            private static final int MSG_PLAY_SEARCH = 3;
            private static final int MSG_SKIP_TO_ITEM = 4;
            private static final int MSG_PAUSE = 5;
            private static final int MSG_STOP = 6;
            private static final int MSG_NEXT = 7;
            private static final int MSG_PREVIOUS = 8;
            private static final int MSG_FAST_FORWARD = 9;
            private static final int MSG_REWIND = 10;
            private static final int MSG_SEEK_TO = 11;
            private static final int MSG_RATE = 12;
            private static final int MSG_CUSTOM_ACTION = 13;
            private static final int MSG_MEDIA_BUTTON = 14;
            private static final int MSG_COMMAND = 15;
            private static final int MSG_ADJUST_VOLUME = 16;
            private static final int MSG_SET_VOLUME = 17;
            private static final int MSG_PLAY_URI = 18;
            private static final int KEYCODE_MEDIA_PAUSE = 127;
            private static final int KEYCODE_MEDIA_PLAY = 126;

            public MessageHandler(Looper looper) {
                super(looper);
            }

            public void post(int what, Object obj, Bundle bundle) {
                Message msg = this.obtainMessage(what, obj);
                msg.setData(bundle);
                msg.sendToTarget();
            }

            public void post(int what, Object obj) {
                this.obtainMessage(what, obj).sendToTarget();
            }

            public void post(int what) {
                this.post(what, null);
            }

            public void post(int what, Object obj, int arg1) {
                this.obtainMessage(what, arg1, 0, obj).sendToTarget();
            }

            public void handleMessage(Message msg) {
                Callback cb = MediaSessionImplBase.this.mCallback;
                if (cb == null) {
                    return;
                }
                switch (msg.what) {
                    case 1: {
                        cb.onPlay();
                        break;
                    }
                    case 2: {
                        cb.onPlayFromMediaId((String)msg.obj, msg.getData());
                        break;
                    }
                    case 3: {
                        cb.onPlayFromSearch((String)msg.obj, msg.getData());
                        break;
                    }
                    case 18: {
                        cb.onPlayFromUri((Uri)msg.obj, msg.getData());
                        break;
                    }
                    case 4: {
                        cb.onSkipToQueueItem((Long)msg.obj);
                        break;
                    }
                    case 5: {
                        cb.onPause();
                        break;
                    }
                    case 6: {
                        cb.onStop();
                        break;
                    }
                    case 7: {
                        cb.onSkipToNext();
                        break;
                    }
                    case 8: {
                        cb.onSkipToPrevious();
                        break;
                    }
                    case 9: {
                        cb.onFastForward();
                        break;
                    }
                    case 10: {
                        cb.onRewind();
                        break;
                    }
                    case 11: {
                        cb.onSeekTo((Long)msg.obj);
                        break;
                    }
                    case 12: {
                        cb.onSetRating((RatingCompat)msg.obj);
                        break;
                    }
                    case 13: {
                        cb.onCustomAction((String)msg.obj, msg.getData());
                        break;
                    }
                    case 14: {
                        KeyEvent keyEvent = (KeyEvent)msg.obj;
                        Intent intent = new Intent("android.intent.action.MEDIA_BUTTON");
                        intent.putExtra("android.intent.extra.KEY_EVENT", (Parcelable)keyEvent);
                        if (cb.onMediaButtonEvent(intent)) break;
                        this.onMediaButtonEvent(keyEvent, cb);
                        break;
                    }
                    case 15: {
                        Command cmd = (Command)msg.obj;
                        cb.onCommand(cmd.command, cmd.extras, cmd.stub);
                        break;
                    }
                    case 16: {
                        MediaSessionImplBase.this.adjustVolume((Integer)msg.obj, 0);
                        break;
                    }
                    case 17: {
                        MediaSessionImplBase.this.setVolumeTo((Integer)msg.obj, 0);
                    }
                }
            }

            private void onMediaButtonEvent(KeyEvent ke, Callback cb) {
                if (ke == null || ke.getAction() != 0) {
                    return;
                }
                long validActions = MediaSessionImplBase.this.mState == null ? 0L : MediaSessionImplBase.this.mState.getActions();
                switch (ke.getKeyCode()) {
                    case 126: {
                        if ((validActions & 4L) == 0L) break;
                        cb.onPlay();
                        break;
                    }
                    case 127: {
                        if ((validActions & 2L) == 0L) break;
                        cb.onPause();
                        break;
                    }
                    case 87: {
                        if ((validActions & 0x20L) == 0L) break;
                        cb.onSkipToNext();
                        break;
                    }
                    case 88: {
                        if ((validActions & 0x10L) == 0L) break;
                        cb.onSkipToPrevious();
                        break;
                    }
                    case 86: {
                        if ((validActions & 1L) == 0L) break;
                        cb.onStop();
                        break;
                    }
                    case 90: {
                        if ((validActions & 0x40L) == 0L) break;
                        cb.onFastForward();
                        break;
                    }
                    case 89: {
                        if ((validActions & 8L) == 0L) break;
                        cb.onRewind();
                        break;
                    }
                    case 79: 
                    case 85: {
                        boolean canPause;
                        boolean isPlaying = MediaSessionImplBase.this.mState != null && MediaSessionImplBase.this.mState.getState() == 3;
                        boolean canPlay = (validActions & 0x204L) != 0L;
                        boolean bl = canPause = (validActions & 0x202L) != 0L;
                        if (isPlaying && canPause) {
                            cb.onPause();
                            break;
                        }
                        if (isPlaying || !canPlay) break;
                        cb.onPlay();
                    }
                }
            }
        }

        private static final class Command {
            public final String command;
            public final Bundle extras;
            public final ResultReceiver stub;

            public Command(String command, Bundle extras, ResultReceiver stub) {
                this.command = command;
                this.extras = extras;
                this.stub = stub;
            }
        }

        class MediaSessionStub
        extends IMediaSession.Stub {
            MediaSessionStub() {
            }

            @Override
            public void sendCommand(String command, Bundle args, ResultReceiverWrapper cb) {
                MediaSessionImplBase.this.postToHandler(15, new Command(command, args, cb.mResultReceiver));
            }

            @Override
            public boolean sendMediaButton(KeyEvent mediaButton) {
                boolean handlesMediaButtons;
                boolean bl = handlesMediaButtons = (MediaSessionImplBase.this.mFlags & 1) != 0;
                if (handlesMediaButtons) {
                    MediaSessionImplBase.this.postToHandler(14, mediaButton);
                }
                return handlesMediaButtons;
            }

            @Override
            public void registerCallbackListener(IMediaControllerCallback cb) {
                if (MediaSessionImplBase.this.mDestroyed) {
                    try {
                        cb.onSessionDestroyed();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return;
                }
                MediaSessionImplBase.this.mControllerCallbacks.register((IInterface)cb);
            }

            @Override
            public void unregisterCallbackListener(IMediaControllerCallback cb) {
                MediaSessionImplBase.this.mControllerCallbacks.unregister((IInterface)cb);
            }

            @Override
            public String getPackageName() {
                return MediaSessionImplBase.this.mPackageName;
            }

            @Override
            public String getTag() {
                return MediaSessionImplBase.this.mTag;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PendingIntent getLaunchPendingIntent() {
                Object object = MediaSessionImplBase.this.mLock;
                synchronized (object) {
                    return MediaSessionImplBase.this.mSessionActivity;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getFlags() {
                Object object = MediaSessionImplBase.this.mLock;
                synchronized (object) {
                    return MediaSessionImplBase.this.mFlags;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParcelableVolumeInfo getVolumeAttributes() {
                int current;
                int max;
                int controlType;
                int stream;
                int volumeType;
                Object object = MediaSessionImplBase.this.mLock;
                synchronized (object) {
                    volumeType = MediaSessionImplBase.this.mVolumeType;
                    stream = MediaSessionImplBase.this.mLocalStream;
                    VolumeProviderCompat vp = MediaSessionImplBase.this.mVolumeProvider;
                    if (volumeType == 2) {
                        controlType = vp.getVolumeControl();
                        max = vp.getMaxVolume();
                        current = vp.getCurrentVolume();
                    } else {
                        controlType = 2;
                        max = MediaSessionImplBase.this.mAudioManager.getStreamMaxVolume(stream);
                        current = MediaSessionImplBase.this.mAudioManager.getStreamVolume(stream);
                    }
                }
                return new ParcelableVolumeInfo(volumeType, stream, controlType, max, current);
            }

            @Override
            public void adjustVolume(int direction, int flags, String packageName) {
                MediaSessionImplBase.this.adjustVolume(direction, flags);
            }

            @Override
            public void setVolumeTo(int value, int flags, String packageName) {
                MediaSessionImplBase.this.setVolumeTo(value, flags);
            }

            @Override
            public void play() throws RemoteException {
                MediaSessionImplBase.this.postToHandler(1);
            }

            @Override
            public void playFromMediaId(String mediaId, Bundle extras) throws RemoteException {
                MediaSessionImplBase.this.postToHandler(2, mediaId, extras);
            }

            @Override
            public void playFromSearch(String query, Bundle extras) throws RemoteException {
                MediaSessionImplBase.this.postToHandler(3, query, extras);
            }

            @Override
            public void playFromUri(Uri uri, Bundle extras) throws RemoteException {
                MediaSessionImplBase.this.postToHandler(18, uri, extras);
            }

            @Override
            public void skipToQueueItem(long id) {
                MediaSessionImplBase.this.postToHandler(4, id);
            }

            @Override
            public void pause() throws RemoteException {
                MediaSessionImplBase.this.postToHandler(5);
            }

            @Override
            public void stop() throws RemoteException {
                MediaSessionImplBase.this.postToHandler(6);
            }

            @Override
            public void next() throws RemoteException {
                MediaSessionImplBase.this.postToHandler(7);
            }

            @Override
            public void previous() throws RemoteException {
                MediaSessionImplBase.this.postToHandler(8);
            }

            @Override
            public void fastForward() throws RemoteException {
                MediaSessionImplBase.this.postToHandler(9);
            }

            @Override
            public void rewind() throws RemoteException {
                MediaSessionImplBase.this.postToHandler(10);
            }

            @Override
            public void seekTo(long pos) throws RemoteException {
                MediaSessionImplBase.this.postToHandler(11, pos);
            }

            @Override
            public void rate(RatingCompat rating) throws RemoteException {
                MediaSessionImplBase.this.postToHandler(12, rating);
            }

            @Override
            public void sendCustomAction(String action, Bundle args) throws RemoteException {
                MediaSessionImplBase.this.postToHandler(13, action, args);
            }

            @Override
            public MediaMetadataCompat getMetadata() {
                return MediaSessionImplBase.this.mMetadata;
            }

            @Override
            public PlaybackStateCompat getPlaybackState() {
                return MediaSessionImplBase.this.getStateWithUpdatedPosition();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<QueueItem> getQueue() {
                Object object = MediaSessionImplBase.this.mLock;
                synchronized (object) {
                    return MediaSessionImplBase.this.mQueue;
                }
            }

            @Override
            public CharSequence getQueueTitle() {
                return MediaSessionImplBase.this.mQueueTitle;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Bundle getExtras() {
                Object object = MediaSessionImplBase.this.mLock;
                synchronized (object) {
                    return MediaSessionImplBase.this.mExtras;
                }
            }

            @Override
            public int getRatingType() {
                return MediaSessionImplBase.this.mRatingType;
            }

            @Override
            public boolean isTransportControlEnabled() {
                return (MediaSessionImplBase.this.mFlags & 2) != 0;
            }
        }
    }

    static interface MediaSessionImpl {
        public void setCallback(Callback var1, Handler var2);

        public void setFlags(int var1);

        public void setPlaybackToLocal(int var1);

        public void setPlaybackToRemote(VolumeProviderCompat var1);

        public void setActive(boolean var1);

        public boolean isActive();

        public void sendSessionEvent(String var1, Bundle var2);

        public void release();

        public Token getSessionToken();

        public void setPlaybackState(PlaybackStateCompat var1);

        public void setMetadata(MediaMetadataCompat var1);

        public void setSessionActivity(PendingIntent var1);

        public void setMediaButtonReceiver(PendingIntent var1);

        public void setQueue(List<QueueItem> var1);

        public void setQueueTitle(CharSequence var1);

        public void setRatingType(int var1);

        public void setExtras(Bundle var1);

        public Object getMediaSession();

        public Object getRemoteControlClient();
    }

    public static interface OnActiveChangeListener {
        public void onActiveChanged();
    }

    static final class ResultReceiverWrapper
    implements Parcelable {
        private ResultReceiver mResultReceiver;
        public static final Parcelable.Creator<ResultReceiverWrapper> CREATOR = new Parcelable.Creator<ResultReceiverWrapper>(){

            public ResultReceiverWrapper createFromParcel(Parcel p) {
                return new ResultReceiverWrapper(p);
            }

            public ResultReceiverWrapper[] newArray(int size) {
                return new ResultReceiverWrapper[size];
            }
        };

        public ResultReceiverWrapper(ResultReceiver resultReceiver) {
            this.mResultReceiver = resultReceiver;
        }

        ResultReceiverWrapper(Parcel in) {
            this.mResultReceiver = (ResultReceiver)ResultReceiver.CREATOR.createFromParcel(in);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            this.mResultReceiver.writeToParcel(dest, flags);
        }
    }

    public static final class QueueItem
    implements Parcelable {
        public static final int UNKNOWN_ID = -1;
        private final MediaDescriptionCompat mDescription;
        private final long mId;
        private Object mItem;
        public static final Parcelable.Creator<QueueItem> CREATOR = new Parcelable.Creator<QueueItem>(){

            public QueueItem createFromParcel(Parcel p) {
                return new QueueItem(p);
            }

            public QueueItem[] newArray(int size) {
                return new QueueItem[size];
            }
        };

        public QueueItem(MediaDescriptionCompat description, long id) {
            this(null, description, id);
        }

        private QueueItem(Object queueItem, MediaDescriptionCompat description, long id) {
            if (description == null) {
                throw new IllegalArgumentException("Description cannot be null.");
            }
            if (id == -1L) {
                throw new IllegalArgumentException("Id cannot be QueueItem.UNKNOWN_ID");
            }
            this.mDescription = description;
            this.mId = id;
            this.mItem = queueItem;
        }

        private QueueItem(Parcel in) {
            this.mDescription = (MediaDescriptionCompat)MediaDescriptionCompat.CREATOR.createFromParcel(in);
            this.mId = in.readLong();
        }

        public MediaDescriptionCompat getDescription() {
            return this.mDescription;
        }

        public long getQueueId() {
            return this.mId;
        }

        public void writeToParcel(Parcel dest, int flags) {
            this.mDescription.writeToParcel(dest, flags);
            dest.writeLong(this.mId);
        }

        public int describeContents() {
            return 0;
        }

        public Object getQueueItem() {
            if (this.mItem != null || Build.VERSION.SDK_INT < 21) {
                return this.mItem;
            }
            this.mItem = MediaSessionCompatApi21.QueueItem.createItem((Object)this.mDescription.getMediaDescription(), (long)this.mId);
            return this.mItem;
        }

        public static QueueItem obtain(Object queueItem) {
            Object descriptionObj = MediaSessionCompatApi21.QueueItem.getDescription((Object)queueItem);
            MediaDescriptionCompat description = MediaDescriptionCompat.fromMediaDescription(descriptionObj);
            long id = MediaSessionCompatApi21.QueueItem.getQueueId((Object)queueItem);
            return new QueueItem(queueItem, description, id);
        }

        public String toString() {
            return "MediaSession.QueueItem {Description=" + this.mDescription + ", Id=" + this.mId + " }";
        }
    }

    public static final class Token
    implements Parcelable {
        private final Object mInner;
        public static final Parcelable.Creator<Token> CREATOR = new Parcelable.Creator<Token>(){

            public Token createFromParcel(Parcel in) {
                Object inner = Build.VERSION.SDK_INT >= 21 ? in.readParcelable(null) : in.readStrongBinder();
                return new Token(inner);
            }

            public Token[] newArray(int size) {
                return new Token[size];
            }
        };

        Token(Object inner) {
            this.mInner = inner;
        }

        public static Token fromToken(Object token) {
            if (token == null || Build.VERSION.SDK_INT < 21) {
                return null;
            }
            return new Token(MediaSessionCompatApi21.verifyToken((Object)token));
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            if (Build.VERSION.SDK_INT >= 21) {
                dest.writeParcelable((Parcelable)this.mInner, flags);
            } else {
                dest.writeStrongBinder((IBinder)this.mInner);
            }
        }

        public Object getToken() {
            return this.mInner;
        }
    }

    public static abstract class Callback {
        final Object mCallbackObj = Build.VERSION.SDK_INT >= 23 ? MediaSessionCompatApi23.createCallback((MediaSessionCompatApi23.Callback)new StubApi23()) : (Build.VERSION.SDK_INT >= 21 ? MediaSessionCompatApi21.createCallback((MediaSessionCompatApi21.Callback)new StubApi21()) : null);

        public void onCommand(String command, Bundle extras, ResultReceiver cb) {
        }

        public boolean onMediaButtonEvent(Intent mediaButtonEvent) {
            return false;
        }

        public void onPlay() {
        }

        public void onPlayFromMediaId(String mediaId, Bundle extras) {
        }

        public void onPlayFromSearch(String query, Bundle extras) {
        }

        public void onPlayFromUri(Uri uri, Bundle extras) {
        }

        public void onSkipToQueueItem(long id) {
        }

        public void onPause() {
        }

        public void onSkipToNext() {
        }

        public void onSkipToPrevious() {
        }

        public void onFastForward() {
        }

        public void onRewind() {
        }

        public void onStop() {
        }

        public void onSeekTo(long pos) {
        }

        public void onSetRating(RatingCompat rating) {
        }

        public void onCustomAction(String action, Bundle extras) {
        }

        private class StubApi23
        extends StubApi21
        implements MediaSessionCompatApi23.Callback {
            private StubApi23() {
            }

            public void onPlayFromUri(Uri uri, Bundle extras) {
                Callback.this.onPlayFromUri(uri, extras);
            }
        }

        private class StubApi21
        implements MediaSessionCompatApi21.Callback {
            private StubApi21() {
            }

            public void onCommand(String command, Bundle extras, ResultReceiver cb) {
                Callback.this.onCommand(command, extras, cb);
            }

            public boolean onMediaButtonEvent(Intent mediaButtonIntent) {
                return Callback.this.onMediaButtonEvent(mediaButtonIntent);
            }

            public void onPlay() {
                Callback.this.onPlay();
            }

            public void onPlayFromMediaId(String mediaId, Bundle extras) {
                Callback.this.onPlayFromMediaId(mediaId, extras);
            }

            public void onPlayFromSearch(String search, Bundle extras) {
                Callback.this.onPlayFromSearch(search, extras);
            }

            public void onSkipToQueueItem(long id) {
                Callback.this.onSkipToQueueItem(id);
            }

            public void onPause() {
                Callback.this.onPause();
            }

            public void onSkipToNext() {
                Callback.this.onSkipToNext();
            }

            public void onSkipToPrevious() {
                Callback.this.onSkipToPrevious();
            }

            public void onFastForward() {
                Callback.this.onFastForward();
            }

            public void onRewind() {
                Callback.this.onRewind();
            }

            public void onStop() {
                Callback.this.onStop();
            }

            public void onSeekTo(long pos) {
                Callback.this.onSeekTo(pos);
            }

            public void onSetRating(Object ratingObj) {
                Callback.this.onSetRating(RatingCompat.fromRating(ratingObj));
            }

            public void onCustomAction(String action, Bundle extras) {
                if (action.equals(MediaSessionCompat.ACTION_PLAY_FROM_URI)) {
                    Uri uri = (Uri)extras.getParcelable(MediaSessionCompat.ACTION_ARGUMENT_URI);
                    Bundle bundle = (Bundle)extras.getParcelable(MediaSessionCompat.ACTION_ARGUMENT_EXTRAS);
                    Callback.this.onPlayFromUri(uri, bundle);
                } else {
                    Callback.this.onCustomAction(action, extras);
                }
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SessionFlags {
    }
}

