/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.graphics.drawable.AnimatedVectorDrawableCompat;
import android.support.graphics.drawable.VectorDrawableCompat;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.ColorUtils;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v4.util.ArrayMap;
import android.support.v4.util.LongSparseArray;
import android.support.v4.util.LruCache;
import android.support.v7.appcompat.R;
import android.support.v7.content.res.AppCompatResources;
import android.support.v7.widget.DrawableUtils;
import android.support.v7.widget.ThemeUtils;
import android.support.v7.widget.TintInfo;
import android.support.v7.widget.VectorEnabledTintResources;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.util.TypedValue;
import android.util.Xml;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class AppCompatDrawableManager {
    private static final String TAG = "AppCompatDrawableManager";
    private static final boolean DEBUG = false;
    private static final PorterDuff.Mode DEFAULT_MODE = PorterDuff.Mode.SRC_IN;
    private static final String SKIP_DRAWABLE_TAG = "appcompat_skip_skip";
    private static final String PLATFORM_VD_CLAZZ = "android.graphics.drawable.VectorDrawable";
    private static AppCompatDrawableManager INSTANCE;
    private static final ColorFilterLruCache COLOR_FILTER_CACHE;
    private static final int[] COLORFILTER_TINT_COLOR_CONTROL_NORMAL;
    private static final int[] TINT_COLOR_CONTROL_NORMAL;
    private static final int[] COLORFILTER_COLOR_CONTROL_ACTIVATED;
    private static final int[] COLORFILTER_COLOR_BACKGROUND_MULTIPLY;
    private static final int[] TINT_COLOR_CONTROL_STATE_LIST;
    private static final int[] TINT_CHECKABLE_BUTTON_LIST;
    private WeakHashMap<Context, SparseArray<ColorStateList>> mTintLists;
    private ArrayMap<String, InflateDelegate> mDelegates;
    private SparseArray<String> mKnownDrawableIdTags;
    private final Object mDrawableCacheLock = new Object();
    private final WeakHashMap<Context, LongSparseArray<WeakReference<Drawable.ConstantState>>> mDrawableCaches = new WeakHashMap(0);
    private TypedValue mTypedValue;
    private boolean mHasCheckedVectorDrawableSetup;

    public static AppCompatDrawableManager get() {
        if (INSTANCE == null) {
            INSTANCE = new AppCompatDrawableManager();
            AppCompatDrawableManager.installDefaultInflateDelegates(INSTANCE);
        }
        return INSTANCE;
    }

    private static void installDefaultInflateDelegates(@NonNull AppCompatDrawableManager manager) {
        int sdk = Build.VERSION.SDK_INT;
        if (sdk < 23) {
            manager.addDelegate("vector", new VdcInflateDelegate());
            if (sdk >= 11) {
                manager.addDelegate("animated-vector", new AvdcInflateDelegate());
            }
        }
    }

    public Drawable getDrawable(@NonNull Context context, @DrawableRes int resId) {
        return this.getDrawable(context, resId, false);
    }

    Drawable getDrawable(@NonNull Context context, @DrawableRes int resId, boolean failIfNotKnown) {
        this.checkVectorDrawableSetup(context);
        Drawable drawable2 = this.loadDrawableFromDelegates(context, resId);
        if (drawable2 == null) {
            drawable2 = this.createDrawableIfNeeded(context, resId);
        }
        if (drawable2 == null) {
            drawable2 = ContextCompat.getDrawable((Context)context, (int)resId);
        }
        if (drawable2 != null) {
            drawable2 = this.tintDrawable(context, resId, failIfNotKnown, drawable2);
        }
        if (drawable2 != null) {
            DrawableUtils.fixDrawable(drawable2);
        }
        return drawable2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConfigurationChanged(@NonNull Context context) {
        Object object = this.mDrawableCacheLock;
        synchronized (object) {
            LongSparseArray<WeakReference<Drawable.ConstantState>> cache = this.mDrawableCaches.get(context);
            if (cache != null) {
                cache.clear();
            }
        }
    }

    private static long createCacheKey(TypedValue tv) {
        return (long)tv.assetCookie << 32 | (long)tv.data;
    }

    private Drawable createDrawableIfNeeded(@NonNull Context context, @DrawableRes int resId) {
        if (this.mTypedValue == null) {
            this.mTypedValue = new TypedValue();
        }
        TypedValue tv = this.mTypedValue;
        context.getResources().getValue(resId, tv, true);
        long key = AppCompatDrawableManager.createCacheKey(tv);
        Drawable dr = this.getCachedDrawable(context, key);
        if (dr != null) {
            return dr;
        }
        if (resId == R.drawable.abc_cab_background_top_material) {
            dr = new LayerDrawable(new Drawable[]{this.getDrawable(context, R.drawable.abc_cab_background_internal_bg), this.getDrawable(context, R.drawable.abc_cab_background_top_mtrl_alpha)});
        }
        if (dr != null) {
            dr.setChangingConfigurations(tv.changingConfigurations);
            this.addDrawableToCache(context, key, dr);
        }
        return dr;
    }

    private Drawable tintDrawable(@NonNull Context context, @DrawableRes int resId, boolean failIfNotKnown, @NonNull Drawable drawable2) {
        ColorStateList tintList = this.getTintList(context, resId);
        if (tintList != null) {
            if (DrawableUtils.canSafelyMutateDrawable(drawable2)) {
                drawable2 = drawable2.mutate();
            }
            drawable2 = DrawableCompat.wrap((Drawable)drawable2);
            DrawableCompat.setTintList((Drawable)drawable2, (ColorStateList)tintList);
            PorterDuff.Mode tintMode = AppCompatDrawableManager.getTintMode(resId);
            if (tintMode != null) {
                DrawableCompat.setTintMode((Drawable)drawable2, (PorterDuff.Mode)tintMode);
            }
        } else if (resId == R.drawable.abc_seekbar_track_material) {
            LayerDrawable ld = (LayerDrawable)drawable2;
            AppCompatDrawableManager.setPorterDuffColorFilter(ld.findDrawableByLayerId(0x1020000), ThemeUtils.getThemeAttrColor(context, R.attr.colorControlNormal), DEFAULT_MODE);
            AppCompatDrawableManager.setPorterDuffColorFilter(ld.findDrawableByLayerId(16908303), ThemeUtils.getThemeAttrColor(context, R.attr.colorControlNormal), DEFAULT_MODE);
            AppCompatDrawableManager.setPorterDuffColorFilter(ld.findDrawableByLayerId(16908301), ThemeUtils.getThemeAttrColor(context, R.attr.colorControlActivated), DEFAULT_MODE);
        } else if (resId == R.drawable.abc_ratingbar_material || resId == R.drawable.abc_ratingbar_indicator_material || resId == R.drawable.abc_ratingbar_small_material) {
            LayerDrawable ld = (LayerDrawable)drawable2;
            AppCompatDrawableManager.setPorterDuffColorFilter(ld.findDrawableByLayerId(0x1020000), ThemeUtils.getDisabledThemeAttrColor(context, R.attr.colorControlNormal), DEFAULT_MODE);
            AppCompatDrawableManager.setPorterDuffColorFilter(ld.findDrawableByLayerId(16908303), ThemeUtils.getThemeAttrColor(context, R.attr.colorControlActivated), DEFAULT_MODE);
            AppCompatDrawableManager.setPorterDuffColorFilter(ld.findDrawableByLayerId(16908301), ThemeUtils.getThemeAttrColor(context, R.attr.colorControlActivated), DEFAULT_MODE);
        } else {
            boolean tinted = AppCompatDrawableManager.tintDrawableUsingColorFilter(context, resId, drawable2);
            if (!tinted && failIfNotKnown) {
                drawable2 = null;
            }
        }
        return drawable2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Drawable loadDrawableFromDelegates(@NonNull Context context, @DrawableRes int resId) {
        if (this.mDelegates != null && !this.mDelegates.isEmpty()) {
            if (this.mKnownDrawableIdTags != null) {
                String cachedTagName = (String)this.mKnownDrawableIdTags.get(resId);
                if (SKIP_DRAWABLE_TAG.equals(cachedTagName) || cachedTagName != null && this.mDelegates.get((Object)cachedTagName) == null) {
                    return null;
                }
            } else {
                this.mKnownDrawableIdTags = new SparseArray();
            }
            if (this.mTypedValue == null) {
                this.mTypedValue = new TypedValue();
            }
            TypedValue tv = this.mTypedValue;
            Resources res = context.getResources();
            res.getValue(resId, tv, true);
            long key = AppCompatDrawableManager.createCacheKey(tv);
            Drawable dr = this.getCachedDrawable(context, key);
            if (dr != null) {
                return dr;
            }
            if (tv.string != null && tv.string.toString().endsWith(".xml")) {
                try {
                    int type;
                    XmlResourceParser parser = res.getXml(resId);
                    AttributeSet attrs = Xml.asAttributeSet((XmlPullParser)parser);
                    while ((type = parser.next()) != 2 && type != 1) {
                    }
                    if (type != 2) {
                        throw new XmlPullParserException("No start tag found");
                    }
                    String tagName = parser.getName();
                    this.mKnownDrawableIdTags.append(resId, (Object)tagName);
                    InflateDelegate delegate = (InflateDelegate)this.mDelegates.get((Object)tagName);
                    if (delegate != null) {
                        dr = delegate.createFromXmlInner(context, (XmlPullParser)parser, attrs, context.getTheme());
                    }
                    if (dr != null) {
                        dr.setChangingConfigurations(tv.changingConfigurations);
                        if (!this.addDrawableToCache(context, key, dr)) {
                            // empty if block
                        }
                    }
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)"Exception while inflating drawable", (Throwable)e);
                }
            }
            if (dr == null) {
                this.mKnownDrawableIdTags.append(resId, (Object)SKIP_DRAWABLE_TAG);
            }
            return dr;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Drawable getCachedDrawable(@NonNull Context context, long key) {
        Object object = this.mDrawableCacheLock;
        synchronized (object) {
            LongSparseArray<WeakReference<Drawable.ConstantState>> cache = this.mDrawableCaches.get(context);
            if (cache == null) {
                return null;
            }
            WeakReference wr = (WeakReference)cache.get(key);
            if (wr != null) {
                Drawable.ConstantState entry = (Drawable.ConstantState)wr.get();
                if (entry != null) {
                    return entry.newDrawable(context.getResources());
                }
                cache.delete(key);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addDrawableToCache(@NonNull Context context, long key, @NonNull Drawable drawable2) {
        Drawable.ConstantState cs = drawable2.getConstantState();
        if (cs != null) {
            Object object = this.mDrawableCacheLock;
            synchronized (object) {
                LongSparseArray cache = this.mDrawableCaches.get(context);
                if (cache == null) {
                    cache = new LongSparseArray();
                    this.mDrawableCaches.put(context, (LongSparseArray<WeakReference<Drawable.ConstantState>>)cache);
                }
                cache.put(key, new WeakReference<Drawable.ConstantState>(cs));
            }
            return true;
        }
        return false;
    }

    Drawable onDrawableLoadedFromResources(@NonNull Context context, @NonNull VectorEnabledTintResources resources, @DrawableRes int resId) {
        Drawable drawable2 = this.loadDrawableFromDelegates(context, resId);
        if (drawable2 == null) {
            drawable2 = resources.superGetDrawable(resId);
        }
        if (drawable2 != null) {
            return this.tintDrawable(context, resId, false, drawable2);
        }
        return null;
    }

    static boolean tintDrawableUsingColorFilter(@NonNull Context context, @DrawableRes int resId, @NonNull Drawable drawable2) {
        PorterDuff.Mode tintMode = DEFAULT_MODE;
        boolean colorAttrSet = false;
        int colorAttr = 0;
        int alpha = -1;
        if (AppCompatDrawableManager.arrayContains(COLORFILTER_TINT_COLOR_CONTROL_NORMAL, resId)) {
            colorAttr = R.attr.colorControlNormal;
            colorAttrSet = true;
        } else if (AppCompatDrawableManager.arrayContains(COLORFILTER_COLOR_CONTROL_ACTIVATED, resId)) {
            colorAttr = R.attr.colorControlActivated;
            colorAttrSet = true;
        } else if (AppCompatDrawableManager.arrayContains(COLORFILTER_COLOR_BACKGROUND_MULTIPLY, resId)) {
            colorAttr = 0x1010031;
            colorAttrSet = true;
            tintMode = PorterDuff.Mode.MULTIPLY;
        } else if (resId == R.drawable.abc_list_divider_mtrl_alpha) {
            colorAttr = 0x1010030;
            colorAttrSet = true;
            alpha = Math.round(40.8f);
        } else if (resId == R.drawable.abc_dialog_material_background) {
            colorAttr = 0x1010031;
            colorAttrSet = true;
        }
        if (colorAttrSet) {
            if (DrawableUtils.canSafelyMutateDrawable(drawable2)) {
                drawable2 = drawable2.mutate();
            }
            int color2 = ThemeUtils.getThemeAttrColor(context, colorAttr);
            drawable2.setColorFilter((ColorFilter)AppCompatDrawableManager.getPorterDuffColorFilter(color2, tintMode));
            if (alpha != -1) {
                drawable2.setAlpha(alpha);
            }
            return true;
        }
        return false;
    }

    private void addDelegate(@NonNull String tagName, @NonNull InflateDelegate delegate) {
        if (this.mDelegates == null) {
            this.mDelegates = new ArrayMap();
        }
        this.mDelegates.put((Object)tagName, (Object)delegate);
    }

    private void removeDelegate(@NonNull String tagName, @NonNull InflateDelegate delegate) {
        if (this.mDelegates != null && this.mDelegates.get((Object)tagName) == delegate) {
            this.mDelegates.remove((Object)tagName);
        }
    }

    private static boolean arrayContains(int[] array, int value) {
        for (int id2 : array) {
            if (id2 != value) continue;
            return true;
        }
        return false;
    }

    static PorterDuff.Mode getTintMode(int resId) {
        PorterDuff.Mode mode = null;
        if (resId == R.drawable.abc_switch_thumb_material) {
            mode = PorterDuff.Mode.MULTIPLY;
        }
        return mode;
    }

    ColorStateList getTintList(@NonNull Context context, @DrawableRes int resId) {
        return this.getTintList(context, resId, null);
    }

    ColorStateList getTintList(@NonNull Context context, @DrawableRes int resId, @Nullable ColorStateList customTint) {
        ColorStateList tint;
        boolean useCache = customTint == null;
        ColorStateList colorStateList = tint = useCache ? this.getTintListFromCache(context, resId) : null;
        if (tint == null) {
            if (resId == R.drawable.abc_edit_text_material) {
                tint = AppCompatResources.getColorStateList(context, R.color.abc_tint_edittext);
            } else if (resId == R.drawable.abc_switch_track_mtrl_alpha) {
                tint = AppCompatResources.getColorStateList(context, R.color.abc_tint_switch_track);
            } else if (resId == R.drawable.abc_switch_thumb_material) {
                tint = AppCompatResources.getColorStateList(context, R.color.abc_tint_switch_thumb);
            } else if (resId == R.drawable.abc_btn_default_mtrl_shape) {
                tint = this.createDefaultButtonColorStateList(context, customTint);
            } else if (resId == R.drawable.abc_btn_borderless_material) {
                tint = this.createBorderlessButtonColorStateList(context, customTint);
            } else if (resId == R.drawable.abc_btn_colored_material) {
                tint = this.createColoredButtonColorStateList(context, customTint);
            } else if (resId == R.drawable.abc_spinner_mtrl_am_alpha || resId == R.drawable.abc_spinner_textfield_background_material) {
                tint = AppCompatResources.getColorStateList(context, R.color.abc_tint_spinner);
            } else if (AppCompatDrawableManager.arrayContains(TINT_COLOR_CONTROL_NORMAL, resId)) {
                tint = ThemeUtils.getThemeAttrColorStateList(context, R.attr.colorControlNormal);
            } else if (AppCompatDrawableManager.arrayContains(TINT_COLOR_CONTROL_STATE_LIST, resId)) {
                tint = AppCompatResources.getColorStateList(context, R.color.abc_tint_default);
            } else if (AppCompatDrawableManager.arrayContains(TINT_CHECKABLE_BUTTON_LIST, resId)) {
                tint = AppCompatResources.getColorStateList(context, R.color.abc_tint_btn_checkable);
            } else if (resId == R.drawable.abc_seekbar_thumb_material) {
                tint = AppCompatResources.getColorStateList(context, R.color.abc_tint_seek_thumb);
            }
            if (useCache && tint != null) {
                this.addTintListToCache(context, resId, tint);
            }
        }
        return tint;
    }

    private ColorStateList getTintListFromCache(@NonNull Context context, @DrawableRes int resId) {
        if (this.mTintLists != null) {
            SparseArray<ColorStateList> tints = this.mTintLists.get(context);
            return tints != null ? (ColorStateList)tints.get(resId) : null;
        }
        return null;
    }

    private void addTintListToCache(@NonNull Context context, @DrawableRes int resId, @NonNull ColorStateList tintList) {
        SparseArray themeTints;
        if (this.mTintLists == null) {
            this.mTintLists = new WeakHashMap();
        }
        if ((themeTints = this.mTintLists.get(context)) == null) {
            themeTints = new SparseArray();
            this.mTintLists.put(context, (SparseArray<ColorStateList>)themeTints);
        }
        themeTints.append(resId, (Object)tintList);
    }

    private ColorStateList createDefaultButtonColorStateList(@NonNull Context context, @Nullable ColorStateList customTint) {
        return this.createButtonColorStateList(context, ThemeUtils.getThemeAttrColor(context, R.attr.colorButtonNormal), customTint);
    }

    private ColorStateList createBorderlessButtonColorStateList(@NonNull Context context, @Nullable ColorStateList customTint) {
        return this.createButtonColorStateList(context, 0, null);
    }

    private ColorStateList createColoredButtonColorStateList(@NonNull Context context, @Nullable ColorStateList customTint) {
        return this.createButtonColorStateList(context, ThemeUtils.getThemeAttrColor(context, R.attr.colorAccent), customTint);
    }

    private ColorStateList createButtonColorStateList(@NonNull Context context, @ColorInt int baseColor, @Nullable ColorStateList tint) {
        int[][] states = new int[4][];
        int[] colors = new int[4];
        int i = 0;
        int colorControlHighlight = ThemeUtils.getThemeAttrColor(context, R.attr.colorControlHighlight);
        int disabledColor = ThemeUtils.getDisabledThemeAttrColor(context, R.attr.colorButtonNormal);
        states[i] = ThemeUtils.DISABLED_STATE_SET;
        colors[i] = tint == null ? disabledColor : tint.getColorForState(states[i], 0);
        states[++i] = ThemeUtils.PRESSED_STATE_SET;
        colors[i] = ColorUtils.compositeColors((int)colorControlHighlight, (int)(tint == null ? baseColor : tint.getColorForState(states[i], 0)));
        states[++i] = ThemeUtils.FOCUSED_STATE_SET;
        colors[i] = ColorUtils.compositeColors((int)colorControlHighlight, (int)(tint == null ? baseColor : tint.getColorForState(states[i], 0)));
        states[++i] = ThemeUtils.EMPTY_STATE_SET;
        colors[i] = tint == null ? baseColor : tint.getColorForState(states[i], 0);
        ++i;
        return new ColorStateList((int[][])states, colors);
    }

    static void tintDrawable(Drawable drawable2, TintInfo tint, int[] state) {
        if (DrawableUtils.canSafelyMutateDrawable(drawable2) && drawable2.mutate() != drawable2) {
            Log.d((String)TAG, (String)"Mutated drawable is not the same instance as the input.");
            return;
        }
        if (tint.mHasTintList || tint.mHasTintMode) {
            drawable2.setColorFilter((ColorFilter)AppCompatDrawableManager.createTintFilter(tint.mHasTintList ? tint.mTintList : null, tint.mHasTintMode ? tint.mTintMode : DEFAULT_MODE, state));
        } else {
            drawable2.clearColorFilter();
        }
        if (Build.VERSION.SDK_INT <= 23) {
            drawable2.invalidateSelf();
        }
    }

    private static PorterDuffColorFilter createTintFilter(ColorStateList tint, PorterDuff.Mode tintMode, int[] state) {
        if (tint == null || tintMode == null) {
            return null;
        }
        int color2 = tint.getColorForState(state, 0);
        return AppCompatDrawableManager.getPorterDuffColorFilter(color2, tintMode);
    }

    public static PorterDuffColorFilter getPorterDuffColorFilter(int color2, PorterDuff.Mode mode) {
        PorterDuffColorFilter filter = COLOR_FILTER_CACHE.get(color2, mode);
        if (filter == null) {
            filter = new PorterDuffColorFilter(color2, mode);
            COLOR_FILTER_CACHE.put(color2, mode, filter);
        }
        return filter;
    }

    private static void setPorterDuffColorFilter(Drawable d, int color2, PorterDuff.Mode mode) {
        if (DrawableUtils.canSafelyMutateDrawable(d)) {
            d = d.mutate();
        }
        d.setColorFilter((ColorFilter)AppCompatDrawableManager.getPorterDuffColorFilter(color2, mode == null ? DEFAULT_MODE : mode));
    }

    private void checkVectorDrawableSetup(@NonNull Context context) {
        if (this.mHasCheckedVectorDrawableSetup) {
            return;
        }
        this.mHasCheckedVectorDrawableSetup = true;
        Drawable d = this.getDrawable(context, R.drawable.abc_vector_test);
        if (d == null || !AppCompatDrawableManager.isVectorDrawable(d)) {
            this.mHasCheckedVectorDrawableSetup = false;
            throw new IllegalStateException("This app has been built with an incorrect configuration. Please configure your build for VectorDrawableCompat.");
        }
    }

    private static boolean isVectorDrawable(@NonNull Drawable d) {
        return d instanceof VectorDrawableCompat || PLATFORM_VD_CLAZZ.equals(d.getClass().getName());
    }

    static {
        COLOR_FILTER_CACHE = new ColorFilterLruCache(6);
        COLORFILTER_TINT_COLOR_CONTROL_NORMAL = new int[]{R.drawable.abc_textfield_search_default_mtrl_alpha, R.drawable.abc_textfield_default_mtrl_alpha, R.drawable.abc_ab_share_pack_mtrl_alpha};
        TINT_COLOR_CONTROL_NORMAL = new int[]{R.drawable.abc_ic_commit_search_api_mtrl_alpha, R.drawable.abc_seekbar_tick_mark_material, R.drawable.abc_ic_menu_share_mtrl_alpha, R.drawable.abc_ic_menu_copy_mtrl_am_alpha, R.drawable.abc_ic_menu_cut_mtrl_alpha, R.drawable.abc_ic_menu_selectall_mtrl_alpha, R.drawable.abc_ic_menu_paste_mtrl_am_alpha};
        COLORFILTER_COLOR_CONTROL_ACTIVATED = new int[]{R.drawable.abc_textfield_activated_mtrl_alpha, R.drawable.abc_textfield_search_activated_mtrl_alpha, R.drawable.abc_cab_background_top_mtrl_alpha, R.drawable.abc_text_cursor_material, R.drawable.abc_text_select_handle_left_mtrl_dark, R.drawable.abc_text_select_handle_middle_mtrl_dark, R.drawable.abc_text_select_handle_right_mtrl_dark, R.drawable.abc_text_select_handle_left_mtrl_light, R.drawable.abc_text_select_handle_middle_mtrl_light, R.drawable.abc_text_select_handle_right_mtrl_light};
        COLORFILTER_COLOR_BACKGROUND_MULTIPLY = new int[]{R.drawable.abc_popup_background_mtrl_mult, R.drawable.abc_cab_background_internal_bg, R.drawable.abc_menu_hardkey_panel_mtrl_mult};
        TINT_COLOR_CONTROL_STATE_LIST = new int[]{R.drawable.abc_tab_indicator_material, R.drawable.abc_textfield_search_material};
        TINT_CHECKABLE_BUTTON_LIST = new int[]{R.drawable.abc_btn_check_material, R.drawable.abc_btn_radio_material};
    }

    private static class AvdcInflateDelegate
    implements InflateDelegate {
        AvdcInflateDelegate() {
        }

        @Override
        public Drawable createFromXmlInner(@NonNull Context context, @NonNull XmlPullParser parser, @NonNull AttributeSet attrs, @Nullable Resources.Theme theme) {
            try {
                return AnimatedVectorDrawableCompat.createFromXmlInner((Context)context, (Resources)context.getResources(), (XmlPullParser)parser, (AttributeSet)attrs, (Resources.Theme)theme);
            }
            catch (Exception e) {
                Log.e((String)"AvdcInflateDelegate", (String)"Exception while inflating <animated-vector>", (Throwable)e);
                return null;
            }
        }
    }

    private static class VdcInflateDelegate
    implements InflateDelegate {
        VdcInflateDelegate() {
        }

        @Override
        public Drawable createFromXmlInner(@NonNull Context context, @NonNull XmlPullParser parser, @NonNull AttributeSet attrs, @Nullable Resources.Theme theme) {
            try {
                return VectorDrawableCompat.createFromXmlInner((Resources)context.getResources(), (XmlPullParser)parser, (AttributeSet)attrs, (Resources.Theme)theme);
            }
            catch (Exception e) {
                Log.e((String)"VdcInflateDelegate", (String)"Exception while inflating <vector>", (Throwable)e);
                return null;
            }
        }
    }

    private static class ColorFilterLruCache
    extends LruCache<Integer, PorterDuffColorFilter> {
        public ColorFilterLruCache(int maxSize) {
            super(maxSize);
        }

        PorterDuffColorFilter get(int color2, PorterDuff.Mode mode) {
            return (PorterDuffColorFilter)this.get(ColorFilterLruCache.generateCacheKey(color2, mode));
        }

        PorterDuffColorFilter put(int color2, PorterDuff.Mode mode, PorterDuffColorFilter filter) {
            return (PorterDuffColorFilter)this.put(ColorFilterLruCache.generateCacheKey(color2, mode), filter);
        }

        private static int generateCacheKey(int color2, PorterDuff.Mode mode) {
            int hashCode = 1;
            hashCode = 31 * hashCode + color2;
            hashCode = 31 * hashCode + mode.hashCode();
            return hashCode;
        }
    }

    private static interface InflateDelegate {
        public Drawable createFromXmlInner(@NonNull Context var1, @NonNull XmlPullParser var2, @NonNull AttributeSet var3, @Nullable Resources.Theme var4);
    }
}

