package computervision.grewe.serviceoverlaywithcallbacktoactivity;


        import android.annotation.TargetApi;
        import android.app.Activity;
        import android.content.Context;
        import android.content.Intent;
        import android.net.Uri;
        import android.os.Build;
        import android.provider.Settings;
        import android.support.v7.app.AppCompatActivity;
        import android.os.Bundle;
        import android.webkit.WebView;
        import android.webkit.WebViewClient;

//Dummy activity that has a TextView and WebView as interface
//important part is that this Android has a Service class called HUD that creates
// an overlay window that appears on top of any actively running application window
//not just this activity --it runs in the background.   You can use it to
//return to this app or do whatever
public class MainActivity extends AppCompatActivity {


    private int request_Code = 1;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);


        //YOU MAY want to get rid of these --it opens the apps settings so user can turn on permission for overlay
        //The only way the user can return to the app is to hit the "back" button on the device
        //Purpose = In newer version of Android any app that creates an Overlay requires the user
        // to specifically set this permission on the app's settings on the device.  It is not enough
        // to request the permission in the AndroidManifest file

        requestSystemAlertPermission(MainActivity.this,1);
        isSystemAlertPermissionGranted(MainActivity.this);

        //start the service
        startService(new Intent(getApplicationContext(), HUD.class));


    }

    @Override
    protected void onStart() {
        super.onStart();
        setupView();

    }

    /**
     * method to setup the View with content in Activity
     */
    private void setupView(){

    }




    public static void requestSystemAlertPermission(Activity context, int requestCode) {
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.M)
            return;
        final String packageName = context == null ? context.getPackageName() : context.getPackageName();
        final Intent intent = new Intent(Settings.ACTION_MANAGE_OVERLAY_PERMISSION, Uri.parse("package:" + packageName));
        if (context != null)
            context.startActivityForResult(intent, requestCode);
        else
            context.startActivityForResult(intent, requestCode);
    }
    @TargetApi(23)
    public static boolean isSystemAlertPermissionGranted(Context context) {
        final boolean result = Build.VERSION.SDK_INT < Build.VERSION_CODES.M || Settings.canDrawOverlays(context);
        return result;
    }

    //callback function to get results from ACTION_MANAGE_OVERLAY_PERMISSION "activity" when it is done
    public void onActivityResult(int requestCode, int resultCode, Intent data)
    {
        if (requestCode == request_Code) {
            if (resultCode == RESULT_OK) {
                this.setupView();
            }
        }
    }
}
