package computervision.grewe.serviceoverlaywithcallbacktoactivity;



        import android.app.Service;
        import android.content.Intent;
        import android.os.IBinder;


        import android.app.Service;
        import android.content.Intent;
        import android.graphics.PixelFormat;
        import android.net.Uri;
        import android.os.IBinder;
        import android.view.Gravity;
        import android.view.LayoutInflater;
        import android.view.View;
        import android.view.WindowManager;
        import android.widget.FrameLayout;
        import android.widget.ImageButton;
        import android.widget.ImageView;
        import android.widget.LinearLayout;
        import android.widget.RelativeLayout;

/**
 * Class that is a background Service that creates an Overlay Window that can reside on top
 * of any running activity.
 * WHEN the interface is clicked on close it will launch the
 */
public class HUD extends Service {

    private WindowManager windowManager;
    private ImageView close;
    private LinearLayout overlayLayout;
    private ImageView overlayButton;


    /*
     @Override
     public IBinder onBind(Intent intent) {
         // Not used
         return null;
     }
     */
    @Override
    public IBinder onBind(Intent intent) {
        // TODO: Return the communication channel to the service.
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public void onCreate() {
        super.onCreate();

        //using the WindowManager launch the Service  with interface activity_alert_dialog
        windowManager = (WindowManager) getSystemService(WINDOW_SERVICE);
        LayoutInflater inflater = (LayoutInflater)getSystemService(LAYOUT_INFLATER_SERVICE);



        WindowManager.LayoutParams params = new WindowManager.LayoutParams(
                WindowManager.LayoutParams.WRAP_CONTENT,
                WindowManager.LayoutParams.WRAP_CONTENT,
                WindowManager.LayoutParams.TYPE_PHONE,
                WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE,
                PixelFormat.TRANSLUCENT);

        //will put the  "floating window = overlay" to top and left
        params.gravity = Gravity.TOP | Gravity.LEFT;
        params.x = 0;
        params.y = 100;

        //Inflate the ouverlay_layout.xml file that contains and Image "J" logo for "journaling"
        // and an "x" image representing a close of a window
        overlayLayout = (LinearLayout) inflater.inflate(R.layout.overlay_layout, null);
        close=(ImageView)overlayLayout.findViewById(R.id.close);
        overlayButton=(ImageView) overlayLayout.findViewById(R.id.overlayButton);

        //register listener for "J" logo ImageView widget that is part of this Service's "floating window
        //when clicked on it will lauch the Activity associated with this application as an Intent and then
        //stop THIS service from running
        overlayButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                //remove the view of the Overlay
                windowManager.removeView(overlayLayout);





                //restart the Activity MainActivity associated with this application
                Intent intent_start_mainProcessing_activity = new Intent(getApplicationContext(), MainProcessingActivity.class);
                intent_start_mainProcessing_activity.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);

                startActivity(intent_start_mainProcessing_activity);


                //stop this background service
                stopService(new Intent(getApplicationContext(), HUD.class));
            }
        });

        //when the x image = "close"  it simply stops the service
        close.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                windowManager.removeView(overlayLayout);

                //simply stopping Service
                stopService(new Intent(getApplicationContext(), HUD.class));
                // startService(new Intent(getApplicationContext(), HUD.class)); //code to start service in case wanted to see it
            }
        });

        windowManager.addView(overlayLayout, params);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
       /* if (overlayLayout != null) windowManager.removeView(overlayLayout);*/
    }
}



/*

@Override
public IBinder onBind(Intent intent) {
        // TODO: Return the communication channel to the service.
        throw new UnsupportedOperationException("Not yet implemented");
        }
*/