/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Looper;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzdi;
import com.google.android.gms.internal.zziy;
import com.google.android.gms.internal.zzkn;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedList;

@zziy
public class zzix
implements Thread.UncaughtExceptionHandler {
    @Nullable
    private Thread.UncaughtExceptionHandler zzcff;
    @Nullable
    private Thread.UncaughtExceptionHandler zzcfg;
    private Context mContext;
    private VersionInfoParcel zzaop;

    public static zzix zza(Context context, Thread thread, VersionInfoParcel versionInfoParcel) {
        if (context == null || thread == null || versionInfoParcel == null) {
            return null;
        }
        if (!zzix.zzu(context)) {
            return null;
        }
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = thread.getUncaughtExceptionHandler();
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler2 = thread.getDefaultUncaughtExceptionHandler();
        zzix zzix2 = new zzix(context, versionInfoParcel, uncaughtExceptionHandler, uncaughtExceptionHandler2);
        if (uncaughtExceptionHandler == null || !(uncaughtExceptionHandler instanceof zzix)) {
            try {
                thread.setUncaughtExceptionHandler(zzix2);
                return zzix2;
            }
            catch (SecurityException securityException) {
                zzkn.zzc((String)"Fail to set UncaughtExceptionHandler.", (Throwable)securityException);
            }
        } else {
            return (zzix)uncaughtExceptionHandler;
        }
        return null;
    }

    private static boolean zzu(Context context) {
        return zzdi.zzbat.get();
    }

    public zzix(Context context, VersionInfoParcel versionInfoParcel, @Nullable Thread.UncaughtExceptionHandler uncaughtExceptionHandler, @Nullable Thread.UncaughtExceptionHandler uncaughtExceptionHandler2) {
        this.zzcff = uncaughtExceptionHandler;
        this.zzcfg = uncaughtExceptionHandler2;
        this.mContext = context;
        this.zzaop = versionInfoParcel;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        if (this.zzb(throwable)) {
            if (Looper.getMainLooper().getThread() != thread) {
                this.zza(throwable, "AdMobExceptionReporter.uncaughtException");
                return;
            }
            this.zzc(throwable);
        }
        if (this.zzcff != null) {
            this.zzcff.uncaughtException(thread, throwable);
        } else if (this.zzcfg != null) {
            this.zzcfg.uncaughtException(thread, throwable);
        }
    }

    protected boolean zzb(Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        while (throwable != null) {
            StackTraceElement[] stackTraceElementArray;
            for (StackTraceElement stackTraceElement : stackTraceElementArray = throwable.getStackTrace()) {
                if (this.zzcg(stackTraceElement.getClassName())) {
                    bl = true;
                }
                if (!this.getClass().getName().equals(stackTraceElement.getClassName())) continue;
                bl2 = true;
            }
            throwable = throwable.getCause();
        }
        return bl && !bl2;
    }

    protected boolean zzcg(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        if (string2.startsWith(zzdi.zzbav.get())) {
            return true;
        }
        try {
            Class<?> clazz = Class.forName(string2);
            return clazz.isAnnotationPresent(zziy.class);
        }
        catch (Exception exception) {
            String string3 = String.valueOf(string2);
            zzkn.zza((String)(string3.length() != 0 ? "Fail to check class type for class ".concat(string3) : new String("Fail to check class type for class ")), (Throwable)exception);
            return false;
        }
    }

    protected boolean zzch(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        return string2.startsWith("android.") || string2.startsWith("java.");
    }

    public void zzc(Throwable throwable) {
        this.zza(throwable, "");
    }

    public void zza(Throwable throwable, String string2) {
        if (!zzix.zzu(this.mContext)) {
            return;
        }
        Throwable throwable2 = this.zzd(throwable);
        if (throwable2 == null) {
            return;
        }
        Class<?> clazz = throwable.getClass();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.zza(clazz, throwable2, string2));
        zzu.zzfz().zza(arrayList, zzu.zzgd().zztp());
    }

    String zza(Class clazz, Throwable throwable, String string2) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        Uri.Builder builder = new Uri.Builder().scheme("https").path("//pagead2.googlesyndication.com/pagead/gen_204").appendQueryParameter("id", "gmob-apps-report-exception").appendQueryParameter("os", Build.VERSION.RELEASE).appendQueryParameter("api", String.valueOf(Build.VERSION.SDK_INT)).appendQueryParameter("device", zzu.zzfz().zzuj()).appendQueryParameter("js", this.zzaop.zzcs).appendQueryParameter("appid", this.mContext.getApplicationContext().getPackageName()).appendQueryParameter("exceptiontype", clazz.getName()).appendQueryParameter("stacktrace", stringWriter.toString()).appendQueryParameter("eids", TextUtils.join((CharSequence)",", zzdi.zzkr())).appendQueryParameter("exceptionkey", string2).appendQueryParameter("cl", "134102376").appendQueryParameter("rc", "dev");
        return builder.toString();
    }

    private Throwable zzd(Throwable throwable) {
        Throwable throwable2;
        if (zzdi.zzbau.get().booleanValue()) {
            return throwable;
        }
        LinkedList<Throwable> linkedList = new LinkedList<Throwable>();
        for (throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
            linkedList.push(throwable2);
        }
        Throwable throwable3 = null;
        while (!linkedList.isEmpty()) {
            throwable2 = (Throwable)linkedList.pop();
            StackTraceElement[] stackTraceElementArray = throwable2.getStackTrace();
            ArrayList<StackTraceElement> arrayList = new ArrayList<StackTraceElement>();
            arrayList.add(new StackTraceElement(throwable2.getClass().getName(), "<filtered>", "<filtered>", 1));
            boolean bl = false;
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                if (this.zzcg(stackTraceElement.getClassName())) {
                    bl = true;
                    arrayList.add(stackTraceElement);
                    continue;
                }
                if (this.zzch(stackTraceElement.getClassName())) {
                    arrayList.add(stackTraceElement);
                    continue;
                }
                StackTraceElement stackTraceElement2 = new StackTraceElement("<filtered>", "<filtered>", "<filtered>", 1);
                arrayList.add(stackTraceElement2);
            }
            if (!bl) continue;
            throwable3 = throwable3 == null ? new Throwable(throwable2.getMessage()) : new Throwable(throwable2.getMessage(), throwable3);
            throwable3.setStackTrace(arrayList.toArray(new StackTraceElement[0]));
        }
        return throwable3;
    }
}

