/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.support.customtabs.CustomTabsIntent;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.overlay.AdLauncherIntentInfoParcel;
import com.google.android.gms.ads.internal.overlay.AdOverlayInfoParcel;
import com.google.android.gms.ads.internal.overlay.zzg;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.google.android.gms.ads.mediation.MediationInterstitialAdapter;
import com.google.android.gms.ads.mediation.MediationInterstitialListener;
import com.google.android.gms.internal.zzdw;
import com.google.android.gms.internal.zziy;
import com.google.android.gms.internal.zzkr;

@zziy
public class zzhf
implements MediationInterstitialAdapter {
    private Activity zzbul;
    private zzdw zzbum;
    private MediationInterstitialListener zzbun;
    private Uri mUri;

    public static boolean zzp(Context context) {
        return zzdw.zzo(context);
    }

    public void requestInterstitialAd(Context context, MediationInterstitialListener mediationInterstitialListener, Bundle bundle, MediationAdRequest mediationAdRequest, Bundle bundle2) {
        this.zzbun = mediationInterstitialListener;
        if (this.zzbun == null) {
            zzb.zzdf((String)"Listener not set for mediation. Returning.");
            return;
        }
        if (!(context instanceof Activity)) {
            zzb.zzdf((String)"AdMobCustomTabs can only work with Activity context. Bailing out.");
            this.zzbun.onAdFailedToLoad((MediationInterstitialAdapter)this, 0);
            return;
        }
        if (!zzhf.zzp(context)) {
            zzb.zzdf((String)"Default browser does not support custom tabs. Bailing out.");
            this.zzbun.onAdFailedToLoad((MediationInterstitialAdapter)this, 0);
            return;
        }
        String string2 = bundle.getString("tab_url");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            zzb.zzdf((String)"The tab_url retrieved from mediation metadata is empty. Bailing out.");
            this.zzbun.onAdFailedToLoad((MediationInterstitialAdapter)this, 0);
            return;
        }
        this.zzbul = (Activity)context;
        this.mUri = Uri.parse((String)string2);
        this.zzbum = new zzdw();
        zzdw.zza zza2 = new zzdw.zza(){

            @Override
            public void zzlh() {
                zzb.zzdd((String)"Hinting CustomTabsService for the load of the new url.");
            }

            @Override
            public void zzli() {
                zzb.zzdd((String)"Disconnecting from CustomTabs service.");
            }
        };
        this.zzbum.zza(zza2);
        this.zzbum.zze(this.zzbul);
        this.zzbun.onAdLoaded((MediationInterstitialAdapter)this);
    }

    public void showInterstitial() {
        CustomTabsIntent customTabsIntent = new CustomTabsIntent.Builder(this.zzbum.zzlf()).build();
        customTabsIntent.intent.setData(this.mUri);
        AdLauncherIntentInfoParcel adLauncherIntentInfoParcel = new AdLauncherIntentInfoParcel(customTabsIntent.intent);
        final AdOverlayInfoParcel adOverlayInfoParcel = new AdOverlayInfoParcel(adLauncherIntentInfoParcel, null, new zzg(){

            @Override
            public void zzed() {
                zzb.zzdd((String)"AdMobCustomTabsAdapter overlay is closed.");
                zzhf.this.zzbun.onAdClosed((MediationInterstitialAdapter)zzhf.this);
                zzhf.this.zzbum.zzd(zzhf.this.zzbul);
            }

            @Override
            public void onPause() {
                zzb.zzdd((String)"AdMobCustomTabsAdapter overlay is paused.");
            }

            @Override
            public void onResume() {
                zzb.zzdd((String)"AdMobCustomTabsAdapter overlay is resumed.");
            }

            @Override
            public void zzee() {
                zzb.zzdd((String)"Opening AdMobCustomTabsAdapter overlay.");
                zzhf.this.zzbun.onAdOpened((MediationInterstitialAdapter)zzhf.this);
            }
        }, null, new VersionInfoParcel(0, 0, false));
        zzkr.zzcrf.post(new Runnable(){

            @Override
            public void run() {
                zzu.zzfx().zza((Context)zzhf.this.zzbul, adOverlayInfoParcel);
            }
        });
        zzu.zzgd().zzag(false);
    }

    public void onDestroy() {
        zzb.zzdd((String)"Destroying AdMobCustomTabsAdapter adapter.");
        try {
            this.zzbum.zzd(this.zzbul);
        }
        catch (Exception exception) {
            zzb.zzb((String)"Exception while unbinding from CustomTabsService.", (Throwable)exception);
        }
    }

    public void onPause() {
        zzb.zzdd((String)"Pausing AdMobCustomTabsAdapter adapter.");
    }

    public void onResume() {
        zzb.zzdd((String)"Resuming AdMobCustomTabsAdapter adapter.");
    }
}

