/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.SystemClock;
import android.text.TextUtils;
import com.google.ads.mediation.AdUrlAdapter;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.formats.NativeAdOptionsParcel;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzdi;
import com.google.android.gms.internal.zzgg;
import com.google.android.gms.internal.zzgh;
import com.google.android.gms.internal.zzgj;
import com.google.android.gms.internal.zzgl;
import com.google.android.gms.internal.zzgq;
import com.google.android.gms.internal.zzgr;
import com.google.android.gms.internal.zzgs;
import com.google.android.gms.internal.zzgt;
import com.google.android.gms.internal.zzgx;
import com.google.android.gms.internal.zzhf;
import com.google.android.gms.internal.zziy;
import com.google.android.gms.internal.zzkn;
import com.google.android.gms.internal.zzkr;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

@zziy
public class zzgk
implements zzgl.zza {
    private final String zzbst;
    private final zzgq zzals;
    private final long zzbsu;
    private final zzgh zzbsv;
    private final zzgg zzbsw;
    private AdRequestParcel zzaow;
    private final AdSizeParcel zzapc;
    private final Context mContext;
    private final Object zzakd = new Object();
    private final VersionInfoParcel zzanh;
    private final boolean zzatk;
    private final NativeAdOptionsParcel zzand;
    private final List<String> zzane;
    private final boolean zzazd;
    private zzgr zzbsx;
    private int zzbsy = -2;
    private zzgt zzbsz;

    public zzgk(Context context, String string2, zzgq zzgq2, zzgh zzgh2, zzgg zzgg2, AdRequestParcel adRequestParcel, AdSizeParcel adSizeParcel, VersionInfoParcel versionInfoParcel, boolean bl, boolean bl2, NativeAdOptionsParcel nativeAdOptionsParcel, List<String> list) {
        this.mContext = context;
        this.zzals = zzgq2;
        this.zzbsw = zzgg2;
        this.zzbst = "com.google.ads.mediation.customevent.CustomEventAdapter".equals(string2) ? this.zznf() : string2;
        this.zzbsv = zzgh2;
        this.zzbsu = zzgh2.zzbsc != -1L ? zzgh2.zzbsc : 10000L;
        this.zzaow = adRequestParcel;
        this.zzapc = adSizeParcel;
        this.zzanh = versionInfoParcel;
        this.zzatk = bl;
        this.zzazd = bl2;
        this.zzand = nativeAdOptionsParcel;
        this.zzane = list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.zzakd;
        synchronized (object) {
            try {
                if (this.zzbsx != null) {
                    this.zzbsx.destroy();
                }
            }
            catch (RemoteException remoteException) {
                zzkn.zzd((String)"Could not destroy mediation adapter.", (Throwable)remoteException);
            }
            this.zzbsy = -1;
            this.zzakd.notify();
        }
    }

    private String zznf() {
        try {
            if (!TextUtils.isEmpty((CharSequence)this.zzbsw.zzbrp)) {
                return this.zzals.zzbr(this.zzbsw.zzbrp) ? "com.google.android.gms.ads.mediation.customevent.CustomEventAdapter" : "com.google.ads.mediation.customevent.CustomEventAdapter";
            }
        }
        catch (RemoteException remoteException) {
            zzkn.zzdf((String)"Fail to determine the custom event's version, assuming the old one.");
        }
        return "com.google.ads.mediation.customevent.CustomEventAdapter";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzaa(int n) {
        Object object = this.zzakd;
        synchronized (object) {
            this.zzbsy = n;
            this.zzakd.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(int n, zzgt zzgt2) {
        Object object = this.zzakd;
        synchronized (object) {
            this.zzbsy = n;
            this.zzbsz = zzgt2;
            this.zzakd.notify();
        }
    }

    protected zzgr zza(MediationAdapter mediationAdapter) {
        return new zzgx(mediationAdapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public zzgl zza(long l, long l2) {
        Object object = this.zzakd;
        synchronized (object) {
            long l3 = SystemClock.elapsedRealtime();
            final zzgj zzgj2 = new zzgj();
            zzkr.zzcrf.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = zzgk.this.zzakd;
                    synchronized (object) {
                        if (zzgk.this.zzbsy != -2) {
                            return;
                        }
                        zzgk.this.zzbsx = zzgk.this.zznh();
                        if (zzgk.this.zzbsx == null) {
                            zzgk.this.zzaa(4);
                            return;
                        }
                        if (zzgk.this.zzni() && !zzgk.this.zzab(1)) {
                            String string2 = zzgk.this.zzbst;
                            zzkn.zzdf((String)new StringBuilder(56 + String.valueOf(string2).length()).append("Ignoring adapter ").append(string2).append(" as delayed impression is not supported").toString());
                            zzgk.this.zzaa(2);
                            return;
                        }
                        zzgj2.zza(zzgk.this);
                        zzgk.this.zza(zzgj2);
                    }
                }
            });
            long l4 = this.zza(l3, this.zzbsu, l, l2);
            return new zzgl(this.zzbsw, this.zzbsx, this.zzbst, zzgj2, this.zzbsy, this.zzng(), l4);
        }
    }

    private zzgt zzng() {
        if (this.zzbsy != 0 || !this.zzni()) {
            return null;
        }
        try {
            if (this.zzab(4) && this.zzbsz != null && this.zzbsz.zznk() != 0) {
                return this.zzbsz;
            }
        }
        catch (RemoteException remoteException) {
            zzkn.zzdf((String)"Could not get cpm value from MediationResponseMetadata");
        }
        return zzgk.zzac(this.zznj());
    }

    private zzgr zznh() {
        String string2 = String.valueOf(this.zzbst);
        zzkn.zzde((String)(string2.length() != 0 ? "Instantiating mediation adapter: ".concat(string2) : new String("Instantiating mediation adapter: ")));
        if (!this.zzatk) {
            if (zzdi.zzbei.get().booleanValue() && "com.google.ads.mediation.admob.AdMobAdapter".equals(this.zzbst)) {
                return this.zza((MediationAdapter)new AdMobAdapter());
            }
            if (zzdi.zzbej.get().booleanValue() && "com.google.ads.mediation.AdUrlAdapter".equals(this.zzbst)) {
                return this.zza((MediationAdapter)new AdUrlAdapter());
            }
            if ("com.google.ads.mediation.admob.AdMobCustomTabsAdapter".equals(this.zzbst)) {
                return new zzgx((MediationAdapter)new zzhf());
            }
        }
        try {
            return this.zzals.zzbq(this.zzbst);
        }
        catch (RemoteException remoteException) {
            String string3 = String.valueOf(this.zzbst);
            zzkn.zza((String)(string3.length() != 0 ? "Could not instantiate mediation adapter: ".concat(string3) : new String("Could not instantiate mediation adapter: ")), (Throwable)remoteException);
            return null;
        }
    }

    private void zza(zzgj zzgj2) {
        String string2 = this.zzbn(this.zzbsw.zzbrt);
        try {
            if (this.zzanh.zzctt < 4100000) {
                if (this.zzapc.zzaxj) {
                    this.zzbsx.zza(zze.zzac((Object)this.mContext), this.zzaow, string2, (zzgs)zzgj2);
                } else {
                    this.zzbsx.zza(zze.zzac((Object)this.mContext), this.zzapc, this.zzaow, string2, (zzgs)zzgj2);
                }
            } else if (this.zzatk) {
                this.zzbsx.zza(zze.zzac((Object)this.mContext), this.zzaow, string2, this.zzbsw.zzbrl, (zzgs)zzgj2, this.zzand, this.zzane);
            } else if (this.zzapc.zzaxj) {
                this.zzbsx.zza(zze.zzac((Object)this.mContext), this.zzaow, string2, this.zzbsw.zzbrl, (zzgs)zzgj2);
            } else if (this.zzazd) {
                if (this.zzbsw.zzbrw != null) {
                    this.zzbsx.zza(zze.zzac((Object)this.mContext), this.zzaow, string2, this.zzbsw.zzbrl, (zzgs)zzgj2, new NativeAdOptionsParcel(zzgk.zzbo(this.zzbsw.zzbsa)), this.zzbsw.zzbrz);
                } else {
                    this.zzbsx.zza(zze.zzac((Object)this.mContext), this.zzapc, this.zzaow, string2, this.zzbsw.zzbrl, (zzgs)zzgj2);
                }
            } else {
                this.zzbsx.zza(zze.zzac((Object)this.mContext), this.zzapc, this.zzaow, string2, this.zzbsw.zzbrl, (zzgs)zzgj2);
            }
        }
        catch (RemoteException remoteException) {
            zzkn.zzd((String)"Could not request ad from mediation adapter.", (Throwable)remoteException);
            this.zzaa(5);
        }
    }

    private long zza(long l, long l2, long l3, long l4) {
        while (this.zzbsy == -2) {
            this.zzb(l, l2, l3, l4);
        }
        return zzu.zzgf().elapsedRealtime() - l;
    }

    private void zzb(long l, long l2, long l3, long l4) {
        long l5 = SystemClock.elapsedRealtime();
        long l6 = l2 - (l5 - l);
        long l7 = l4 - (l5 - l3);
        if (l6 <= 0L || l7 <= 0L) {
            zzkn.zzde((String)"Timed out waiting for adapter.");
            this.zzbsy = 3;
            return;
        }
        try {
            this.zzakd.wait(Math.min(l6, l7));
        }
        catch (InterruptedException interruptedException) {
            this.zzbsy = -1;
        }
    }

    private boolean zzab(int n) {
        Bundle bundle = null;
        try {
            bundle = this.zzatk ? this.zzbsx.zznp() : (this.zzapc.zzaxj ? this.zzbsx.getInterstitialAdapterInfo() : this.zzbsx.zzno());
        }
        catch (RemoteException remoteException) {
            zzkn.zzdf((String)"Could not get adapter info. Returning false");
            return false;
        }
        if (bundle != null) {
            int n2 = bundle.getInt("capabilities", 0);
            return (n & n2) == n;
        }
        return false;
    }

    private boolean zzni() {
        return this.zzbsv.zzbsm != -1;
    }

    private String zzbn(String string2) {
        if (string2 == null || !this.zzni() || this.zzab(2)) {
            return string2;
        }
        try {
            JSONObject jSONObject = new JSONObject(string2);
            jSONObject.remove("cpm_floor_cents");
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            zzkn.zzdf((String)"Could not remove field. Returning the original value");
            return string2;
        }
    }

    private int zznj() {
        JSONObject jSONObject;
        if (this.zzbsw.zzbrt == null) {
            return 0;
        }
        try {
            jSONObject = new JSONObject(this.zzbsw.zzbrt);
        }
        catch (JSONException jSONException) {
            zzkn.zzdf((String)"Could not convert to json. Returning 0");
            return 0;
        }
        if ("com.google.ads.mediation.admob.AdMobAdapter".equals(this.zzbst)) {
            return jSONObject.optInt("cpm_cents", 0);
        }
        int n = 0;
        if (this.zzab(2)) {
            n = jSONObject.optInt("cpm_floor_cents", 0);
        }
        if (n == 0) {
            n = jSONObject.optInt("penalized_average_cpm_cents", 0);
        }
        return n;
    }

    private static zzgt zzac(final int n) {
        return new zzgt.zza(){

            public int zznk() throws RemoteException {
                return n;
            }
        };
    }

    private static NativeAdOptions zzbo(String string2) {
        NativeAdOptions.Builder builder = new NativeAdOptions.Builder();
        if (string2 == null) {
            return builder.build();
        }
        try {
            JSONObject jSONObject = new JSONObject(string2);
            builder.setRequestMultipleImages(jSONObject.optBoolean("multiple_images", false));
            builder.setReturnUrlsForImageAssets(jSONObject.optBoolean("only_urls", false));
            String string3 = jSONObject.optString("native_image_orientation", "any");
            builder.setImageOrientation(zzgk.zzbp(string3));
        }
        catch (JSONException jSONException) {
            zzkn.zzd((String)"Exception occurred when creating native ad options", (Throwable)jSONException);
        }
        return builder.build();
    }

    private static int zzbp(String string2) {
        if ("landscape".equals(string2)) {
            return 2;
        }
        if ("portrait".equals(string2)) {
            return 1;
        }
        return 0;
    }
}

