/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Parcel;
import android.support.annotation.Nullable;
import android.util.Base64;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzdi;
import com.google.android.gms.internal.zzfn;
import com.google.android.gms.internal.zzfr;
import com.google.android.gms.internal.zzfs;
import com.google.android.gms.internal.zzfu;
import com.google.android.gms.internal.zziy;
import com.google.android.gms.internal.zzjh;
import com.google.android.gms.internal.zzkn;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Pattern;

@zziy
public class zzfq {
    private final Map<zzfr, zzfs> zzbpe = new HashMap<zzfr, zzfs>();
    private final LinkedList<zzfr> zzbpf = new LinkedList();
    @Nullable
    private zzfn zzbpg;

    void zza(zzfn zzfn2) {
        if (this.zzbpg == null) {
            this.zzbpg = zzfn2.zzml();
            this.restore();
        }
    }

    @Nullable
    zzfs.zza zza(AdRequestParcel adRequestParcel, String string2) {
        Object object;
        if (this.zzbi(string2)) {
            return null;
        }
        Context context = this.zzbpg.getApplicationContext();
        zzjh zzjh2 = new zzjh.zza(context).zzsk();
        int n = zzjh2.zzcmd;
        AdRequestParcel adRequestParcel2 = zzfq.zzn(adRequestParcel);
        zzfr zzfr2 = new zzfr(adRequestParcel2, string2, n);
        zzfs zzfs2 = this.zzbpe.get(zzfr2);
        if (zzfs2 == null) {
            zzfq.zza("Interstitial pool created at %s.", zzfr2);
            zzfs2 = new zzfs(adRequestParcel2, string2, n);
            this.zzbpe.put(zzfr2, zzfs2);
        }
        this.zzbpf.remove(zzfr2);
        this.zzbpf.add(zzfr2);
        zzfs2.zzmr();
        while (this.zzbpf.size() > zzdi.zzbdm.get()) {
            object = this.zzbpf.remove();
            zzfs zzfs3 = this.zzbpe.get(object);
            zzfq.zza("Evicting interstitial queue for %s.", (zzfr)object);
            while (zzfs3.size() > 0) {
                zzfs.zza zza2 = zzfs3.zzp(null);
                zza2.zzbpl.zzfa();
            }
            this.zzbpe.remove(object);
        }
        while (zzfs2.size() > 0) {
            long l;
            object = zzfs2.zzp(adRequestParcel2);
            if (((zzfs.zza)object).zzbpp && (l = zzu.zzgf().currentTimeMillis() - ((zzfs.zza)object).zzbpo) > 1000L * (long)zzdi.zzbdo.get().intValue()) {
                zzfq.zza("Expired interstitial at %s.", zzfr2);
                continue;
            }
            String string3 = ((zzfs.zza)object).zzbpm != null ? " (inline) " : " ";
            zzfq.zza(new StringBuilder(34 + String.valueOf(string3).length()).append("Pooled interstitial").append(string3).append("returned at %s.").toString(), zzfr2);
            return object;
        }
        return null;
    }

    void zzb(AdRequestParcel adRequestParcel, String string2) {
        if (this.zzbpg == null) {
            return;
        }
        Context context = this.zzbpg.getApplicationContext();
        zzjh zzjh2 = new zzjh.zza(context).zzsk();
        int n = zzjh2.zzcmd;
        AdRequestParcel adRequestParcel2 = zzfq.zzn(adRequestParcel);
        zzfr zzfr2 = new zzfr(adRequestParcel2, string2, n);
        zzfs zzfs2 = this.zzbpe.get(zzfr2);
        if (zzfs2 == null) {
            zzfq.zza("Interstitial pool created at %s.", zzfr2);
            zzfs2 = new zzfs(adRequestParcel2, string2, n);
            this.zzbpe.put(zzfr2, zzfs2);
        }
        zzfs2.zza(this.zzbpg, adRequestParcel);
        zzfs2.zzmr();
        zzfq.zza("Inline entry added to the queue at %s.", zzfr2);
    }

    void zzmm() {
        if (this.zzbpg == null) {
            return;
        }
        for (Map.Entry<zzfr, zzfs> entry : this.zzbpe.entrySet()) {
            zzfr zzfr2 = entry.getKey();
            zzfs zzfs2 = entry.getValue();
            if (zzkn.zzbf((int)2)) {
                int n = zzfs2.size();
                int n2 = zzfs2.zzmp();
                if (n2 < n) {
                    zzkn.v(String.format("Loading %s/%s pooled interstitials for %s.", n - n2, n, zzfr2));
                }
            }
            zzfs2.zzmq();
            while (zzfs2.size() < zzdi.zzbdn.get()) {
                zzfq.zza("Pooling and loading one new interstitial for %s.", zzfr2);
                zzfs2.zzb(this.zzbpg);
            }
        }
        this.save();
    }

    void save() {
        if (this.zzbpg == null) {
            return;
        }
        Context context = this.zzbpg.getApplicationContext();
        SharedPreferences sharedPreferences = context.getSharedPreferences("com.google.android.gms.ads.internal.interstitial.InterstitialAdPool", 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.clear();
        for (Map.Entry<zzfr, zzfs> entry : this.zzbpe.entrySet()) {
            zzfr zzfr2 = entry.getKey();
            zzfs zzfs2 = entry.getValue();
            if (!zzfs2.zzms()) continue;
            zzfu zzfu2 = new zzfu(zzfs2);
            String string2 = zzfu2.zzmv();
            String string3 = zzfr2.toString();
            editor.putString(string3, string2);
            zzfq.zza("Saved interstitial queue for %s.", zzfr2);
        }
        editor.putString("PoolKeys", this.zzmn());
        editor.apply();
    }

    void restore() {
        if (this.zzbpg == null) {
            return;
        }
        Context context = this.zzbpg.getApplicationContext();
        SharedPreferences sharedPreferences = context.getSharedPreferences("com.google.android.gms.ads.internal.interstitial.InterstitialAdPool", 0);
        this.flush();
        try {
            zzfr zzfr2;
            HashMap<String, zzfr> hashMap = new HashMap<String, zzfr>();
            String[] stringArray = sharedPreferences.getAll().entrySet().iterator();
            while (stringArray.hasNext()) {
                String[] stringArray2 = stringArray.next();
                String string2 = (String)stringArray2.getKey();
                if (string2.equals("PoolKeys")) continue;
                String string3 = (String)stringArray2.getValue();
                zzfu object = zzfu.zzbj(string3);
                zzfr2 = new zzfr(object.zzaow, object.zzang, object.zzbpj);
                if (this.zzbpe.containsKey(zzfr2)) continue;
                zzfs zzfs2 = new zzfs(object.zzaow, object.zzang, object.zzbpj);
                this.zzbpe.put(zzfr2, zzfs2);
                hashMap.put(zzfr2.toString(), zzfr2);
                zzfq.zza("Restored interstitial queue for %s.", zzfr2);
            }
            for (String string2 : stringArray = this.zzbh(sharedPreferences.getString("PoolKeys", ""))) {
                zzfr2 = (zzfr)hashMap.get(string2);
                if (!this.zzbpe.containsKey(zzfr2)) continue;
                this.zzbpf.add(zzfr2);
            }
        }
        catch (Throwable throwable) {
            zzu.zzgd().zza(throwable, "InterstitialAdPool.restore");
            zzkn.zzd((String)"Malformed preferences value for InterstitialAdPool.", (Throwable)throwable);
            this.zzbpe.clear();
            this.zzbpf.clear();
        }
    }

    void flush() {
        while (this.zzbpf.size() > 0) {
            zzfr zzfr2 = this.zzbpf.remove();
            zzfs zzfs2 = this.zzbpe.get(zzfr2);
            zzfq.zza("Flushing interstitial queue for %s.", zzfr2);
            while (zzfs2.size() > 0) {
                zzfs.zza zza2 = zzfs2.zzp(null);
                zza2.zzbpl.zzfa();
            }
            this.zzbpe.remove(zzfr2);
        }
    }

    private String zzmn() {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            Iterator iterator = this.zzbpf.iterator();
            while (iterator.hasNext()) {
                String string2 = ((zzfr)iterator.next()).toString();
                stringBuilder.append(Base64.encodeToString((byte[])string2.getBytes("UTF-8"), (int)0));
                if (!iterator.hasNext()) continue;
                stringBuilder.append("\u0000");
            }
            return stringBuilder.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    private String[] zzbh(String string2) {
        try {
            String[] stringArray = string2.split("\u0000");
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = new String(Base64.decode((String)stringArray[i], (int)0), "UTF-8");
            }
            return stringArray;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String[0];
        }
    }

    private boolean zzbi(String string2) {
        try {
            return Pattern.matches(zzdi.zzbdp.get(), string2);
        }
        catch (RuntimeException runtimeException) {
            zzu.zzgd().zza(runtimeException, "InterstitialAdPool.isExcludedAdUnit");
            return false;
        }
    }

    @Nullable
    static Bundle zzk(AdRequestParcel adRequestParcel) {
        Bundle bundle = adRequestParcel.zzawn;
        if (bundle == null) {
            return null;
        }
        return bundle.getBundle("com.google.ads.mediation.admob.AdMobAdapter");
    }

    static AdRequestParcel zzl(AdRequestParcel adRequestParcel) {
        AdRequestParcel adRequestParcel2 = zzfq.zzo(adRequestParcel);
        Bundle bundle = zzfq.zzk(adRequestParcel2);
        if (bundle == null) {
            bundle = new Bundle();
            adRequestParcel2.zzawn.putBundle("com.google.ads.mediation.admob.AdMobAdapter", bundle);
        }
        bundle.putBoolean("_skipMediation", true);
        return adRequestParcel2;
    }

    static boolean zzm(AdRequestParcel adRequestParcel) {
        Bundle bundle = adRequestParcel.zzawn;
        if (bundle == null) {
            return false;
        }
        Bundle bundle2 = bundle.getBundle("com.google.ads.mediation.admob.AdMobAdapter");
        return bundle2 != null && bundle2.containsKey("_skipMediation");
    }

    private static AdRequestParcel zzn(AdRequestParcel adRequestParcel) {
        String[] stringArray;
        AdRequestParcel adRequestParcel2 = zzfq.zzo(adRequestParcel);
        String string2 = zzdi.zzbdl.get();
        for (String string3 : stringArray = string2.split(",")) {
            zzfq.zzc(adRequestParcel2.zzawn, string3);
        }
        return adRequestParcel2;
    }

    static AdRequestParcel zzo(AdRequestParcel adRequestParcel) {
        Parcel parcel = Parcel.obtain();
        adRequestParcel.writeToParcel(parcel, 0);
        parcel.setDataPosition(0);
        AdRequestParcel adRequestParcel2 = (AdRequestParcel)AdRequestParcel.CREATOR.createFromParcel(parcel);
        parcel.recycle();
        AdRequestParcel.zzj((AdRequestParcel)adRequestParcel2);
        return adRequestParcel2;
    }

    private static void zzc(Bundle bundle, String string2) {
        String[] stringArray = string2.split("/", 2);
        if (stringArray.length == 0) {
            return;
        }
        String string3 = stringArray[0];
        if (stringArray.length == 1) {
            bundle.remove(string3);
            return;
        }
        Bundle bundle2 = bundle.getBundle(string3);
        if (bundle2 == null) {
            return;
        }
        zzfq.zzc(bundle2, stringArray[1]);
    }

    private static void zza(String string2, zzfr zzfr2) {
        if (zzkn.zzbf((int)2)) {
            zzkn.v(String.format(string2, zzfr2));
        }
    }
}

