/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.graphics.Color;
import android.os.SystemClock;
import android.text.TextUtils;
import android.view.MotionEvent;
import com.google.android.gms.ads.internal.client.zzm;
import com.google.android.gms.ads.internal.overlay.zzd;
import com.google.android.gms.ads.internal.overlay.zzk;
import com.google.android.gms.internal.zzdi;
import com.google.android.gms.internal.zzev;
import com.google.android.gms.internal.zziy;
import com.google.android.gms.internal.zzkn;
import com.google.android.gms.internal.zzls;
import com.google.android.gms.internal.zzlt;
import java.util.Map;
import org.json.JSONObject;

@zziy
public final class zzff
implements zzev {
    private boolean zzbnr;

    private static int zza(Context context, Map<String, String> map, String string2, int n) {
        String string3 = map.get(string2);
        int n2 = n;
        if (string3 != null) {
            try {
                n2 = zzm.zzjr().zzb(context, Integer.parseInt(string3));
            }
            catch (NumberFormatException numberFormatException) {
                zzkn.zzdf((String)new StringBuilder(34 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Could not parse ").append(string2).append(" in a video GMSG: ").append(string3).toString());
            }
        }
        return n2;
    }

    @Override
    public void zza(zzlt zzlt2, Map<String, String> map) {
        Object object;
        String string2 = map.get("action");
        if (string2 == null) {
            zzkn.zzdf((String)"Action missing from video GMSG.");
            return;
        }
        if (zzkn.zzbf((int)3)) {
            object = new JSONObject(map);
            object.remove("google.afma.Notify_dt");
            String string3 = String.valueOf(object.toString());
            zzkn.zzdd((String)new StringBuilder(13 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Video GMSG: ").append(string2).append(" ").append(string3).toString());
        }
        if ("background".equals(string2)) {
            object = map.get("color");
            if (TextUtils.isEmpty((CharSequence)object)) {
                zzkn.zzdf((String)"Color parameter missing from color video GMSG.");
                return;
            }
            try {
                int n = Color.parseColor((String)object);
                zzlt2.setBackgroundColor(n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                zzkn.zzdf((String)"Invalid color parameter in video GMSG.");
            }
            return;
        }
        object = zzlt2.zzvy();
        if (object == null) {
            zzkn.zzdf((String)"Could not get underlay container for a video GMSG.");
            return;
        }
        boolean bl = "new".equals(string2);
        boolean bl2 = "position".equals(string2);
        if (bl || bl2) {
            int n;
            Context context = zzlt2.getContext();
            int n2 = zzff.zza(context, map, "x", 0);
            int n3 = zzff.zza(context, map, "y", 0);
            int n4 = zzff.zza(context, map, "w", -1);
            int n5 = zzff.zza(context, map, "h", -1);
            if (zzdi.zzbge.get().booleanValue()) {
                n4 = Math.min(n4, zzlt2.getMeasuredWidth() - n2);
                n5 = Math.min(n5, zzlt2.getMeasuredHeight() - n3);
            }
            try {
                n = Integer.parseInt(map.get("player"));
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            boolean bl3 = Boolean.parseBoolean(map.get("spherical"));
            if (bl && ((zzls)object).zzvk() == null) {
                ((zzls)object).zza(n2, n3, n4, n5, n, bl3);
            } else {
                ((zzls)object).zze(n2, n3, n4, n5);
            }
        } else {
            zzk zzk2 = ((zzls)object).zzvk();
            if (zzk2 == null) {
                zzk.zzi(zzlt2);
                return;
            }
            if ("click".equals(string2)) {
                Context context = zzlt2.getContext();
                int n = zzff.zza(context, map, "x", 0);
                int n6 = zzff.zza(context, map, "y", 0);
                long l = SystemClock.uptimeMillis();
                MotionEvent motionEvent = MotionEvent.obtain((long)l, (long)l, (int)0, (float)n, (float)n6, (int)0);
                zzk2.zzf(motionEvent);
                motionEvent.recycle();
            } else if ("currentTime".equals(string2)) {
                String string4 = map.get("time");
                if (string4 == null) {
                    zzkn.zzdf((String)"Time parameter missing from currentTime video GMSG.");
                    return;
                }
                try {
                    float f = Float.parseFloat(string4);
                    int n = (int)(f * 1000.0f);
                    zzk2.seekTo(n);
                }
                catch (NumberFormatException numberFormatException) {
                    String string5 = String.valueOf(string4);
                    zzkn.zzdf((String)(string5.length() != 0 ? "Could not parse time parameter from currentTime video GMSG: ".concat(string5) : new String("Could not parse time parameter from currentTime video GMSG: ")));
                }
            } else if ("hide".equals(string2)) {
                zzk2.setVisibility(4);
            } else if ("load".equals(string2)) {
                zzk2.zzmt();
            } else if ("muted".equals(string2)) {
                boolean bl4 = Boolean.parseBoolean(map.get("muted"));
                if (bl4) {
                    zzk2.zzom();
                } else {
                    zzk2.zzon();
                }
            } else if ("pause".equals(string2)) {
                zzk2.pause();
            } else if ("play".equals(string2)) {
                zzk2.play();
            } else if ("show".equals(string2)) {
                zzk2.setVisibility(0);
            } else if ("src".equals(string2)) {
                zzk2.zzca(map.get("src"));
            } else if ("touchMove".equals(string2)) {
                Context context = zzlt2.getContext();
                int n = zzff.zza(context, map, "dx", 0);
                int n7 = zzff.zza(context, map, "dy", 0);
                zzk2.zza(n, n7);
                if (!this.zzbnr) {
                    zzd zzd2 = zzlt2.zzvp();
                    zzd2.zzpa();
                    this.zzbnr = true;
                }
            } else if ("volume".equals(string2)) {
                String string6 = map.get("volume");
                if (string6 == null) {
                    zzkn.zzdf((String)"Level parameter missing from volume video GMSG.");
                    return;
                }
                try {
                    float f = Float.parseFloat(string6);
                    zzk2.zza(f);
                }
                catch (NumberFormatException numberFormatException) {
                    String string7 = String.valueOf(string6);
                    zzkn.zzdf((String)(string7.length() != 0 ? "Could not parse volume parameter from volume video GMSG: ".concat(string7) : new String("Could not parse volume parameter from volume video GMSG: ")));
                }
            } else if ("watermark".equals(string2)) {
                zzk2.zzpn();
            } else {
                String string8 = String.valueOf(string2);
                zzkn.zzdf((String)(string8.length() != 0 ? "Unknown video action: ".concat(string8) : new String("Unknown video action: ")));
            }
        }
    }
}

