/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Base64;
import android.view.View;
import com.google.android.gms.ads.internal.formats.zzd;
import com.google.android.gms.ads.internal.formats.zze;
import com.google.android.gms.ads.internal.zzf;
import com.google.android.gms.internal.zzdx;
import com.google.android.gms.internal.zzev;
import com.google.android.gms.internal.zzgl;
import com.google.android.gms.internal.zzgu;
import com.google.android.gms.internal.zzgv;
import com.google.android.gms.internal.zziy;
import com.google.android.gms.internal.zzke;
import com.google.android.gms.internal.zzkn;
import com.google.android.gms.internal.zzlt;
import com.google.android.gms.internal.zzlu;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zziy
public class zzn {
    @Nullable
    public static View zzg(@Nullable zzke zzke2) {
        if (zzke2 == null) {
            zzkn.e((String)"AdState is null");
            return null;
        }
        if (zzn.zzh(zzke2) && zzke2.zzbyh != null) {
            return zzke2.zzbyh.getView();
        }
        try {
            com.google.android.gms.dynamic.zzd zzd2;
            com.google.android.gms.dynamic.zzd zzd3 = zzd2 = zzke2.zzbtf != null ? zzke2.zzbtf.getView() : null;
            if (zzd2 == null) {
                zzkn.zzdf((String)"View in mediation adapter is null.");
                return null;
            }
            return (View)com.google.android.gms.dynamic.zze.zzae((com.google.android.gms.dynamic.zzd)zzd2);
        }
        catch (RemoteException remoteException) {
            zzkn.zzd((String)"Could not get View from mediation adapter.", (Throwable)remoteException);
            return null;
        }
    }

    public static void zza(@Nullable zzke zzke2, zzf.zza zza2) {
        if (zzke2 != null && zzn.zzh(zzke2)) {
            View view;
            zzlt zzlt2 = zzke2.zzbyh;
            View view2 = view = zzlt2 != null ? zzlt2.getView() : null;
            if (view == null) {
                zzkn.zzdf((String)"AdWebView is null");
                return;
            }
            try {
                zzgv zzgv2;
                List<String> list;
                List<String> list2 = list = zzke2.zzbte != null ? zzke2.zzbte.zzbrz : null;
                if (list == null || list.isEmpty()) {
                    zzkn.zzdf((String)"No template ids present in mediation response");
                    return;
                }
                zzgu zzgu2 = zzke2.zzbtf != null ? zzke2.zzbtf.zznm() : null;
                zzgv zzgv3 = zzgv2 = zzke2.zzbtf != null ? zzke2.zzbtf.zznn() : null;
                if (list.contains("2") && zzgu2 != null) {
                    zzgu2.zzl(com.google.android.gms.dynamic.zze.zzac((Object)view));
                    if (!zzgu2.getOverrideImpressionRecording()) {
                        zzgu2.recordImpression();
                    }
                    zzlt2.zzvr().zza("/nativeExpressViewClicked", zzn.zza(zzgu2, null, zza2));
                } else if (list.contains("1") && zzgv2 != null) {
                    zzgv2.zzl(com.google.android.gms.dynamic.zze.zzac((Object)view));
                    if (!zzgv2.getOverrideImpressionRecording()) {
                        zzgv2.recordImpression();
                    }
                    zzlt2.zzvr().zza("/nativeExpressViewClicked", zzn.zza(null, zzgv2, zza2));
                } else {
                    zzkn.zzdf((String)"No matching template id and mapper");
                }
            }
            catch (RemoteException remoteException) {
                zzkn.zzd((String)"Error occurred while recording impression and registering for clicks", (Throwable)remoteException);
                return;
            }
        }
    }

    public static boolean zza(zzlt zzlt2, zzgl zzgl2, CountDownLatch countDownLatch) {
        boolean bl = false;
        try {
            bl = zzn.zzb(zzlt2, zzgl2, countDownLatch);
        }
        catch (RemoteException remoteException) {
            zzkn.zzd((String)"Unable to invoke load assets", (Throwable)remoteException);
        }
        catch (RuntimeException runtimeException) {
            countDownLatch.countDown();
            throw runtimeException;
        }
        if (!bl) {
            countDownLatch.countDown();
        }
        return bl;
    }

    private static boolean zzb(zzlt zzlt2, zzgl zzgl2, CountDownLatch countDownLatch) throws RemoteException {
        Object object;
        View view = zzlt2.getView();
        if (view == null) {
            zzkn.zzdf((String)"AdWebView is null");
            return false;
        }
        view.setVisibility(4);
        List<String> list = zzgl2.zzbte.zzbrz;
        if (list == null || list.isEmpty()) {
            zzkn.zzdf((String)"No template ids present in mediation response");
            return false;
        }
        zzn.zza(zzlt2, countDownLatch);
        zzgu zzgu2 = zzgl2.zzbtf.zznm();
        zzgv zzgv2 = zzgl2.zzbtf.zznn();
        if (list.contains("2") && zzgu2 != null) {
            object = zzn.zza(zzgu2);
            zzn.zza(zzlt2, object, zzgl2.zzbte.zzbry);
        } else if (list.contains("1") && zzgv2 != null) {
            object = zzn.zza(zzgv2);
            zzn.zza(zzlt2, (zze)object, zzgl2.zzbte.zzbry);
        } else {
            zzkn.zzdf((String)"No matching template id and mapper");
            return false;
        }
        object = zzgl2.zzbte.zzbrw;
        String string2 = zzgl2.zzbte.zzbrx;
        if (string2 != null) {
            zzlt2.loadDataWithBaseURL(string2, (String)object, "text/html", "UTF-8", null);
        } else {
            zzlt2.loadData((String)object, "text/html", "UTF-8");
        }
        return true;
    }

    public static boolean zzh(@Nullable zzke zzke2) {
        return zzke2 != null && zzke2.zzchc && zzke2.zzbte != null && zzke2.zzbte.zzbrw != null;
    }

    private static zzd zza(zzgu zzgu2) throws RemoteException {
        return new zzd(zzgu2.getHeadline(), zzgu2.getImages(), zzgu2.getBody(), zzgu2.zzlo(), zzgu2.getCallToAction(), zzgu2.getStarRating(), zzgu2.getStore(), zzgu2.getPrice(), null, zzgu2.getExtras(), null, null);
    }

    private static zze zza(zzgv zzgv2) throws RemoteException {
        return new zze(zzgv2.getHeadline(), zzgv2.getImages(), zzgv2.getBody(), zzgv2.zzlt(), zzgv2.getCallToAction(), zzgv2.getAdvertiser(), null, zzgv2.getExtras());
    }

    private static void zza(final zzlt zzlt2, final zzd zzd2, final String string2) {
        zzlt2.zzvr().zza(new zzlu.zza(){

            @Override
            public void zza(zzlt zzlt22, boolean bl) {
                try {
                    JSONObject jSONObject = new JSONObject();
                    jSONObject.put("headline", (Object)zzd2.getHeadline());
                    jSONObject.put("body", (Object)zzd2.getBody());
                    jSONObject.put("call_to_action", (Object)zzd2.getCallToAction());
                    jSONObject.put("price", (Object)zzd2.getPrice());
                    jSONObject.put("star_rating", (Object)String.valueOf(zzd2.getStarRating()));
                    jSONObject.put("store", (Object)zzd2.getStore());
                    jSONObject.put("icon", (Object)zzn.zza(zzd2.zzlo()));
                    JSONArray jSONArray = new JSONArray();
                    List list = zzd2.getImages();
                    if (list != null) {
                        for (Object e : list) {
                            zzdx zzdx2 = zzn.zze(e);
                            jSONArray.put((Object)zzn.zza(zzdx2));
                        }
                    }
                    jSONObject.put("images", (Object)jSONArray);
                    jSONObject.put("extras", (Object)zzn.zza(zzd2.getExtras(), string2));
                    JSONObject jSONObject2 = new JSONObject();
                    jSONObject2.put("assets", (Object)jSONObject);
                    jSONObject2.put("template_id", (Object)"2");
                    zzlt2.zza("google.afma.nativeExpressAds.loadAssets", jSONObject2);
                }
                catch (JSONException jSONException) {
                    zzkn.zzd((String)"Exception occurred when loading assets", (Throwable)jSONException);
                }
            }
        });
    }

    private static void zza(final zzlt zzlt2, final zze zze2, final String string2) {
        zzlt2.zzvr().zza(new zzlu.zza(){

            @Override
            public void zza(zzlt zzlt22, boolean bl) {
                try {
                    JSONObject jSONObject = new JSONObject();
                    jSONObject.put("headline", (Object)zze2.getHeadline());
                    jSONObject.put("body", (Object)zze2.getBody());
                    jSONObject.put("call_to_action", (Object)zze2.getCallToAction());
                    jSONObject.put("advertiser", (Object)zze2.getAdvertiser());
                    jSONObject.put("logo", (Object)zzn.zza(zze2.zzlt()));
                    JSONArray jSONArray = new JSONArray();
                    List list = zze2.getImages();
                    if (list != null) {
                        for (Object e : list) {
                            zzdx zzdx2 = zzn.zze(e);
                            jSONArray.put((Object)zzn.zza(zzdx2));
                        }
                    }
                    jSONObject.put("images", (Object)jSONArray);
                    jSONObject.put("extras", (Object)zzn.zza(zze2.getExtras(), string2));
                    JSONObject jSONObject2 = new JSONObject();
                    jSONObject2.put("assets", (Object)jSONObject);
                    jSONObject2.put("template_id", (Object)"1");
                    zzlt2.zza("google.afma.nativeExpressAds.loadAssets", jSONObject2);
                }
                catch (JSONException jSONException) {
                    zzkn.zzd((String)"Exception occurred when loading assets", (Throwable)jSONException);
                }
            }
        });
    }

    private static void zza(zzlt zzlt2, CountDownLatch countDownLatch) {
        zzlt2.zzvr().zza("/nativeExpressAssetsLoaded", zzn.zza(countDownLatch));
        zzlt2.zzvr().zza("/nativeExpressAssetsLoadingFailed", zzn.zzb(countDownLatch));
    }

    static zzev zza(final CountDownLatch countDownLatch) {
        return new zzev(){

            @Override
            public void zza(zzlt zzlt2, Map<String, String> map) {
                countDownLatch.countDown();
                zzlt2.getView().setVisibility(0);
            }
        };
    }

    static zzev zzb(final CountDownLatch countDownLatch) {
        return new zzev(){

            @Override
            public void zza(zzlt zzlt2, Map<String, String> map) {
                zzkn.zzdf((String)"Adapter returned an ad, but assets substitution failed");
                countDownLatch.countDown();
                zzlt2.destroy();
            }
        };
    }

    static zzev zza(final @Nullable zzgu zzgu2, final @Nullable zzgv zzgv2, final zzf.zza zza2) {
        return new zzev(){

            @Override
            public void zza(zzlt zzlt2, Map<String, String> map) {
                View view = zzlt2.getView();
                if (view == null) {
                    return;
                }
                try {
                    if (zzgu2 != null) {
                        if (!zzgu2.getOverrideClickHandling()) {
                            zzgu2.zzk(com.google.android.gms.dynamic.zze.zzac((Object)view));
                            zza2.onClick();
                        } else {
                            zzn.zza(zzlt2);
                        }
                    } else if (zzgv2 != null) {
                        if (!zzgv2.getOverrideClickHandling()) {
                            zzgv2.zzk(com.google.android.gms.dynamic.zze.zzac((Object)view));
                            zza2.onClick();
                        } else {
                            zzn.zza(zzlt2);
                        }
                    }
                }
                catch (RemoteException remoteException) {
                    zzkn.zzd((String)"Unable to call handleClick on mapper", (Throwable)remoteException);
                }
            }
        };
    }

    private static void zza(zzlt zzlt2) {
        View.OnClickListener onClickListener = zzlt2.zzwf();
        if (onClickListener != null) {
            onClickListener.onClick(zzlt2.getView());
        }
    }

    private static JSONObject zza(@Nullable Bundle bundle, String string2) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (bundle == null || TextUtils.isEmpty((CharSequence)string2)) {
            return jSONObject;
        }
        JSONObject jSONObject2 = new JSONObject(string2);
        Iterator iterator = jSONObject2.keys();
        while (iterator.hasNext()) {
            Object object;
            String string3 = (String)iterator.next();
            if (!bundle.containsKey(string3)) continue;
            String string4 = jSONObject2.getString(string3);
            if ("image".equals(string4)) {
                object = bundle.get(string3);
                if (object instanceof Bitmap) {
                    String string5 = zzn.zza((Bitmap)object);
                    jSONObject.put(string3, (Object)string5);
                    continue;
                }
                zzkn.zzdf((String)"Invalid type. An image type extra should return a bitmap");
                continue;
            }
            object = bundle.get(string3);
            if (object instanceof Bitmap) {
                zzkn.zzdf((String)"Invalid asset type. Bitmap should be returned only for image type");
                continue;
            }
            jSONObject.put(string3, (Object)String.valueOf(bundle.get(string3)));
        }
        return jSONObject;
    }

    static String zza(@Nullable zzdx zzdx2) {
        if (zzdx2 == null) {
            zzkn.zzdf((String)"Image is null. Returning empty string");
            return "";
        }
        Uri uri = null;
        try {
            uri = zzdx2.getUri();
            if (uri != null) {
                return uri.toString();
            }
        }
        catch (RemoteException remoteException) {
            zzkn.zzdf((String)"Unable to get image uri. Trying data uri next");
        }
        return zzn.zzb(zzdx2);
    }

    private static String zzb(zzdx zzdx2) {
        com.google.android.gms.dynamic.zzd zzd2;
        Drawable drawable2 = null;
        try {
            zzd2 = zzdx2.zzln();
            if (zzd2 == null) {
                zzkn.zzdf((String)"Drawable is null. Returning empty string");
                return "";
            }
            drawable2 = (Drawable)com.google.android.gms.dynamic.zze.zzae((com.google.android.gms.dynamic.zzd)zzd2);
        }
        catch (RemoteException remoteException) {
            zzkn.zzdf((String)"Unable to get drawable. Returning empty string");
            return "";
        }
        if (!(drawable2 instanceof BitmapDrawable)) {
            zzkn.zzdf((String)"Drawable is not an instance of BitmapDrawable. Returning empty string");
            return "";
        }
        zzd2 = (BitmapDrawable)drawable2;
        Bitmap bitmap = zzd2.getBitmap();
        return zzn.zza(bitmap);
    }

    private static String zza(@Nullable Bitmap bitmap) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (bitmap == null) {
            zzkn.zzdf((String)"Bitmap is null. Returning empty string");
            return "";
        }
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        String string2 = Base64.encodeToString((byte[])byArray, (int)0);
        String string3 = String.valueOf("data:image/png;base64,");
        String string4 = String.valueOf(string2);
        return string4.length() != 0 ? string3.concat(string4) : new String(string3);
    }

    @Nullable
    private static zzdx zze(Object object) {
        if (object instanceof IBinder) {
            return zzdx.zza.zzab((IBinder)((IBinder)object));
        }
        return null;
    }
}

