/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.request;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.ads.internal.request.AdRequestInfoParcel;
import com.google.android.gms.ads.internal.request.AdResponseParcel;
import com.google.android.gms.ads.internal.request.zza;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.internal.zzdi;
import com.google.android.gms.internal.zzev;
import com.google.android.gms.internal.zzew;
import com.google.android.gms.internal.zzfa;
import com.google.android.gms.internal.zzfv;
import com.google.android.gms.internal.zzfy;
import com.google.android.gms.internal.zzfz;
import com.google.android.gms.internal.zziy;
import com.google.android.gms.internal.zziz;
import com.google.android.gms.internal.zzjc;
import com.google.android.gms.internal.zzke;
import com.google.android.gms.internal.zzkm;
import com.google.android.gms.internal.zzkn;
import com.google.android.gms.internal.zzkw;
import com.google.android.gms.internal.zzlm;
import com.google.android.gms.internal.zzlt;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.json.JSONException;
import org.json.JSONObject;

@zziy
public class zzn
extends zzkm {
    static final long zzcik = TimeUnit.SECONDS.toMillis(10L);
    private static final Object zzaok = new Object();
    static boolean zzcil = false;
    private static zzfy zzcdq = null;
    private static zzew zzcim = null;
    private static zzfa zzcin = null;
    private static zzev zzcio = null;
    private final zza.zza zzcfh;
    private final AdRequestInfoParcel.zza zzcfi;
    private final Object zzccn = new Object();
    private final Context mContext;
    private zzfy.zzc zzcip;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public zzn(Context context, AdRequestInfoParcel.zza zza2, zza.zza zza3) {
        super(true);
        this.zzcfh = zza3;
        this.mContext = context;
        this.zzcfi = zza2;
        Object object = zzaok;
        synchronized (object) {
            if (!zzcil) {
                zzcin = new zzfa();
                zzcim = new zzew(context.getApplicationContext(), zza2.zzaqv);
                zzcio = new zzc();
                zzcdq = new zzfy(this.mContext.getApplicationContext(), this.zzcfi.zzaqv, zzdi.zzbao.get(), new zzb(), new zza());
                zzcil = true;
            }
        }
    }

    protected static void zzb(zzfv zzfv2) {
        zzfv2.zza("/loadAd", zzcin);
        zzfv2.zza("/fetchHttpRequest", zzcim);
        zzfv2.zza("/invalidRequest", zzcio);
    }

    protected static void zzc(zzfv zzfv2) {
        zzfv2.zzb("/loadAd", zzcin);
        zzfv2.zzb("/fetchHttpRequest", zzcim);
        zzfv2.zzb("/invalidRequest", zzcio);
    }

    @Override
    public void zzfc() {
        zzkn.zzdd((String)"SdkLessAdLoaderBackgroundTask started.");
        AdRequestInfoParcel adRequestInfoParcel = new AdRequestInfoParcel(this.zzcfi, null, -1L);
        AdResponseParcel adResponseParcel = this.zze(adRequestInfoParcel);
        long l = zzu.zzgf().elapsedRealtime();
        final zzke.zza zza2 = new zzke.zza(adRequestInfoParcel, adResponseParcel, null, null, adResponseParcel.errorCode, l, adResponseParcel.zzchg, null);
        com.google.android.gms.ads.internal.util.client.zza.zzctj.post(new Runnable(){

            @Override
            public void run() {
                zzn.this.zzcfh.zza(zza2);
                if (zzn.this.zzcip != null) {
                    zzn.this.zzcip.release();
                    zzn.this.zzcip = null;
                }
            }
        });
    }

    private AdResponseParcel zze(AdRequestInfoParcel adRequestInfoParcel) {
        JSONObject jSONObject;
        final String string2 = zzu.zzfz().zzuh();
        final JSONObject jSONObject2 = this.zza(adRequestInfoParcel, string2);
        if (jSONObject2 == null) {
            return new AdResponseParcel(0);
        }
        long l = zzu.zzgf().elapsedRealtime();
        Future<JSONObject> future = zzcin.zzaz(string2);
        com.google.android.gms.ads.internal.util.client.zza.zzctj.post(new Runnable(){

            @Override
            public void run() {
                zzn.this.zzcip = zzcdq.zzmy();
                zzn.this.zzcip.zza(new zzlm.zzc<zzfz>(){

                    public void zzb(zzfz zzfz2) {
                        try {
                            zzfz2.zza("AFMA_getAdapterLessMediationAd", jSONObject2);
                        }
                        catch (Exception exception) {
                            zzkn.zzb((String)"Error requesting an ad url", (Throwable)exception);
                            zzcin.zzba(string2);
                        }
                    }

                    @Override
                    public /* synthetic */ void zzd(Object object) {
                        this.zzb((zzfz)object);
                    }
                }, new zzlm.zza(){

                    @Override
                    public void run() {
                        zzcin.zzba(string2);
                    }
                });
            }
        });
        long l2 = zzcik - (zzu.zzgf().elapsedRealtime() - l);
        try {
            jSONObject = future.get(l2, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | CancellationException exception) {
            return new AdResponseParcel(-1);
        }
        catch (TimeoutException timeoutException) {
            return new AdResponseParcel(2);
        }
        catch (ExecutionException executionException) {
            return new AdResponseParcel(0);
        }
        if (jSONObject == null) {
            return new AdResponseParcel(-1);
        }
        AdResponseParcel adResponseParcel = zzjc.zza(this.mContext, adRequestInfoParcel, jSONObject.toString());
        if (adResponseParcel.errorCode != -3 && TextUtils.isEmpty((CharSequence)adResponseParcel.body)) {
            return new AdResponseParcel(3);
        }
        return adResponseParcel;
    }

    private JSONObject zza(AdRequestInfoParcel adRequestInfoParcel, String string2) {
        Bundle bundle = adRequestInfoParcel.zzcfu.extras.getBundle("sdk_less_server_data");
        if (bundle == null) {
            return null;
        }
        JSONObject jSONObject = zzjc.zza(this.mContext, new zziz().zzf(adRequestInfoParcel).zza(zzu.zzgi().zzy(this.mContext)));
        if (jSONObject == null) {
            return null;
        }
        AdvertisingIdClient.Info info = null;
        try {
            info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.mContext);
        }
        catch (GooglePlayServicesNotAvailableException | GooglePlayServicesRepairableException | IOException | IllegalStateException throwable) {
            zzkn.zzd((String)"Cannot get advertising id info", (Throwable)throwable);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("request_id", string2);
        hashMap.put("request_param", jSONObject);
        hashMap.put("data", bundle);
        if (info != null) {
            hashMap.put("adid", info.getId());
            hashMap.put("lat", info.isLimitAdTrackingEnabled() ? 1 : 0);
        }
        try {
            return zzu.zzfz().zzan(hashMap);
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStop() {
        Object object = this.zzccn;
        synchronized (object) {
            com.google.android.gms.ads.internal.util.client.zza.zzctj.post(new Runnable(){

                @Override
                public void run() {
                    if (zzn.this.zzcip != null) {
                        zzn.this.zzcip.release();
                        zzn.this.zzcip = null;
                    }
                }
            });
        }
    }

    public static class zza
    implements zzkw<zzfv> {
        public void zza(zzfv zzfv2) {
            zzn.zzc(zzfv2);
        }

        @Override
        public /* synthetic */ void zzd(Object object) {
            this.zza((zzfv)object);
        }
    }

    public static class zzb
    implements zzkw<zzfv> {
        public void zza(zzfv zzfv2) {
            zzn.zzb(zzfv2);
        }

        @Override
        public /* synthetic */ void zzd(Object object) {
            this.zza((zzfv)object);
        }
    }

    public static class zzc
    implements zzev {
        @Override
        public void zza(zzlt zzlt2, Map<String, String> map) {
            String string2 = map.get("request_id");
            String string3 = map.get("errors");
            String string4 = String.valueOf(string3);
            zzkn.zzdf((String)(string4.length() != 0 ? "Invalid request: ".concat(string4) : new String("Invalid request: ")));
            zzcin.zzba(string2);
        }
    }
}

