/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.formats;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.formats.zza;
import com.google.android.gms.ads.internal.formats.zzb;
import com.google.android.gms.ads.internal.formats.zzd;
import com.google.android.gms.ads.internal.formats.zzg;
import com.google.android.gms.ads.internal.formats.zzi;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzq;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzau;
import com.google.android.gms.internal.zzdi;
import com.google.android.gms.internal.zzdx;
import com.google.android.gms.internal.zzev;
import com.google.android.gms.internal.zzfz;
import com.google.android.gms.internal.zzir;
import com.google.android.gms.internal.zziy;
import com.google.android.gms.internal.zzkn;
import com.google.android.gms.internal.zzlt;
import com.google.android.gms.internal.zzlu;
import java.lang.ref.WeakReference;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@zziy
public class zzj
implements zzi {
    private final Object zzakd = new Object();
    private final zzq zzbkj;
    private final Context mContext;
    @Nullable
    private final JSONObject zzbkm;
    @Nullable
    private final zzir zzbkn;
    @Nullable
    private final zzi.zza zzbko;
    private final zzau zzbkp;
    @Nullable
    private final VersionInfoParcel zzanh;
    private boolean zzbkq;
    private zzlt zzbkr;
    private String zzbks;
    @Nullable
    private String zzbkt;
    private WeakReference<View> zzbku = null;

    public zzj(Context context, zzq zzq2, @Nullable zzir zzir2, zzau zzau2, @Nullable JSONObject jSONObject, @Nullable zzi.zza zza2, @Nullable VersionInfoParcel versionInfoParcel, @Nullable String string) {
        this.mContext = context;
        this.zzbkj = zzq2;
        this.zzbkn = zzir2;
        this.zzbkp = zzau2;
        this.zzbkm = jSONObject;
        this.zzbko = zza2;
        this.zzanh = versionInfoParcel;
        this.zzbkt = string;
    }

    public zzb zza(View.OnClickListener onClickListener) {
        zza zza2 = this.zzbko.zzlr();
        if (zza2 == null) {
            return null;
        }
        zzb zzb2 = new zzb(this.mContext, zza2);
        zzb2.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        zzb2.zzlm().setOnClickListener(onClickListener);
        zzb2.zzlm().setContentDescription((CharSequence)zzdi.zzbgd.get());
        return zzb2;
    }

    public void zza(View view, String string, @Nullable JSONObject jSONObject, @Nullable JSONObject jSONObject2, @Nullable JSONObject jSONObject3) {
        zzac.zzhq((String)"performClick must be called on the main UI thread.");
        try {
            JSONObject jSONObject4 = new JSONObject();
            jSONObject4.put("asset", (Object)string);
            jSONObject4.put("template", (Object)this.zzbko.zzlq());
            final JSONObject jSONObject5 = new JSONObject();
            jSONObject5.put("ad", (Object)this.zzbkm);
            jSONObject5.put("click", (Object)jSONObject4);
            jSONObject5.put("has_custom_click_handler", this.zzbkj.zzx(this.zzbko.getCustomTemplateId()) != null);
            if (jSONObject != null) {
                jSONObject5.put("view_rectangles", (Object)jSONObject);
            }
            if (jSONObject2 != null) {
                jSONObject5.put("click_point", (Object)jSONObject2);
            }
            if (jSONObject3 != null) {
                jSONObject5.put("native_view_rectangle", (Object)jSONObject3);
            }
            try {
                JSONObject jSONObject6 = this.zzbkm.optJSONObject("tracking_urls_and_actions");
                if (jSONObject6 == null) {
                    jSONObject6 = new JSONObject();
                }
                String string2 = jSONObject6.optString("click_string");
                jSONObject4.put("click_signals", (Object)this.zzbkp.zzaw().zza(this.mContext, string2, view));
            }
            catch (Exception exception) {
                zzkn.zzb((String)"Exception obtaining click signals", (Throwable)exception);
            }
            jSONObject5.put("ads_id", (Object)this.zzbkt);
            this.zzbkn.zza(new zzir.zza(){

                @Override
                public void zze(zzfz zzfz2) {
                    zzfz2.zza("google.afma.nativeAds.handleClickGmsg", jSONObject5);
                }
            });
        }
        catch (JSONException jSONException) {
            zzkn.zzb((String)"Unable to create click JSON.", (Throwable)jSONException);
        }
    }

    public void zza(View view, Map<String, WeakReference<View>> map, JSONObject jSONObject, JSONObject jSONObject2, JSONObject jSONObject3) {
        zzac.zzhq((String)"performClick must be called on the main UI thread.");
        for (Map.Entry<String, WeakReference<View>> entry : map.entrySet()) {
            View view2 = (View)entry.getValue().get();
            if (!view.equals(view2)) continue;
            this.zza(view, entry.getKey(), jSONObject, jSONObject2, jSONObject3);
            return;
        }
        if ("2".equals(this.zzbko.zzlq())) {
            this.zza(view, "2099", jSONObject, jSONObject2, jSONObject3);
        } else if ("1".equals(this.zzbko.zzlq())) {
            this.zza(view, "1099", jSONObject, jSONObject2, jSONObject3);
        }
    }

    public void zzd(MotionEvent motionEvent) {
        this.zzbkp.zza(motionEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzg(View view) {
        Object object = this.zzakd;
        synchronized (object) {
            if (this.zzbkq) {
                return;
            }
            if (!view.isShown()) {
                return;
            }
            if (!view.getGlobalVisibleRect(new Rect(), null)) {
                return;
            }
            this.recordImpression();
        }
    }

    public void recordImpression() {
        zzac.zzhq((String)"recordImpression must be called on the main UI thread.");
        this.zzr(true);
        try {
            final JSONObject jSONObject = new JSONObject();
            jSONObject.put("ad", (Object)this.zzbkm);
            jSONObject.put("ads_id", (Object)this.zzbkt);
            this.zzbkn.zza(new zzir.zza(){

                @Override
                public void zze(zzfz zzfz2) {
                    zzfz2.zza("google.afma.nativeAds.handleImpressionPing", jSONObject);
                }
            });
        }
        catch (JSONException jSONException) {
            zzkn.zzb((String)"Unable to create impression JSON.", (Throwable)jSONException);
        }
        this.zzbkj.zza(this);
    }

    public View zzly() {
        return this.zzbku != null ? (View)this.zzbku.get() : null;
    }

    public void zzh(View view) {
        this.zzbku = new WeakReference<View>(view);
    }

    public void zza(View view, Map<String, WeakReference<View>> map, View.OnTouchListener onTouchListener, View.OnClickListener onClickListener) {
        if (!zzdi.zzbga.get().booleanValue()) {
            return;
        }
        view.setOnTouchListener(onTouchListener);
        view.setClickable(true);
        view.setOnClickListener(onClickListener);
        for (Map.Entry<String, WeakReference<View>> entry : map.entrySet()) {
            View view2 = (View)entry.getValue().get();
            if (view2 == null) continue;
            view2.setOnTouchListener(onTouchListener);
            view2.setClickable(true);
            view2.setOnClickListener(onClickListener);
        }
    }

    public void zzb(View view, Map<String, WeakReference<View>> map) {
        view.setOnTouchListener(null);
        view.setClickable(false);
        view.setOnClickListener(null);
        for (Map.Entry<String, WeakReference<View>> entry : map.entrySet()) {
            View view2 = (View)entry.getValue().get();
            if (view2 == null) continue;
            view2.setOnTouchListener(null);
            view2.setClickable(false);
            view2.setOnClickListener(null);
        }
    }

    public zzlt zzlx() {
        this.zzbkr = this.zzma();
        this.zzbkr.getView().setVisibility(8);
        zzir.zza zza2 = new zzir.zza(){

            @Override
            public void zze(final zzfz zzfz2) {
                zzfz2.zza("/loadHtml", new zzev(){

                    @Override
                    public void zza(zzlt zzlt2, final Map<String, String> map) {
                        zzj.this.zzbkr.zzvr().zza(new zzlu.zza(){

                            @Override
                            public void zza(zzlt zzlt2, boolean bl) {
                                zzj.this.zzbks = (String)map.get("id");
                                JSONObject jSONObject = new JSONObject();
                                try {
                                    jSONObject.put("messageType", (Object)"htmlLoaded");
                                    jSONObject.put("id", (Object)zzj.this.zzbks);
                                    zzfz2.zzb("sendMessageToNativeJs", jSONObject);
                                }
                                catch (JSONException jSONException) {
                                    zzkn.zzb((String)"Unable to dispatch sendMessageToNativeJs event", (Throwable)jSONException);
                                }
                            }
                        });
                        String string = map.get("overlayHtml");
                        String string2 = map.get("baseUrl");
                        if (TextUtils.isEmpty((CharSequence)string2)) {
                            zzj.this.zzbkr.loadData(string, "text/html", "UTF-8");
                        } else {
                            zzj.this.zzbkr.loadDataWithBaseURL(string2, string, "text/html", "UTF-8", null);
                        }
                    }
                });
                zzfz2.zza("/showOverlay", new zzev(){

                    @Override
                    public void zza(zzlt zzlt2, Map<String, String> map) {
                        zzj.this.zzbkr.getView().setVisibility(0);
                    }
                });
                zzfz2.zza("/hideOverlay", new zzev(){

                    @Override
                    public void zza(zzlt zzlt2, Map<String, String> map) {
                        zzj.this.zzbkr.getView().setVisibility(8);
                    }
                });
                zzj.this.zzbkr.zzvr().zza("/hideOverlay", new zzev(){

                    @Override
                    public void zza(zzlt zzlt2, Map<String, String> map) {
                        zzj.this.zzbkr.getView().setVisibility(8);
                    }
                });
                zzj.this.zzbkr.zzvr().zza("/sendMessageToSdk", new zzev(){

                    @Override
                    public void zza(zzlt zzlt2, Map<String, String> map) {
                        JSONObject jSONObject = new JSONObject();
                        try {
                            for (String string : map.keySet()) {
                                jSONObject.put(string, (Object)map.get(string));
                            }
                            jSONObject.put("id", (Object)zzj.this.zzbks);
                            zzfz2.zzb("sendMessageToNativeJs", jSONObject);
                        }
                        catch (JSONException jSONException) {
                            zzkn.zzb((String)"Unable to dispatch sendMessageToNativeJs event", (Throwable)jSONException);
                        }
                    }
                });
            }
        };
        this.zzbkn.zza(zza2);
        return this.zzbkr;
    }

    public void zza(View view, zzg zzg2) {
        zzdx zzdx2;
        if (!(this.zzbko instanceof zzd)) {
            return;
        }
        zzd zzd2 = (zzd)this.zzbko;
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        if (zzd2.zzls() != null) {
            ((FrameLayout)view).addView(zzd2.zzls(), (ViewGroup.LayoutParams)layoutParams);
            this.zzbkj.zza(zzg2);
            return;
        }
        if (zzd2.getImages() != null && zzd2.getImages().size() > 0 && (zzdx2 = this.zze(zzd2.getImages().get(0))) != null) {
            try {
                com.google.android.gms.dynamic.zzd zzd3 = zzdx2.zzln();
                if (zzd3 != null) {
                    Drawable drawable = (Drawable)zze.zzae((com.google.android.gms.dynamic.zzd)zzd3);
                    ImageView imageView = this.zzmb();
                    imageView.setImageDrawable(drawable);
                    imageView.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
                    ((FrameLayout)view).addView((View)imageView, (ViewGroup.LayoutParams)layoutParams);
                }
            }
            catch (RemoteException remoteException) {
                zzkn.zzdf((String)"Could not get drawable from image");
            }
        }
    }

    public void zzlz() {
        if (!(this.zzbko instanceof zzd)) {
            return;
        }
        this.zzbkj.zzfj();
    }

    protected void zzr(boolean bl) {
        this.zzbkq = bl;
    }

    zzlt zzma() {
        return zzu.zzga().zza(this.mContext, AdSizeParcel.zzk((Context)this.mContext), false, false, this.zzbkp, this.zzanh);
    }

    public Context getContext() {
        return this.mContext;
    }

    @Nullable
    zzdx zze(Object object) {
        if (object instanceof IBinder) {
            return zzdx.zza.zzab((IBinder)((IBinder)object));
        }
        return null;
    }

    ImageView zzmb() {
        return new ImageView(this.mContext);
    }
}

