/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.android.gms.internal.zzaip;
import com.google.android.gms.internal.zzaiu;
import com.google.android.gms.internal.zzaiz;
import com.google.android.gms.internal.zzajb;
import com.google.android.gms.internal.zzajp;
import com.google.android.gms.internal.zzajs;
import com.google.android.gms.internal.zzakt;
import com.google.android.gms.internal.zzaku;
import com.google.android.gms.internal.zzalh;
import com.google.android.gms.internal.zzali;
import com.google.android.gms.internal.zzalm;
import com.google.android.gms.internal.zzaln;
import com.google.android.gms.internal.zzalq;
import com.google.android.gms.internal.zzalu;
import com.google.android.gms.internal.zzalw;
import com.google.android.gms.internal.zzalx;
import com.google.android.gms.internal.zzaly;
import com.google.android.gms.internal.zzama;
import com.google.android.gms.internal.zzamb;
import com.google.android.gms.internal.zzamw;
import com.google.android.gms.internal.zzamx;
import com.google.firebase.database.ChildEventListener;
import com.google.firebase.database.DataSnapshot;
import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.ValueEventListener;

public class Query {
    protected final zzajb aVX;
    protected final zzaiz aWf;
    protected final zzakt aWj;
    private final boolean aWk;

    Query(zzajb zzajb2, zzaiz zzaiz2, zzakt zzakt2, boolean bl) throws DatabaseException {
        this.aVX = zzajb2;
        this.aWf = zzaiz2;
        this.aWj = zzakt2;
        this.aWk = bl;
        zzamw.zzb(zzakt2.isValid(), "Validation of queries failed.");
    }

    Query(zzajb zzajb2, zzaiz zzaiz2) {
        this.aVX = zzajb2;
        this.aWf = zzaiz2;
        this.aWj = zzakt.beu;
        this.aWk = false;
    }

    private void zza(zzakt zzakt2) {
        if (zzakt2.zzcxy().equals(zzalq.zzczv())) {
            zzali zzali2;
            zzalu zzalu2;
            String string = "You must use startAt(String value), endAt(String value) or equalTo(String value) in combination with orderByKey(). Other type of values or using the version with 2 parameters is not supported";
            if (zzakt2.zzcxq()) {
                zzalu2 = zzakt2.zzcxr();
                zzali2 = zzakt2.zzcxs();
                if (zzali2 != zzali.zzcyv() || !(zzalu2 instanceof zzama)) {
                    throw new IllegalArgumentException(string);
                }
            }
            if (zzakt2.zzcxt()) {
                zzalu2 = zzakt2.zzcxu();
                zzali2 = zzakt2.zzcxv();
                if (zzali2 != zzali.zzcyw() || !(zzalu2 instanceof zzama)) {
                    throw new IllegalArgumentException(string);
                }
            }
        } else if (zzakt2.zzcxy().equals(zzalx.zzczz()) && (zzakt2.zzcxq() && !zzaly.zzq(zzakt2.zzcxr()) || zzakt2.zzcxt() && !zzaly.zzq(zzakt2.zzcxu()))) {
            throw new IllegalArgumentException("When using orderByPriority(), values provided to startAt(), endAt(), or equalTo() must be valid priorities.");
        }
    }

    private void zzb(zzakt zzakt2) {
        if (zzakt2.zzcxq() && zzakt2.zzcxt() && zzakt2.zzcxw() && !zzakt2.zzcxx()) {
            throw new IllegalArgumentException("Can't combine startAt(), endAt() and limit(). Use limitToFirst() or limitToLast() instead");
        }
    }

    private void zzcqy() {
        if (this.aWj.zzcxq()) {
            throw new IllegalArgumentException("Can't call equalTo() and startAt() combined");
        }
        if (this.aWj.zzcxt()) {
            throw new IllegalArgumentException("Can't call equalTo() and endAt() combined");
        }
    }

    private void zzcqz() {
        if (this.aWk) {
            throw new IllegalArgumentException("You can't combine multiple orderBy calls!");
        }
    }

    public ValueEventListener addValueEventListener(ValueEventListener valueEventListener) {
        this.zzb(new zzajp(this.aVX, valueEventListener, this.zzcrb()));
        return valueEventListener;
    }

    public ChildEventListener addChildEventListener(ChildEventListener childEventListener) {
        this.zzb(new zzaip(this.aVX, childEventListener, this.zzcrb()));
        return childEventListener;
    }

    public void addListenerForSingleValueEvent(final ValueEventListener valueEventListener) {
        this.zzb(new zzajp(this.aVX, new ValueEventListener(){

            @Override
            public void onDataChange(DataSnapshot dataSnapshot) {
                Query.this.removeEventListener(this);
                valueEventListener.onDataChange(dataSnapshot);
            }

            @Override
            public void onCancelled(DatabaseError databaseError) {
                valueEventListener.onCancelled(databaseError);
            }
        }, this.zzcrb()));
    }

    public void removeEventListener(ValueEventListener valueEventListener) {
        if (valueEventListener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.zza(new zzajp(this.aVX, valueEventListener, this.zzcrb()));
    }

    public void removeEventListener(ChildEventListener childEventListener) {
        if (childEventListener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.zza(new zzaip(this.aVX, childEventListener, this.zzcrb()));
    }

    private void zza(final zzaiu zzaiu2) {
        zzajs.zzcwj().zzk(zzaiu2);
        this.aVX.zzs(new Runnable(){

            @Override
            public void run() {
                Query.this.aVX.zze(zzaiu2);
            }
        });
    }

    private void zzb(final zzaiu zzaiu2) {
        zzajs.zzcwj().zzi(zzaiu2);
        this.aVX.zzs(new Runnable(){

            @Override
            public void run() {
                Query.this.aVX.zzf(zzaiu2);
            }
        });
    }

    public void keepSynced(final boolean bl) {
        if (!this.aWf.isEmpty() && this.aWf.zzcvh().equals(zzali.zzcyy())) {
            throw new DatabaseException("Can't call keepSynced() on .info paths.");
        }
        this.aVX.zzs(new Runnable(){

            @Override
            public void run() {
                Query.this.aVX.zza(Query.this.zzcrb(), bl);
            }
        });
    }

    public Query startAt(String string) {
        return this.startAt(string, null);
    }

    public Query startAt(double d) {
        return this.startAt(d, null);
    }

    public Query startAt(boolean bl) {
        return this.startAt(bl, null);
    }

    public Query startAt(String string, String string2) {
        zzalu zzalu2 = string != null ? new zzama(string, zzaly.a()) : zzaln.zzczo();
        return this.zza(zzalu2, string2);
    }

    public Query startAt(double d, String string) {
        return this.zza(new zzalm(d, zzaly.a()), string);
    }

    public Query startAt(boolean bl, String string) {
        return this.zza(new zzalh(bl, zzaly.a()), string);
    }

    private Query zza(zzalu zzalu2, String string) {
        zzamx.zztn(string);
        if (!zzalu2.zzczc() && !zzalu2.isEmpty()) {
            throw new IllegalArgumentException("Can only use simple values for startAt()");
        }
        if (this.aWj.zzcxq()) {
            throw new IllegalArgumentException("Can't call startAt() or equalTo() multiple times");
        }
        zzali zzali2 = string != null ? zzali.zzsy(string) : null;
        zzakt zzakt2 = this.aWj.zza(zzalu2, zzali2);
        this.zzb(zzakt2);
        this.zza(zzakt2);
        assert (zzakt2.isValid());
        return new Query(this.aVX, this.aWf, zzakt2, this.aWk);
    }

    public Query endAt(String string) {
        return this.endAt(string, null);
    }

    public Query endAt(double d) {
        return this.endAt(d, null);
    }

    public Query endAt(boolean bl) {
        return this.endAt(bl, null);
    }

    public Query endAt(String string, String string2) {
        zzalu zzalu2 = string != null ? new zzama(string, zzaly.a()) : zzaln.zzczo();
        return this.zzb(zzalu2, string2);
    }

    public Query endAt(double d, String string) {
        return this.zzb(new zzalm(d, zzaly.a()), string);
    }

    public Query endAt(boolean bl, String string) {
        return this.zzb(new zzalh(bl, zzaly.a()), string);
    }

    private Query zzb(zzalu zzalu2, String string) {
        zzali zzali2;
        zzamx.zztn(string);
        if (!zzalu2.zzczc() && !zzalu2.isEmpty()) {
            throw new IllegalArgumentException("Can only use simple values for endAt()");
        }
        zzali zzali3 = zzali2 = string != null ? zzali.zzsy(string) : null;
        if (this.aWj.zzcxt()) {
            throw new IllegalArgumentException("Can't call endAt() or equalTo() multiple times");
        }
        zzakt zzakt2 = this.aWj.zzb(zzalu2, zzali2);
        this.zzb(zzakt2);
        this.zza(zzakt2);
        assert (zzakt2.isValid());
        return new Query(this.aVX, this.aWf, zzakt2, this.aWk);
    }

    public Query equalTo(String string) {
        this.zzcqy();
        return this.startAt(string).endAt(string);
    }

    public Query equalTo(double d) {
        this.zzcqy();
        return this.startAt(d).endAt(d);
    }

    public Query equalTo(boolean bl) {
        this.zzcqy();
        return this.startAt(bl).endAt(bl);
    }

    public Query equalTo(String string, String string2) {
        this.zzcqy();
        return this.startAt(string, string2).endAt(string, string2);
    }

    public Query equalTo(double d, String string) {
        this.zzcqy();
        return this.startAt(d, string).endAt(d, string);
    }

    public Query equalTo(boolean bl, String string) {
        this.zzcqy();
        return this.startAt(bl, string).endAt(bl, string);
    }

    public Query limitToFirst(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Limit must be a positive integer!");
        }
        if (this.aWj.zzcxw()) {
            throw new IllegalArgumentException("Can't call limitToLast on query with previously set limit!");
        }
        return new Query(this.aVX, this.aWf, this.aWj.zzagh(n), this.aWk);
    }

    public Query limitToLast(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Limit must be a positive integer!");
        }
        if (this.aWj.zzcxw()) {
            throw new IllegalArgumentException("Can't call limitToLast on query with previously set limit!");
        }
        return new Query(this.aVX, this.aWf, this.aWj.zzagi(n), this.aWk);
    }

    public Query orderByChild(String string) {
        if (string == null) {
            throw new NullPointerException("Key can't be null");
        }
        if (string.equals("$key") || string.equals(".key")) {
            throw new IllegalArgumentException(new StringBuilder(54 + String.valueOf(string).length()).append("Can't use '").append(string).append("' as path, please use orderByKey() instead!").toString());
        }
        if (string.equals("$priority") || string.equals(".priority")) {
            throw new IllegalArgumentException(new StringBuilder(59 + String.valueOf(string).length()).append("Can't use '").append(string).append("' as path, please use orderByPriority() instead!").toString());
        }
        if (string.equals("$value") || string.equals(".value")) {
            throw new IllegalArgumentException(new StringBuilder(56 + String.valueOf(string).length()).append("Can't use '").append(string).append("' as path, please use orderByValue() instead!").toString());
        }
        zzamx.zztj(string);
        this.zzcqz();
        zzaiz zzaiz2 = new zzaiz(string);
        if (zzaiz2.size() == 0) {
            throw new IllegalArgumentException("Can't use empty path, use orderByValue() instead!");
        }
        zzalw zzalw2 = new zzalw(zzaiz2);
        return new Query(this.aVX, this.aWf, this.aWj.zza(zzalw2), true);
    }

    public Query orderByPriority() {
        this.zzcqz();
        zzakt zzakt2 = this.aWj.zza(zzalx.zzczz());
        this.zza(zzakt2);
        return new Query(this.aVX, this.aWf, zzakt2, true);
    }

    public Query orderByKey() {
        this.zzcqz();
        zzakt zzakt2 = this.aWj.zza(zzalq.zzczv());
        this.zza(zzakt2);
        return new Query(this.aVX, this.aWf, zzakt2, true);
    }

    public Query orderByValue() {
        this.zzcqz();
        return new Query(this.aVX, this.aWf, this.aWj.zza(zzamb.b()), true);
    }

    public DatabaseReference getRef() {
        return new DatabaseReference(this.aVX, this.zzcra());
    }

    public zzaiz zzcra() {
        return this.aWf;
    }

    public zzaku zzcrb() {
        return new zzaku(this.aWf, this.aWj);
    }
}

