/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzali;
import com.google.firebase.database.DatabaseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class zzaiz
implements Comparable<zzaiz>,
Iterable<zzali> {
    private final zzali[] bat;
    private final int start;
    private final int end;
    private static final zzaiz bau = new zzaiz("");

    public static zzaiz zza(zzaiz zzaiz2, zzaiz zzaiz3) {
        zzali zzali2 = zzaiz2.zzcvh();
        zzali zzali3 = zzaiz3.zzcvh();
        if (zzali2 == null) {
            return zzaiz3;
        }
        if (zzali2.equals(zzali3)) {
            return zzaiz.zza(zzaiz2.zzcvi(), zzaiz3.zzcvi());
        }
        String string = String.valueOf(zzaiz3);
        String string2 = String.valueOf(zzaiz2);
        throw new DatabaseException(new StringBuilder(37 + String.valueOf(string).length() + String.valueOf(string2).length()).append("INTERNAL ERROR: ").append(string).append(" is not contained in ").append(string2).toString());
    }

    public static zzaiz zzcve() {
        return bau;
    }

    public zzaiz(zzali ... zzaliArray) {
        this.bat = Arrays.copyOf(zzaliArray, zzaliArray.length);
        this.start = 0;
        this.end = zzaliArray.length;
        for (zzali zzali2 : zzaliArray) {
            assert (zzali2 != null) : "Can't construct a path with a null value!";
        }
    }

    public zzaiz(List<String> list) {
        this.bat = new zzali[list.size()];
        int n = 0;
        for (String string : list) {
            this.bat[n++] = zzali.zzsy(string);
        }
        this.start = 0;
        this.end = list.size();
    }

    public zzaiz(String string) {
        String[] stringArray = string.split("/");
        int n = 0;
        for (String string2 : stringArray) {
            if (string2.length() <= 0) continue;
            ++n;
        }
        this.bat = new zzali[n];
        int n2 = 0;
        for (String string3 : stringArray) {
            if (string3.length() <= 0) continue;
            this.bat[n2++] = zzali.zzsy(string3);
        }
        this.start = 0;
        this.end = this.bat.length;
    }

    private zzaiz(zzali[] zzaliArray, int n, int n2) {
        this.bat = zzaliArray;
        this.start = n;
        this.end = n2;
    }

    public zzaiz zzh(zzaiz zzaiz2) {
        int n = this.size() + zzaiz2.size();
        zzali[] zzaliArray = new zzali[n];
        System.arraycopy(this.bat, this.start, zzaliArray, 0, this.size());
        System.arraycopy(zzaiz2.bat, zzaiz2.start, zzaliArray, this.size(), zzaiz2.size());
        return new zzaiz(zzaliArray, 0, n);
    }

    public zzaiz zza(zzali zzali2) {
        int n = this.size();
        zzali[] zzaliArray = new zzali[n + 1];
        System.arraycopy(this.bat, this.start, zzaliArray, 0, n);
        zzaliArray[n] = zzali2;
        return new zzaiz(zzaliArray, 0, n + 1);
    }

    public String toString() {
        if (this.isEmpty()) {
            return "/";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = this.start; i < this.end; ++i) {
            stringBuilder.append("/");
            stringBuilder.append(this.bat[i].asString());
        }
        return stringBuilder.toString();
    }

    public String zzcvf() {
        if (this.isEmpty()) {
            return "/";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = this.start; i < this.end; ++i) {
            if (i > this.start) {
                stringBuilder.append("/");
            }
            stringBuilder.append(this.bat[i].asString());
        }
        return stringBuilder.toString();
    }

    public List<String> zzcvg() {
        ArrayList<String> arrayList = new ArrayList<String>(this.size());
        for (zzali zzali2 : this) {
            arrayList.add(zzali2.asString());
        }
        return arrayList;
    }

    public zzali zzcvh() {
        if (this.isEmpty()) {
            return null;
        }
        return this.bat[this.start];
    }

    public zzaiz zzcvi() {
        int n = this.start;
        if (!this.isEmpty()) {
            ++n;
        }
        return new zzaiz(this.bat, n, this.end);
    }

    public zzaiz zzcvj() {
        if (this.isEmpty()) {
            return null;
        }
        return new zzaiz(this.bat, this.start, this.end - 1);
    }

    public zzali zzcvk() {
        if (!this.isEmpty()) {
            return this.bat[this.end - 1];
        }
        return null;
    }

    public boolean isEmpty() {
        return this.start >= this.end;
    }

    public int size() {
        return this.end - this.start;
    }

    @Override
    public Iterator<zzali> iterator() {
        return new Iterator<zzali>(){
            int offset;
            {
                this.offset = zzaiz.this.start;
            }

            @Override
            public boolean hasNext() {
                return this.offset < zzaiz.this.end;
            }

            public zzali zzcvl() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No more elements.");
                }
                zzali zzali2 = zzaiz.this.bat[this.offset];
                ++this.offset;
                return zzali2;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Can't remove component from immutable Path!");
            }

            @Override
            public /* synthetic */ Object next() {
                return this.zzcvl();
            }
        };
    }

    public boolean zzi(zzaiz zzaiz2) {
        if (this.size() > zzaiz2.size()) {
            return false;
        }
        int n = this.start;
        int n2 = zzaiz2.start;
        while (n < this.end) {
            if (!this.bat[n].equals(zzaiz2.bat[n2])) {
                return false;
            }
            ++n;
            ++n2;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (!(object instanceof zzaiz)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        zzaiz zzaiz2 = (zzaiz)object;
        if (this.size() != zzaiz2.size()) {
            return false;
        }
        int n = this.start;
        for (int i = zzaiz2.start; n < this.end && i < zzaiz2.end; ++n, ++i) {
            if (this.bat[n].equals(zzaiz2.bat[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        for (int i = this.start; i < this.end; ++i) {
            n = n * 37 + this.bat[i].hashCode();
        }
        return n;
    }

    public int zzj(zzaiz zzaiz2) {
        int n;
        int n2 = this.start;
        for (n = zzaiz2.start; n2 < this.end && n < zzaiz2.end; ++n2, ++n) {
            int n3 = this.bat[n2].zzi(zzaiz2.bat[n]);
            if (n3 == 0) continue;
            return n3;
        }
        if (n2 == this.end && n == zzaiz2.end) {
            return 0;
        }
        if (n2 == this.end) {
            return -1;
        }
        return 1;
    }

    @Override
    public /* synthetic */ int compareTo(Object object) {
        return this.zzj((zzaiz)object);
    }
}

