/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzahq;
import com.google.android.gms.internal.zzahv;
import com.google.android.gms.internal.zzahy;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class zzahp<K, V>
extends zzahq<K, V> {
    private final K[] aWN;
    private final V[] aWO;
    private final Comparator<K> aWP;

    public static <A, B, C> zzahp<A, C> zza(List<A> list, Map<B, C> map, zzahq.zza.zza<A, B> zza2, Comparator<A> comparator) {
        Collections.sort(list, comparator);
        int n = list.size();
        Object[] objectArray = new Object[n];
        Object[] objectArray2 = new Object[n];
        int n2 = 0;
        for (A a : list) {
            objectArray[n2] = a;
            C c = map.get(zza2.zzbl(a));
            objectArray2[n2] = c;
            ++n2;
        }
        return new zzahp<Object, Object>(comparator, objectArray, objectArray2);
    }

    public static <K, V> zzahp<K, V> zza(Map<K, V> map, Comparator<K> comparator) {
        return zzahp.zza(new ArrayList<K>(map.keySet()), map, zzahq.zza.zzcrk(), comparator);
    }

    public zzahp(Comparator<K> comparator) {
        this.aWN = new Object[0];
        this.aWO = new Object[0];
        this.aWP = comparator;
    }

    private zzahp(Comparator<K> comparator, K[] KArray, V[] VArray) {
        this.aWN = KArray;
        this.aWO = VArray;
        this.aWP = comparator;
    }

    @Override
    public boolean containsKey(K k) {
        return this.zzbk(k) != -1;
    }

    @Override
    public V get(K k) {
        int n = this.zzbk(k);
        return n != -1 ? (V)this.aWO[n] : null;
    }

    @Override
    public zzahq<K, V> zzbh(K k) {
        int n = this.zzbk(k);
        if (n == -1) {
            return this;
        }
        K[] KArray = zzahp.zza(this.aWN, n);
        V[] VArray = zzahp.zza(this.aWO, n);
        return new zzahp<K, V>(this.aWP, KArray, VArray);
    }

    @Override
    public zzahq<K, V> zzj(K k, V v) {
        int n = this.zzbk(k);
        if (n != -1) {
            if (this.aWN[n] == k && this.aWO[n] == v) {
                return this;
            }
            K[] KArray = zzahp.zzb(this.aWN, n, k);
            V[] VArray = zzahp.zzb(this.aWO, n, v);
            return new zzahp<K, V>(this.aWP, KArray, VArray);
        }
        if (this.aWN.length > 25) {
            HashMap<K, V> hashMap = new HashMap<K, V>(this.aWN.length + 1);
            for (int i = 0; i < this.aWN.length; ++i) {
                hashMap.put(this.aWN[i], this.aWO[i]);
            }
            hashMap.put(k, v);
            return zzahy.zzc(hashMap, this.aWP);
        }
        int n2 = this.zzbj(k);
        K[] KArray = zzahp.zza(this.aWN, n2, k);
        V[] VArray = zzahp.zza(this.aWO, n2, v);
        return new zzahp<K, V>(this.aWP, KArray, VArray);
    }

    @Override
    public K zzcrh() {
        return this.aWN.length > 0 ? (K)this.aWN[0] : null;
    }

    @Override
    public K zzcri() {
        return this.aWN.length > 0 ? (K)this.aWN[this.aWN.length - 1] : null;
    }

    @Override
    public int size() {
        return this.aWN.length;
    }

    @Override
    public boolean isEmpty() {
        return this.aWN.length == 0;
    }

    @Override
    public void zza(zzahv.zzb<K, V> zzb2) {
        for (int i = 0; i < this.aWN.length; ++i) {
            zzb2.zzk(this.aWN[i], this.aWO[i]);
        }
    }

    private Iterator<Map.Entry<K, V>> zzh(final int n, final boolean bl) {
        return new Iterator<Map.Entry<K, V>>(){
            int aWQ;
            {
                this.aWQ = n;
            }

            @Override
            public boolean hasNext() {
                return bl ? this.aWQ >= 0 : this.aWQ < zzahp.this.aWN.length;
            }

            @Override
            public Map.Entry<K, V> next() {
                Object object = zzahp.this.aWN[this.aWQ];
                Object object2 = zzahp.this.aWO[this.aWQ];
                this.aWQ = bl ? this.aWQ - 1 : this.aWQ + 1;
                return new AbstractMap.SimpleImmutableEntry<Object, Object>(object, object2);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Can't remove elements from ImmutableSortedMap");
            }
        };
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return this.zzh(0, false);
    }

    @Override
    public Iterator<Map.Entry<K, V>> zzcrj() {
        return this.zzh(this.aWN.length - 1, true);
    }

    @Override
    public K zzbi(K k) {
        int n = this.zzbk(k);
        if (n == -1) {
            throw new IllegalArgumentException("Can't find predecessor of nonexistent key");
        }
        return n > 0 ? (K)this.aWN[n - 1] : null;
    }

    @Override
    public Comparator<K> getComparator() {
        return this.aWP;
    }

    private static <T> T[] zza(T[] TArray, int n) {
        int n2 = TArray.length - 1;
        Object[] objectArray = new Object[n2];
        System.arraycopy(TArray, 0, objectArray, 0, n);
        System.arraycopy(TArray, n + 1, objectArray, n, n2 - n);
        return objectArray;
    }

    private static <T> T[] zza(T[] TArray, int n, T t) {
        int n2 = TArray.length + 1;
        Object[] objectArray = new Object[n2];
        System.arraycopy(TArray, 0, objectArray, 0, n);
        objectArray[n] = t;
        System.arraycopy(TArray, n, objectArray, n + 1, n2 - n - 1);
        return objectArray;
    }

    private static <T> T[] zzb(T[] TArray, int n, T t) {
        int n2 = TArray.length;
        Object[] objectArray = new Object[n2];
        System.arraycopy(TArray, 0, objectArray, 0, n2);
        objectArray[n] = t;
        return objectArray;
    }

    private int zzbj(K k) {
        int n;
        for (n = 0; n < this.aWN.length && this.aWP.compare(this.aWN[n], k) < 0; ++n) {
        }
        return n;
    }

    private int zzbk(K k) {
        int n = 0;
        for (K k2 : this.aWN) {
            if (this.aWP.compare(k, k2) == 0) {
                return n;
            }
            ++n;
        }
        return -1;
    }
}

