/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import com.google.android.gms.internal.zzaiq;
import com.google.android.gms.internal.zzais;
import com.google.android.gms.internal.zzaiz;
import com.google.android.gms.internal.zzajn;
import com.google.android.gms.internal.zzake;
import com.google.android.gms.internal.zzakf;
import com.google.android.gms.internal.zzakg;
import com.google.android.gms.internal.zzaki;
import com.google.android.gms.internal.zzaku;
import com.google.android.gms.internal.zzalf;
import com.google.android.gms.internal.zzali;
import com.google.android.gms.internal.zzalj;
import com.google.android.gms.internal.zzaln;
import com.google.android.gms.internal.zzalt;
import com.google.android.gms.internal.zzalu;
import com.google.android.gms.internal.zzalv;
import com.google.android.gms.internal.zzamn;
import com.google.android.gms.internal.zzamr;
import com.google.android.gms.internal.zzamt;
import com.google.android.gms.internal.zzamw;
import com.google.firebase.database.DatabaseException;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class zzaho
implements zzake {
    private static final Charset sS = Charset.forName("UTF-8");
    private final SQLiteDatabase aWE;
    private final zzalf aWF;
    private boolean aWG;
    private long aWH = 0L;

    public zzaho(Context context, zzais zzais2, String string) {
        String string2;
        try {
            string2 = URLEncoder.encode(string, "utf-8");
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.aWF = zzais2.zzst("Persistence");
        this.aWE = this.zzag(context, string2);
    }

    @Override
    public void zza(zzaiz zzaiz2, zzalu zzalu2, long l) {
        this.zzcrg();
        long l2 = System.currentTimeMillis();
        byte[] byArray = this.zzbg(zzalu2.getValue(true));
        this.zza(zzaiz2, l, "o", byArray);
        long l3 = System.currentTimeMillis() - l2;
        if (this.aWF.zzcys()) {
            this.aWF.zzi(String.format("Persisted user overwrite in %dms", l3), new Object[0]);
        }
    }

    @Override
    public void zza(zzaiz zzaiz2, zzaiq zzaiq2, long l) {
        this.zzcrg();
        long l2 = System.currentTimeMillis();
        byte[] byArray = this.zzbg(zzaiq2.zzcy(true));
        this.zza(zzaiz2, l, "m", byArray);
        long l3 = System.currentTimeMillis() - l2;
        if (this.aWF.zzcys()) {
            this.aWF.zzi(String.format("Persisted user merge in %dms", l3), new Object[0]);
        }
    }

    @Override
    public void zzca(long l) {
        this.zzcrg();
        long l2 = System.currentTimeMillis();
        int n = this.aWE.delete("writes", "id = ?", new String[]{String.valueOf(l)});
        long l3 = System.currentTimeMillis() - l2;
        if (this.aWF.zzcys()) {
            this.aWF.zzi(String.format("Deleted %d write(s) with writeId %d in %dms", n, l, l3), new Object[0]);
        }
    }

    @Override
    public List<zzajn> zzcrc() {
        String[] stringArray = new String[]{"id", "path", "type", "part", "node"};
        long l = System.currentTimeMillis();
        ArrayList<zzajn> arrayList = new ArrayList<zzajn>();
        try (Cursor cursor = this.aWE.query("writes", stringArray, null, null, null, null, "id, part");){
            ArrayList<zzajn> arrayList2;
            long l2;
            while (cursor.moveToNext()) {
                zzajn zzajn2;
                Iterable<zzalt> iterable;
                Object object;
                byte[] byArray;
                l2 = cursor.getLong(0);
                arrayList2 = new zzaiz(cursor.getString(1));
                String string = cursor.getString(2);
                if (cursor.isNull(3)) {
                    byArray = cursor.getBlob(4);
                } else {
                    object = new ArrayList<byte[]>();
                    do {
                        object.add(cursor.getBlob(4));
                    } while (cursor.moveToNext() && cursor.getLong(0) == l2);
                    cursor.moveToPrevious();
                    byArray = this.zzar((List<byte[]>)object);
                }
                object = new String(byArray, sS);
                Object object2 = zzamn.zztd((String)object);
                if ("o".equals(string)) {
                    iterable = zzalv.zzbu(object2);
                    zzajn2 = new zzajn(l2, (zzaiz)((Object)arrayList2), (zzalu)iterable, true);
                } else if ("m".equals(string)) {
                    iterable = zzaiq.zzby((Map)object2);
                    zzajn2 = new zzajn(l2, (zzaiz)((Object)arrayList2), (zzaiq)iterable);
                } else {
                    String string2 = String.valueOf(string);
                    throw new IllegalStateException(string2.length() != 0 ? "Got invalid write type: ".concat(string2) : new String("Got invalid write type: "));
                }
                arrayList.add(zzajn2);
            }
            l2 = System.currentTimeMillis() - l;
            if (this.aWF.zzcys()) {
                this.aWF.zzi(String.format("Loaded %d writes in %dms", arrayList.size(), l2), new Object[0]);
            }
            arrayList2 = arrayList;
            return arrayList2;
        }
    }

    private void zza(zzaiz zzaiz2, long l, String string, byte[] byArray) {
        this.zzcrg();
        this.aWE.delete("writes", "id = ?", new String[]{String.valueOf(l)});
        if (byArray.length >= 262144) {
            List<byte[]> list = zzaho.zzd(byArray, 262144);
            for (int i = 0; i < list.size(); ++i) {
                ContentValues contentValues = new ContentValues();
                contentValues.put("id", Long.valueOf(l));
                contentValues.put("path", zzaho.zzc(zzaiz2));
                contentValues.put("type", string);
                contentValues.put("part", Integer.valueOf(i));
                contentValues.put("node", list.get(i));
                this.aWE.insertWithOnConflict("writes", null, contentValues, 5);
            }
        } else {
            ContentValues contentValues = new ContentValues();
            contentValues.put("id", Long.valueOf(l));
            contentValues.put("path", zzaho.zzc(zzaiz2));
            contentValues.put("type", string);
            contentValues.put("part", null);
            contentValues.put("node", byArray);
            this.aWE.insertWithOnConflict("writes", null, contentValues, 5);
        }
    }

    @Override
    public zzalu zza(zzaiz zzaiz2) {
        return this.zzb(zzaiz2);
    }

    @Override
    public void zza(zzaiz zzaiz2, zzalu zzalu2) {
        this.zzcrg();
        this.zza(zzaiz2, zzalu2, false);
    }

    @Override
    public void zzb(zzaiz zzaiz2, zzalu zzalu2) {
        this.zzcrg();
        this.zza(zzaiz2, zzalu2, true);
    }

    private void zza(zzaiz zzaiz2, zzalu zzalu2, boolean bl) {
        int n;
        int n2;
        long l = System.currentTimeMillis();
        if (!bl) {
            n2 = this.zza("serverCache", zzaiz2);
            n = this.zzc(zzaiz2, zzalu2);
        } else {
            n2 = 0;
            n = 0;
            for (zzalt zzalt2 : zzalu2) {
                n2 += this.zza("serverCache", zzaiz2.zza(zzalt2.zzczy()));
                n += this.zzc(zzaiz2.zza(zzalt2.zzczy()), zzalt2.zzcqw());
            }
        }
        long l2 = System.currentTimeMillis() - l;
        if (this.aWF.zzcys()) {
            this.aWF.zzi(String.format("Persisted a total of %d rows and deleted %d rows for a set at %s in %dms", n, n2, zzaiz2.toString(), l2), new Object[0]);
        }
    }

    @Override
    public void zza(zzaiz zzaiz2, zzaiq zzaiq2) {
        this.zzcrg();
        long l = System.currentTimeMillis();
        int n = 0;
        int n2 = 0;
        for (Map.Entry<zzaiz, zzalu> entry : zzaiq2) {
            n2 += this.zza("serverCache", zzaiz2.zzh(entry.getKey()));
            n += this.zzc(zzaiz2.zzh(entry.getKey()), entry.getValue());
        }
        long l2 = System.currentTimeMillis() - l;
        if (this.aWF.zzcys()) {
            this.aWF.zzi(String.format("Persisted a total of %d rows and deleted %d rows for a merge at %s in %dms", n, n2, zzaiz2.toString(), l2), new Object[0]);
        }
    }

    @Override
    public long zzcrd() {
        String string = String.format("SELECT sum(length(%s) + length(%s)) FROM %s", "value", "path", "serverCache");
        try (Cursor cursor = this.aWE.rawQuery(string, null);){
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
            throw new IllegalStateException("Couldn't read database result!");
        }
    }

    @Override
    public void zza(zzakg zzakg2) {
        this.zzcrg();
        long l = System.currentTimeMillis();
        ContentValues contentValues = new ContentValues();
        contentValues.put("id", Long.valueOf(zzakg2.id));
        contentValues.put("path", zzaho.zzc(zzakg2.bdz.zzcra()));
        contentValues.put("queryParams", zzakg2.bdz.zzcyf().zzcyd());
        contentValues.put("lastUse", Long.valueOf(zzakg2.bdA));
        contentValues.put("complete", Boolean.valueOf(zzakg2.bdB));
        contentValues.put("active", Boolean.valueOf(zzakg2.bdC));
        this.aWE.insertWithOnConflict("trackedQueries", null, contentValues, 5);
        long l2 = System.currentTimeMillis() - l;
        if (this.aWF.zzcys()) {
            this.aWF.zzi(String.format("Saved new tracked query in %dms", l2), new Object[0]);
        }
    }

    @Override
    public void zzcb(long l) {
        this.zzcrg();
        String string = String.valueOf(l);
        String string2 = "id = ?";
        this.aWE.delete("trackedQueries", string2, new String[]{string});
        String string3 = "id = ?";
        this.aWE.delete("trackedKeys", string3, new String[]{string});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<zzakg> zzcre() {
        String[] stringArray = new String[]{"id", "path", "queryParams", "lastUse", "complete", "active"};
        long l = System.currentTimeMillis();
        ArrayList<zzakg> arrayList = new ArrayList<zzakg>();
        try (Cursor cursor = this.aWE.query("trackedQueries", stringArray, null, null, null, null, "id");){
            ArrayList<zzakg> arrayList2;
            long l2;
            while (cursor.moveToNext()) {
                Map map;
                l2 = cursor.getLong(0);
                arrayList2 = new zzaiz(cursor.getString(1));
                String string = cursor.getString(2);
                try {
                    map = zzamn.zztc((String)string);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
                zzaku zzaku2 = zzaku.zzb(arrayList2, map);
                long l3 = cursor.getLong(3);
                boolean bl = cursor.getInt(4) != 0;
                boolean bl2 = cursor.getInt(5) != 0;
                zzakg zzakg2 = new zzakg(l2, zzaku2, l3, bl, bl2);
                arrayList.add(zzakg2);
            }
            l2 = System.currentTimeMillis() - l;
            if (this.aWF.zzcys()) {
                this.aWF.zzi(String.format("Loaded %d tracked queries in %dms", arrayList.size(), l2), new Object[0]);
            }
            arrayList2 = arrayList;
            return arrayList2;
        }
    }

    @Override
    public void zzcc(long l) {
        this.zzcrg();
        long l2 = System.currentTimeMillis();
        String string = "active = 1";
        ContentValues contentValues = new ContentValues();
        contentValues.put("active", Boolean.valueOf(false));
        contentValues.put("lastUse", Long.valueOf(l));
        this.aWE.updateWithOnConflict("trackedQueries", contentValues, string, new String[0], 5);
        long l3 = System.currentTimeMillis() - l2;
        if (this.aWF.zzcys()) {
            this.aWF.zzi(String.format("Reset active tracked queries in %dms", l3), new Object[0]);
        }
    }

    @Override
    public void zza(long l, Set<zzali> set) {
        this.zzcrg();
        long l2 = System.currentTimeMillis();
        String string = String.valueOf(l);
        String string2 = "id = ?";
        this.aWE.delete("trackedKeys", string2, new String[]{string});
        for (zzali zzali2 : set) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("id", Long.valueOf(l));
            contentValues.put("key", zzali2.asString());
            this.aWE.insertWithOnConflict("trackedKeys", null, contentValues, 5);
        }
        long l3 = System.currentTimeMillis() - l2;
        if (this.aWF.zzcys()) {
            this.aWF.zzi(String.format("Set %d tracked query keys for tracked query %d in %dms", set.size(), l, l3), new Object[0]);
        }
    }

    @Override
    public void zza(long l, Set<zzali> set, Set<zzali> set2) {
        this.zzcrg();
        long l2 = System.currentTimeMillis();
        String string = "id = ? AND key = ?";
        String string2 = String.valueOf(l);
        for (zzali zzali2 : set2) {
            this.aWE.delete("trackedKeys", string, new String[]{string2, zzali2.asString()});
        }
        for (zzali zzali2 : set) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("id", Long.valueOf(l));
            contentValues.put("key", zzali2.asString());
            this.aWE.insertWithOnConflict("trackedKeys", null, contentValues, 5);
        }
        long l3 = System.currentTimeMillis() - l2;
        if (this.aWF.zzcys()) {
            this.aWF.zzi(String.format("Updated tracked query keys (%d added, %d removed) for tracked query id %d in %dms", set.size(), set2.size(), l, l3), new Object[0]);
        }
    }

    @Override
    public Set<zzali> zzcd(long l) {
        return this.zzh(Collections.singleton(l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<zzali> zzh(Set<Long> set) {
        String[] stringArray = new String[]{"key"};
        long l = System.currentTimeMillis();
        String string = String.valueOf("id IN (");
        Object object = String.valueOf(this.zzp(set));
        String string2 = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(object).length()).append(string).append((String)object).append(")").toString();
        string = this.aWE.query(true, "trackedKeys", stringArray, string2, null, null, null, null, null);
        object = new HashSet();
        try {
            while (string.moveToNext()) {
                String string3 = string.getString(0);
                object.add(zzali.zzsy(string3));
            }
            long l2 = System.currentTimeMillis() - l;
            if (this.aWF.zzcys()) {
                this.aWF.zzi(String.format("Loaded %d tracked queries keys for tracked queries %s in %dms", object.size(), set.toString(), l2), new Object[0]);
            }
            Object object2 = object;
            return object2;
        }
        finally {
            string.close();
        }
    }

    @Override
    public void zza(zzaiz zzaiz2, zzakf zzakf2) {
        Object object;
        String string;
        Iterable<Object> iterable;
        Iterable<zzali> iterable2;
        if (!zzakf2.zzcwx()) {
            return;
        }
        this.zzcrg();
        long l = System.currentTimeMillis();
        Cursor cursor = this.zza(zzaiz2, new String[]{"rowid", "path"});
        zzaki<Object> zzaki2 = new zzaki<Object>(null);
        zzaki<Object> zzaki3 = new zzaki<Object>(null);
        while (cursor.moveToNext()) {
            long l2 = cursor.getLong(0);
            iterable2 = new zzaiz(cursor.getString(1));
            if (!zzaiz2.zzi((zzaiz)iterable2)) {
                iterable = String.valueOf(zzaiz2);
                string = String.valueOf(iterable2);
                this.aWF.warn(new StringBuilder(67 + String.valueOf(iterable).length() + String.valueOf(string).length()).append("We are pruning at ").append((String)((Object)iterable)).append(" but we have data stored higher up at ").append(string).append(". Ignoring.").toString());
                continue;
            }
            iterable = zzaiz.zza(zzaiz2, (zzaiz)iterable2);
            if (zzakf2.zzw((zzaiz)iterable)) {
                zzaki2 = zzaki2.zzb((zzaiz)iterable, l2);
                continue;
            }
            if (zzakf2.zzx((zzaiz)iterable)) {
                zzaki3 = zzaki3.zzb((zzaiz)iterable, l2);
                continue;
            }
            string = String.valueOf(zzaiz2);
            object = String.valueOf(iterable2);
            this.aWF.warn(new StringBuilder(88 + String.valueOf(string).length() + String.valueOf(object).length()).append("We are pruning at ").append(string).append(" and have data at ").append((String)object).append(" that isn't marked for pruning or keeping. Ignoring.").toString());
        }
        int n = 0;
        int n2 = 0;
        if (!zzaki2.isEmpty()) {
            iterable2 = new ArrayList();
            this.zza(zzaiz2, zzaiz.zzcve(), zzaki2, zzaki3, zzakf2, (List<zzamt<zzaiz, zzalu>>)iterable2);
            iterable = zzaki2.values();
            object = String.valueOf(this.zzp((Collection<Long>)iterable));
            string = new StringBuilder(11 + String.valueOf(object).length()).append("rowid IN (").append((String)object).append(")").toString();
            this.aWE.delete("serverCache", string, null);
            for (zzamt zzamt2 : iterable2) {
                this.zzc(zzaiz2.zzh((zzaiz)zzamt2.getFirst()), (zzalu)zzamt2.y());
            }
            n = iterable.size();
            n2 = iterable2.size();
        }
        long l3 = System.currentTimeMillis() - l;
        if (this.aWF.zzcys()) {
            this.aWF.zzi(String.format("Pruned %d rows with %d nodes resaved in %dms", n, n2, l3), new Object[0]);
        }
    }

    private void zza(zzaiz zzaiz2, final zzaiz zzaiz3, zzaki<Long> zzaki2, final zzaki<Long> zzaki3, zzakf zzakf2, final List<zzamt<zzaiz, zzalu>> list) {
        if (zzaki2.getValue() != null) {
            int n = zzakf2.zza(0, new zzaki.zza<Void, Integer>(){

                @Override
                public Integer zza(zzaiz zzaiz2, Void void_, Integer n) {
                    return zzaki3.zzak(zzaiz2) == null ? n + 1 : n;
                }
            });
            if (n > 0) {
                zzaiz zzaiz4 = zzaiz2.zzh(zzaiz3);
                if (this.aWF.zzcys()) {
                    this.aWF.zzi(String.format("Need to rewrite %d nodes below path %s", n, zzaiz4), new Object[0]);
                }
                final zzalu zzalu2 = this.zzb(zzaiz4);
                zzakf2.zza(null, new zzaki.zza<Void, Void>(){

                    @Override
                    public Void zza(zzaiz zzaiz2, Void void_, Void void_2) {
                        if (zzaki3.zzak(zzaiz2) == null) {
                            list.add(new zzamt<zzaiz, zzalu>(zzaiz3.zzh(zzaiz2), zzalu2.zzao(zzaiz2)));
                        }
                        return null;
                    }
                });
            }
        } else {
            for (Map.Entry<zzali, zzaki<Long>> entry : zzaki2.zzcxd()) {
                zzali zzali2 = entry.getKey();
                zzakf zzakf3 = zzakf2.zzd(entry.getKey());
                this.zza(zzaiz2, zzaiz3.zza(zzali2), entry.getValue(), zzaki3.zze(zzali2), zzakf3, list);
            }
        }
    }

    @Override
    public void zzcrf() {
        this.zzcrg();
        long l = System.currentTimeMillis();
        int n = this.aWE.delete("writes", null, null);
        long l2 = System.currentTimeMillis() - l;
        if (this.aWF.zzcys()) {
            this.aWF.zzi(String.format("Deleted %d (all) write(s) in %dms", n, l2), new Object[0]);
        }
    }

    @Override
    public void beginTransaction() {
        zzamw.zzb(!this.aWG, "runInTransaction called when an existing transaction is already in progress.");
        if (this.aWF.zzcys()) {
            this.aWF.zzi("Starting transaction.", new Object[0]);
        }
        this.aWE.beginTransaction();
        this.aWG = true;
        this.aWH = System.currentTimeMillis();
    }

    @Override
    public void endTransaction() {
        this.aWE.endTransaction();
        this.aWG = false;
        long l = System.currentTimeMillis() - this.aWH;
        if (this.aWF.zzcys()) {
            this.aWF.zzi(String.format("Transaction completed. Elapsed: %dms", l), new Object[0]);
        }
    }

    @Override
    public void setTransactionSuccessful() {
        this.aWE.setTransactionSuccessful();
    }

    private SQLiteDatabase zzag(Context context, String string) {
        zza zza2 = new zza(context, string);
        try {
            SQLiteDatabase sQLiteDatabase = zza2.getWritableDatabase();
            sQLiteDatabase.rawQuery("PRAGMA locking_mode = EXCLUSIVE", null).close();
            sQLiteDatabase.beginTransaction();
            sQLiteDatabase.endTransaction();
            return sQLiteDatabase;
        }
        catch (SQLiteException sQLiteException) {
            if (sQLiteException instanceof SQLiteDatabaseLockedException) {
                String string2 = "Failed to gain exclusive lock to Firebase Database's offline persistence. This generally means you are using Firebase Database from multiple processes in your app. Keep in mind that multi-process Android apps execute the code in your Application class in all processes, so you may need to avoid initializing FirebaseDatabase in your Application class. If you are intentionally using Firebase Database from multiple processes, you can only enable offline persistence (i.e. call setPersistenceEnabled(true)) in one of them.";
                throw new DatabaseException(string2, sQLiteException);
            }
            throw sQLiteException;
        }
    }

    private void zzcrg() {
        zzamw.zzb(this.aWG, "Transaction expected to already be in progress.");
    }

    private int zzc(zzaiz zzaiz2, zzalu zzalu2) {
        long l = zzamr.zzt(zzalu2);
        if (zzalu2 instanceof zzalj && l > 16384L) {
            if (this.aWF.zzcys()) {
                this.aWF.zzi(String.format("Node estimated serialized size at path %s of %d bytes exceeds limit of %d bytes. Splitting up.", zzaiz2, l, 16384), new Object[0]);
            }
            int n = 0;
            for (zzalt zzalt2 : zzalu2) {
                n += this.zzc(zzaiz2.zza(zzalt2.zzczy()), zzalt2.zzcqw());
            }
            if (!zzalu2.zzczd().isEmpty()) {
                this.zzd(zzaiz2.zza(zzali.zzcyx()), zzalu2.zzczd());
                ++n;
            }
            this.zzd(zzaiz2, zzaln.zzczo());
            return ++n;
        }
        this.zzd(zzaiz2, zzalu2);
        return 1;
    }

    private String zza(zzaiz zzaiz2, int n) {
        String string = String.valueOf(zzaho.zzc(zzaiz2));
        String string2 = String.valueOf(String.format(".part-%04d", n));
        return string2.length() != 0 ? string.concat(string2) : new String(string);
    }

    private void zzd(zzaiz zzaiz2, zzalu zzalu2) {
        byte[] byArray = this.zzbg(zzalu2.getValue(true));
        if (byArray.length >= 262144) {
            int n;
            List<byte[]> list = zzaho.zzd(byArray, 262144);
            if (this.aWF.zzcys()) {
                n = list.size();
                this.aWF.zzi(new StringBuilder(45).append("Saving huge leaf node with ").append(n).append(" parts.").toString(), new Object[0]);
            }
            for (n = 0; n < list.size(); ++n) {
                ContentValues contentValues = new ContentValues();
                contentValues.put("path", this.zza(zzaiz2, n));
                contentValues.put("value", list.get(n));
                this.aWE.insertWithOnConflict("serverCache", null, contentValues, 5);
            }
        } else {
            ContentValues contentValues = new ContentValues();
            contentValues.put("path", zzaho.zzc(zzaiz2));
            contentValues.put("value", byArray);
            this.aWE.insertWithOnConflict("serverCache", null, contentValues, 5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private zzalu zzb(zzaiz zzaiz2) {
        zzaiz zzaiz3;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<byte[]> arrayList2 = new ArrayList<byte[]>();
        long l = System.currentTimeMillis();
        Cursor cursor = this.zza(zzaiz2, new String[]{"path", "value"});
        long l2 = System.currentTimeMillis() - l;
        long l3 = System.currentTimeMillis();
        try {
            while (cursor.moveToNext()) {
                arrayList.add(cursor.getString(0));
                arrayList2.add(cursor.getBlob(1));
            }
        }
        finally {
            cursor.close();
        }
        long l4 = System.currentTimeMillis() - l3;
        long l5 = System.currentTimeMillis();
        zzalu zzalu2 = zzaln.zzczo();
        boolean bl = false;
        HashMap<zzaiz, void> hashMap = new HashMap<zzaiz, void>();
        for (int i = 0; i < arrayList2.size(); ++i) {
            void object;
            Object object2;
            if (((String)arrayList.get(i)).endsWith(".part-0000")) {
                object2 = (String)arrayList.get(i);
                zzaiz3 = new zzaiz(((String)object2).substring(0, ((String)object2).length() - ".part-0000".length()));
                int n = this.zza(zzaiz3, arrayList, i);
                if (this.aWF.zzcys()) {
                    this.aWF.zzi(new StringBuilder(42).append("Loading split node with ").append(n).append(" parts.").toString(), new Object[0]);
                }
                zzalu zzalu3 = this.zzas(this.zzar(arrayList2.subList(i, i + n)));
                i = i + n - 1;
            } else {
                zzalu zzalu4 = this.zzas((byte[])arrayList2.get(i));
                zzaiz3 = new zzaiz((String)arrayList.get(i));
            }
            if (zzaiz3.zzcvk() != null && zzaiz3.zzcvk().zzcyz()) {
                hashMap.put(zzaiz3, object);
                continue;
            }
            if (zzaiz3.zzi(zzaiz2)) {
                zzamw.zzb(!bl, "Descendants of path must come after ancestors.");
                zzalu2 = object.zzao(zzaiz.zza(zzaiz3, zzaiz2));
                continue;
            }
            if (zzaiz2.zzi(zzaiz3)) {
                bl = true;
                object2 = zzaiz.zza(zzaiz2, zzaiz3);
                zzalu2 = zzalu2.zzl((zzaiz)object2, (zzalu)object);
                continue;
            }
            throw new IllegalStateException(String.format("Loading an unrelated row with path %s for %s", zzaiz3, zzaiz2));
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            zzaiz3 = (zzaiz)entry.getKey();
            zzalu2 = zzalu2.zzl(zzaiz.zza(zzaiz2, zzaiz3), (zzalu)entry.getValue());
        }
        long l6 = System.currentTimeMillis() - l5;
        long l7 = System.currentTimeMillis() - l;
        if (this.aWF.zzcys()) {
            this.aWF.zzi(String.format("Loaded a total of %d rows for a total of %d nodes at %s in %dms (Query: %dms, Loading: %dms, Serializing: %dms)", arrayList2.size(), zzamr.zzu(zzalu2), zzaiz2, l7, l2, l4, l6), new Object[0]);
        }
        return zzalu2;
    }

    private int zza(zzaiz zzaiz2, List<String> list, int n) {
        int n2;
        String string = zzaho.zzc(zzaiz2);
        if (!list.get(n).startsWith(string)) {
            throw new IllegalStateException("Extracting split nodes needs to start with path prefix");
        }
        for (n2 = n + 1; n2 < list.size() && list.get(n2).equals(this.zza(zzaiz2, n2 - n)); ++n2) {
        }
        if (n2 < list.size()) {
            String string2 = String.valueOf(string);
            String string3 = String.valueOf(".part-");
            if (list.get(n2).startsWith(string3.length() != 0 ? string2.concat(string3) : new String(string2))) {
                throw new IllegalStateException("Run did not finish with all parts");
            }
        }
        return n2 - n;
    }

    private Cursor zza(zzaiz zzaiz2, String[] stringArray) {
        String string = zzaho.zzc(zzaiz2);
        String string2 = zzaho.zzse(string);
        String[] stringArray2 = new String[zzaiz2.size() + 3];
        String string3 = zzaho.zzb(zzaiz2, stringArray2);
        String string4 = String.valueOf(string3);
        String string5 = String.valueOf(" OR (path > ? AND path < ?)");
        string3 = string5.length() != 0 ? string4.concat(string5) : new String(string4);
        stringArray2[zzaiz2.size() + 1] = string;
        stringArray2[zzaiz2.size() + 2] = string2;
        String string6 = "path";
        return this.aWE.query("serverCache", stringArray, string3, stringArray2, null, null, string6);
    }

    private static String zzc(zzaiz zzaiz2) {
        if (zzaiz2.isEmpty()) {
            return "/";
        }
        return String.valueOf(zzaiz2.toString()).concat("/");
    }

    private static String zzse(String string) {
        assert (string.endsWith("/")) : "Path keys must end with a '/'";
        String string2 = String.valueOf(string.substring(0, string.length() - 1));
        int n = 48;
        return new StringBuilder(1 + String.valueOf(string2).length()).append(string2).append('0').toString();
    }

    private static String zzb(zzaiz zzaiz2, String[] stringArray) {
        assert (stringArray.length >= zzaiz2.size() + 1);
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder("(");
        while (!zzaiz2.isEmpty()) {
            stringBuilder.append("path");
            stringBuilder.append(" = ? OR ");
            stringArray[n] = zzaho.zzc(zzaiz2);
            zzaiz2 = zzaiz2.zzcvj();
            ++n;
        }
        stringBuilder.append("path");
        stringBuilder.append(" = ?)");
        stringArray[n] = zzaho.zzc(zzaiz.zzcve());
        return stringBuilder.toString();
    }

    private int zza(String string, zzaiz zzaiz2) {
        String string2 = "path >= ? AND path < ?";
        String string3 = zzaho.zzc(zzaiz2);
        String string4 = zzaho.zzse(string3);
        return this.aWE.delete(string, string2, new String[]{string3, string4});
    }

    private static List<byte[]> zzd(byte[] byArray, int n) {
        int n2 = (byArray.length - 1) / n + 1;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(n2);
        for (int i = 0; i < n2; ++i) {
            int n3 = Math.min(n, byArray.length - i * n);
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, i * n, byArray2, 0, n3);
            arrayList.add(byArray2);
        }
        return arrayList;
    }

    private byte[] zzar(List<byte[]> list) {
        int n = 0;
        for (byte[] byArray : list) {
            n += byArray.length;
        }
        Object object = new byte[n];
        int n2 = 0;
        for (byte[] byArray : list) {
            System.arraycopy(byArray, 0, object, n2, byArray.length);
            n2 += byArray.length;
        }
        return object;
    }

    private byte[] zzbg(Object object) {
        try {
            return zzamn.zzbw((Object)object).getBytes(sS);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Could not serialize leaf node", iOException);
        }
    }

    private zzalu zzas(byte[] byArray) {
        try {
            Object object = zzamn.zztd((String)new String(byArray, sS));
            return zzalv.zzbu(object);
        }
        catch (IOException iOException) {
            String string = new String(byArray, sS);
            String string2 = String.valueOf(string);
            throw new RuntimeException(string2.length() != 0 ? "Could not deserialize node: ".concat(string2) : new String("Could not deserialize node: "), iOException);
        }
    }

    private String zzp(Collection<Long> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (long l : collection) {
            if (!bl) {
                stringBuilder.append(",");
            }
            bl = false;
            stringBuilder.append(l);
        }
        return stringBuilder.toString();
    }

    private static class zza
    extends SQLiteOpenHelper {
        public zza(Context context, String string) {
            super(context, string, null, 2);
        }

        public void onCreate(SQLiteDatabase sQLiteDatabase) {
            sQLiteDatabase.execSQL("CREATE TABLE serverCache (path TEXT PRIMARY KEY, value BLOB);");
            sQLiteDatabase.execSQL("CREATE TABLE writes (id INTEGER, path TEXT, type TEXT, part INTEGER, node BLOB, UNIQUE (id, part));");
            sQLiteDatabase.execSQL("CREATE TABLE trackedQueries (id INTEGER PRIMARY KEY, path TEXT, queryParams TEXT, lastUse INTEGER, complete INTEGER, active INTEGER);");
            sQLiteDatabase.execSQL("CREATE TABLE trackedKeys (id INTEGER, key TEXT);");
        }

        public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
            assert (n2 == 2) : "Why is onUpgrade() called with a different version?";
            if (n > 1) {
                throw new AssertionError((Object)new StringBuilder(40).append("We don't handle upgrading to ").append(n2).toString());
            }
            this.zzc(sQLiteDatabase, "serverCache");
            sQLiteDatabase.execSQL("CREATE TABLE serverCache (path TEXT PRIMARY KEY, value BLOB);");
            this.zzc(sQLiteDatabase, "complete");
            sQLiteDatabase.execSQL("CREATE TABLE trackedKeys (id INTEGER, key TEXT);");
            sQLiteDatabase.execSQL("CREATE TABLE trackedQueries (id INTEGER PRIMARY KEY, path TEXT, queryParams TEXT, lastUse INTEGER, complete INTEGER, active INTEGER);");
        }

        private void zzc(SQLiteDatabase sQLiteDatabase, String string) {
            String string2 = String.valueOf(string);
            sQLiteDatabase.execSQL(string2.length() != 0 ? "DROP TABLE IF EXISTS ".concat(string2) : new String("DROP TABLE IF EXISTS "));
        }
    }
}

