/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.fitness.HistoryApi;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.DailyTotalRequest;
import com.google.android.gms.fitness.request.DataDeleteRequest;
import com.google.android.gms.fitness.request.DataInsertRequest;
import com.google.android.gms.fitness.request.DataReadRequest;
import com.google.android.gms.fitness.request.DataUpdateListenerRegistrationRequest;
import com.google.android.gms.fitness.request.DataUpdateListenerUnregistrationRequest;
import com.google.android.gms.fitness.request.DataUpdateRequest;
import com.google.android.gms.fitness.result.DailyTotalResult;
import com.google.android.gms.fitness.result.DataReadResult;
import com.google.android.gms.internal.zzqc;
import com.google.android.gms.internal.zztj;
import com.google.android.gms.internal.zzto;
import com.google.android.gms.internal.zztp;
import com.google.android.gms.internal.zztx;
import com.google.android.gms.internal.zzus;

public class zzun
implements HistoryApi {
    @Override
    public PendingResult<Status> insertData(GoogleApiClient googleApiClient, DataSet dataSet) {
        return this.zza(googleApiClient, dataSet, false);
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, final DataSet dataSet, final boolean bl) {
        zzac.zzb((Object)((Object)dataSet), (Object)"Must set the data set");
        zzac.zza((!dataSet.getDataPoints().isEmpty() ? 1 : 0) != 0, (Object)"Cannot use an empty data set");
        zzac.zzb((Object)((Object)dataSet.getDataSource().zzben()), (Object)"Must set the app package name for the data source");
        return googleApiClient.zzc((zzqc.zza)new zztj.zzc(googleApiClient){

            protected void zza(zztj zztj2) throws RemoteException {
                zzus zzus2 = new zzus((zzqc.zzb<Status>)this);
                ((zztx)zztj2.zzatx()).zza(new DataInsertRequest(dataSet, zzus2, bl));
            }
        });
    }

    @Override
    public PendingResult<Status> deleteData(GoogleApiClient googleApiClient, final DataDeleteRequest dataDeleteRequest) {
        return googleApiClient.zzc((zzqc.zza)new zztj.zzc(googleApiClient){

            protected void zza(zztj zztj2) throws RemoteException {
                zzus zzus2 = new zzus((zzqc.zzb<Status>)this);
                ((zztx)zztj2.zzatx()).zza(new DataDeleteRequest(dataDeleteRequest, zzus2));
            }
        });
    }

    @Override
    public PendingResult<Status> updateData(GoogleApiClient googleApiClient, final DataUpdateRequest dataUpdateRequest) {
        zzac.zzb((Object)((Object)dataUpdateRequest.getDataSet()), (Object)"Must set the data set");
        zzac.zza((long)dataUpdateRequest.zzafn(), (Object)"Must set a non-zero value for startTimeMillis/startTime");
        zzac.zza((long)dataUpdateRequest.zzbao(), (Object)"Must set a non-zero value for endTimeMillis/endTime");
        return googleApiClient.zzc((zzqc.zza)new zztj.zzc(googleApiClient){

            protected void zza(zztj zztj2) throws RemoteException {
                zzus zzus2 = new zzus((zzqc.zzb<Status>)this);
                ((zztx)zztj2.zzatx()).zza(new DataUpdateRequest(dataUpdateRequest, (IBinder)zzus2));
            }
        });
    }

    @Override
    public PendingResult<Status> registerDataUpdateListener(GoogleApiClient googleApiClient, final DataUpdateListenerRegistrationRequest dataUpdateListenerRegistrationRequest) {
        return googleApiClient.zzc((zzqc.zza)new zztj.zzc(googleApiClient){

            protected void zza(zztj zztj2) throws RemoteException {
                zzus zzus2 = new zzus((zzqc.zzb<Status>)this);
                ((zztx)zztj2.zzatx()).zza(new DataUpdateListenerRegistrationRequest(dataUpdateListenerRegistrationRequest, (IBinder)zzus2));
            }
        });
    }

    @Override
    public PendingResult<Status> unregisterDataUpdateListener(GoogleApiClient googleApiClient, final PendingIntent pendingIntent) {
        return googleApiClient.zzd((zzqc.zza)new zztj.zzc(googleApiClient){

            protected void zza(zztj zztj2) throws RemoteException {
                zzus zzus2 = new zzus((zzqc.zzb<Status>)this);
                ((zztx)zztj2.zzatx()).zza(new DataUpdateListenerUnregistrationRequest(pendingIntent, (IBinder)zzus2));
            }
        });
    }

    @Override
    public PendingResult<DataReadResult> readData(GoogleApiClient googleApiClient, final DataReadRequest dataReadRequest) {
        return googleApiClient.zzc((zzqc.zza)new zztj.zza<DataReadResult>(googleApiClient){

            protected void zza(zztj zztj2) throws RemoteException {
                zza zza2 = new zza((zzqc.zzb)this);
                ((zztx)zztj2.zzatx()).zza(new DataReadRequest(dataReadRequest, zza2));
            }

            protected DataReadResult zzau(Status status) {
                return DataReadResult.zza(status, dataReadRequest.getDataTypes(), dataReadRequest.getDataSources());
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzau(status);
            }
        });
    }

    @Override
    public PendingResult<DailyTotalResult> readDailyTotal(GoogleApiClient googleApiClient, DataType dataType) {
        return this.zza(googleApiClient, dataType, false);
    }

    @Override
    public PendingResult<DailyTotalResult> readDailyTotalFromLocalDevice(GoogleApiClient googleApiClient, DataType dataType) {
        return this.zza(googleApiClient, dataType, true);
    }

    private PendingResult<DailyTotalResult> zza(GoogleApiClient googleApiClient, final DataType dataType, final boolean bl) {
        return googleApiClient.zzc((zzqc.zza)new zztj.zza<DailyTotalResult>(googleApiClient){

            protected void zza(zztj zztj2) throws RemoteException {
                zzto.zza zza2 = new zzto.zza(){

                    @Override
                    public void zza(DailyTotalResult dailyTotalResult) throws RemoteException {
                        this.zzc(dailyTotalResult);
                    }
                };
                DailyTotalRequest dailyTotalRequest = new DailyTotalRequest(zza2, dataType, bl);
                ((zztx)zztj2.zzatx()).zza(dailyTotalRequest);
            }

            protected DailyTotalResult zzav(Status status) {
                return DailyTotalResult.zza(status, dataType);
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzav(status);
            }
        });
    }

    private static class zza
    extends zztp.zza {
        private final zzqc.zzb<DataReadResult> Dj;
        private int So = 0;
        private DataReadResult Sp = null;

        private zza(zzqc.zzb<DataReadResult> zzb2) {
            this.Dj = zzb2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zza(DataReadResult dataReadResult) {
            zza zza2 = this;
            synchronized (zza2) {
                if (Log.isLoggable((String)"Fitness", (int)2)) {
                    int n = this.So;
                    Log.v((String)"Fitness", (String)new StringBuilder(33).append("Received batch result ").append(n).toString());
                }
                if (this.Sp == null) {
                    this.Sp = dataReadResult;
                } else {
                    this.Sp.zzb(dataReadResult);
                }
                ++this.So;
                if (this.So == this.Sp.zzbha()) {
                    this.Dj.setResult((Object)this.Sp);
                }
            }
        }
    }
}

