/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.service;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.zzt;
import com.google.android.gms.fitness.service.SensorEventDispatcher;
import com.google.android.gms.fitness.service.zza;
import com.google.android.gms.fitness.service.zzb;
import java.util.concurrent.TimeUnit;

public class FitnessSensorServiceRequest
extends AbstractSafeParcelable {
    public static final int UNSPECIFIED = -1;
    private final int mVersionCode;
    private final DataSource ON;
    private final zzt TD;
    private final long Ut;
    private final long Uu;
    public static final Parcelable.Creator<FitnessSensorServiceRequest> CREATOR = new zza();

    FitnessSensorServiceRequest(int n, DataSource dataSource, IBinder iBinder, long l, long l2) {
        this.mVersionCode = n;
        this.ON = dataSource;
        this.TD = zzt.zza.zzfg(iBinder);
        this.Ut = l;
        this.Uu = l2;
    }

    public DataSource getDataSource() {
        return this.ON;
    }

    public SensorEventDispatcher getDispatcher() {
        return new zzb(this.TD);
    }

    public long getSamplingRate(TimeUnit timeUnit) {
        return this.Ut == -1L ? -1L : timeUnit.convert(this.Ut, TimeUnit.MICROSECONDS);
    }

    public long getBatchInterval(TimeUnit timeUnit) {
        return timeUnit.convert(this.Uu, TimeUnit.MICROSECONDS);
    }

    public String toString() {
        return String.format("FitnessSensorServiceRequest{%s}", new Object[]{this.ON});
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    IBinder zzbgs() {
        return this.TD.asBinder();
    }

    public long zzbfk() {
        return this.Ut;
    }

    public long zzbhk() {
        return this.Uu;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zza.zza(this, parcel, n);
    }

    public boolean equals(Object object) {
        return this == object || object instanceof FitnessSensorServiceRequest && this.zza((FitnessSensorServiceRequest)((Object)object));
    }

    private boolean zza(FitnessSensorServiceRequest fitnessSensorServiceRequest) {
        return zzab.equal((Object)((Object)this.ON), (Object)((Object)fitnessSensorServiceRequest.ON)) && this.Ut == fitnessSensorServiceRequest.Ut && this.Uu == fitnessSensorServiceRequest.Uu;
    }

    public int hashCode() {
        return zzab.hashCode((Object[])new Object[]{this.ON, this.Ut, this.Uu});
    }
}

