/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.data.SessionDataSet;
import com.google.android.gms.fitness.result.zzl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SessionReadResult
extends AbstractSafeParcelable
implements Result {
    private final int mVersionCode;
    private final List<Session> ST;
    private final List<SessionDataSet> Uq;
    private final Status fp;
    public static final Parcelable.Creator<SessionReadResult> CREATOR = new zzl();

    SessionReadResult(int n, List<Session> list, List<SessionDataSet> list2, Status status) {
        this.mVersionCode = n;
        this.ST = list;
        this.Uq = Collections.unmodifiableList(list2);
        this.fp = status;
    }

    public SessionReadResult(List<Session> list, List<SessionDataSet> list2, Status status) {
        this.mVersionCode = 3;
        this.ST = list;
        this.Uq = Collections.unmodifiableList(list2);
        this.fp = status;
    }

    public static SessionReadResult zzbe(Status status) {
        ArrayList<Session> arrayList = new ArrayList<Session>();
        ArrayList<SessionDataSet> arrayList2 = new ArrayList<SessionDataSet>();
        return new SessionReadResult(arrayList, arrayList2, status);
    }

    public List<Session> getSessions() {
        return this.ST;
    }

    public List<DataSet> getDataSet(Session session, DataType dataType) {
        zzac.zzb((boolean)this.ST.contains((Object)session), (String)"Attempting to read data for session %s which was not returned", (Object[])new Object[]{session});
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        for (SessionDataSet sessionDataSet : this.Uq) {
            if (!zzab.equal((Object)((Object)session), (Object)((Object)sessionDataSet.getSession())) || !dataType.equals((Object)sessionDataSet.getDataSet().getDataType())) continue;
            arrayList.add(sessionDataSet.getDataSet());
        }
        return arrayList;
    }

    public List<DataSet> getDataSet(Session session) {
        zzac.zzb((boolean)this.ST.contains((Object)session), (String)"Attempting to read data for session %s which was not returned", (Object[])new Object[]{session});
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        for (SessionDataSet sessionDataSet : this.Uq) {
            if (!zzab.equal((Object)((Object)session), (Object)((Object)sessionDataSet.getSession()))) continue;
            arrayList.add(sessionDataSet.getDataSet());
        }
        return arrayList;
    }

    public List<SessionDataSet> zzbhh() {
        return this.Uq;
    }

    public Status getStatus() {
        return this.fp;
    }

    public boolean equals(Object object) {
        return this == object || object instanceof SessionReadResult && this.zzb((SessionReadResult)((Object)object));
    }

    private boolean zzb(SessionReadResult sessionReadResult) {
        return this.fp.equals((Object)sessionReadResult.fp) && zzab.equal(this.ST, sessionReadResult.ST) && zzab.equal(this.Uq, sessionReadResult.Uq);
    }

    public int hashCode() {
        return zzab.hashCode((Object[])new Object[]{this.fp, this.ST, this.Uq});
    }

    public String toString() {
        return zzab.zzx((Object)((Object)this)).zzg("status", (Object)this.fp).zzg("sessions", this.ST).zzg("sessionDataSets", this.Uq).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzl.zza(this, parcel, n);
    }
}

