/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Subscription;
import com.google.android.gms.fitness.result.zzj;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ListSubscriptionsResult
extends AbstractSafeParcelable
implements Result {
    private final int mVersionCode;
    private final List<Subscription> Uo;
    private final Status fp;
    public static final Parcelable.Creator<ListSubscriptionsResult> CREATOR = new zzj();

    ListSubscriptionsResult(int n, List<Subscription> list, Status status) {
        this.mVersionCode = n;
        this.Uo = list;
        this.fp = status;
    }

    public ListSubscriptionsResult(List<Subscription> list, Status status) {
        this.mVersionCode = 3;
        this.Uo = Collections.unmodifiableList(list);
        this.fp = (Status)zzac.zzb((Object)status, (Object)"status");
    }

    public static ListSubscriptionsResult zzbd(Status status) {
        return new ListSubscriptionsResult(Collections.emptyList(), status);
    }

    public List<Subscription> getSubscriptions() {
        return this.Uo;
    }

    public List<Subscription> getSubscriptions(DataType dataType) {
        ArrayList<Subscription> arrayList = new ArrayList<Subscription>();
        for (Subscription subscription : this.Uo) {
            if (!dataType.equals((Object)subscription.zzbfl())) continue;
            arrayList.add(subscription);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public Status getStatus() {
        return this.fp;
    }

    public boolean equals(Object object) {
        return this == object || object instanceof ListSubscriptionsResult && this.zzb((ListSubscriptionsResult)((Object)object));
    }

    private boolean zzb(ListSubscriptionsResult listSubscriptionsResult) {
        return this.fp.equals((Object)listSubscriptionsResult.fp) && zzab.equal(this.Uo, listSubscriptionsResult.Uo);
    }

    public int hashCode() {
        return zzab.hashCode((Object[])new Object[]{this.fp, this.Uo});
    }

    public String toString() {
        return zzab.zzx((Object)((Object)this)).zzg("status", (Object)this.fp).zzg("subscriptions", this.Uo).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzj.zza(this, parcel, n);
    }
}

