/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.result.zze;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DataSourcesResult
extends AbstractSafeParcelable
implements Result {
    private final int versionCode;
    private final List<DataSource> Ul;
    private final Status es;
    public static final Parcelable.Creator<DataSourcesResult> CREATOR = new zze();

    DataSourcesResult(int n, List<DataSource> list, Status status) {
        this.versionCode = n;
        this.Ul = Collections.unmodifiableList(list);
        this.es = status;
    }

    public DataSourcesResult(List<DataSource> list, Status status) {
        this.versionCode = 3;
        this.Ul = Collections.unmodifiableList(list);
        this.es = status;
    }

    public static DataSourcesResult zzbb(Status status) {
        return new DataSourcesResult(Collections.emptyList(), status);
    }

    public List<DataSource> getDataSources() {
        return this.Ul;
    }

    public List<DataSource> getDataSources(DataType dataType) {
        ArrayList<DataSource> arrayList = new ArrayList<DataSource>();
        for (DataSource dataSource : this.Ul) {
            if (!dataSource.getDataType().equals((Object)dataType)) continue;
            arrayList.add(dataSource);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public Status getStatus() {
        return this.es;
    }

    public boolean equals(Object object) {
        return this == object || object instanceof DataSourcesResult && this.zzb((DataSourcesResult)((Object)object));
    }

    private boolean zzb(DataSourcesResult dataSourcesResult) {
        return this.es.equals((Object)dataSourcesResult.es) && zzab.equal(this.Ul, dataSourcesResult.Ul);
    }

    public int hashCode() {
        return zzab.hashCode((Object[])new Object[]{this.es, this.Ul});
    }

    public String toString() {
        return zzab.zzx((Object)((Object)this)).zzg("status", (Object)this.es).zzg("dataSources", this.Ul).toString();
    }

    int getVersionCode() {
        return this.versionCode;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zze.zza(this, parcel, n);
    }
}

