/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawBucket;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.result.zzc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DataReadResult
extends AbstractSafeParcelable
implements Result {
    private final int mVersionCode;
    private final List<DataSet> OZ;
    private final Status fp;
    private final List<Bucket> Ue;
    private int Uf;
    private final List<DataSource> Ug;
    private final List<DataType> Uh;
    public static final Parcelable.Creator<DataReadResult> CREATOR = new zzc();

    DataReadResult(int n, List<RawDataSet> list, Status status, List<RawBucket> list2, int n2, List<DataSource> list3, List<DataType> list4) {
        this.mVersionCode = n;
        this.fp = status;
        this.Uf = n2;
        this.Ug = list3;
        this.Uh = list4;
        this.OZ = new ArrayList<DataSet>(list.size());
        for (RawDataSet abstractSafeParcelable : list) {
            this.OZ.add(new DataSet(abstractSafeParcelable, list3));
        }
        this.Ue = new ArrayList<Bucket>(list2.size());
        for (RawBucket rawBucket : list2) {
            this.Ue.add(new Bucket(rawBucket, list3));
        }
    }

    public DataReadResult(List<DataSet> list, List<Bucket> list2, Status status) {
        this.mVersionCode = 5;
        this.OZ = list;
        this.fp = status;
        this.Ue = list2;
        this.Uf = 1;
        this.Ug = new ArrayList<DataSource>();
        this.Uh = new ArrayList<DataType>();
    }

    public static DataReadResult zza(Status status, List<DataType> list, List<DataSource> list2) {
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        for (DataSource abstractSafeParcelable : list2) {
            arrayList.add(DataSet.create(abstractSafeParcelable));
        }
        for (DataType dataType : list) {
            DataSource dataSource = new DataSource.Builder().setDataType(dataType).setType(1).setName("Default").build();
            arrayList.add(DataSet.create(dataSource));
        }
        return new DataReadResult(arrayList, Collections.emptyList(), status);
    }

    public DataSet getDataSet(DataType dataType) {
        for (DataSet dataSet : this.OZ) {
            if (!dataType.equals((Object)dataSet.getDataType())) continue;
            return dataSet;
        }
        return DataSet.create(new DataSource.Builder().setDataType(dataType).setType(1).build());
    }

    public DataSet getDataSet(DataSource dataSource) {
        for (DataSet dataSet : this.OZ) {
            if (!dataSource.equals((Object)dataSet.getDataSource())) continue;
            return dataSet;
        }
        return DataSet.create(dataSource);
    }

    public List<DataSet> getDataSets() {
        return this.OZ;
    }

    public List<Bucket> getBuckets() {
        return this.Ue;
    }

    public int zzbha() {
        return this.Uf;
    }

    public void zzb(DataReadResult dataReadResult) {
        for (DataSet abstractSafeParcelable : dataReadResult.getDataSets()) {
            this.zza(abstractSafeParcelable, this.OZ);
        }
        for (Bucket bucket : dataReadResult.getBuckets()) {
            this.zza(bucket, this.Ue);
        }
    }

    private void zza(DataSet dataSet, List<DataSet> list) {
        for (DataSet dataSet2 : list) {
            if (!dataSet2.getDataSource().equals((Object)dataSet.getDataSource())) continue;
            dataSet2.zzb(dataSet.getDataPoints());
            return;
        }
        list.add(dataSet);
    }

    private void zza(Bucket bucket, List<Bucket> list) {
        for (Bucket bucket2 : list) {
            if (!bucket2.zzb(bucket)) continue;
            for (DataSet dataSet : bucket.getDataSets()) {
                this.zza(dataSet, bucket2.getDataSets());
            }
            return;
        }
        this.Ue.add(bucket);
    }

    public Status getStatus() {
        return this.fp;
    }

    public boolean equals(Object object) {
        return this == object || object instanceof DataReadResult && this.zzc((DataReadResult)((Object)object));
    }

    private boolean zzc(DataReadResult dataReadResult) {
        return this.fp.equals((Object)dataReadResult.fp) && zzab.equal(this.OZ, dataReadResult.OZ) && zzab.equal(this.Ue, dataReadResult.Ue);
    }

    public int hashCode() {
        return zzab.hashCode((Object[])new Object[]{this.fp, this.OZ, this.Ue});
    }

    public String toString() {
        Object object;
        Object object2;
        int n;
        zzab.zza zza2 = zzab.zzx((Object)((Object)this)).zzg("status", (Object)this.fp);
        if (this.OZ.size() > 5) {
            n = this.OZ.size();
            object2 = new StringBuilder(21).append(n).append(" data sets").toString();
        } else {
            object2 = this.OZ;
        }
        zzab.zza zza3 = zza2.zzg("dataSets", object2);
        if (this.Ue.size() > 5) {
            n = this.Ue.size();
            object = new StringBuilder(19).append(n).append(" buckets").toString();
        } else {
            object = this.Ue;
        }
        return zza3.zzg("buckets", object).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    List<RawBucket> zzbhb() {
        ArrayList<RawBucket> arrayList = new ArrayList<RawBucket>(this.Ue.size());
        for (Bucket bucket : this.Ue) {
            arrayList.add(new RawBucket(bucket, this.Ug, this.Uh));
        }
        return arrayList;
    }

    List<RawDataSet> zzbhc() {
        ArrayList<RawDataSet> arrayList = new ArrayList<RawDataSet>(this.OZ.size());
        for (DataSet dataSet : this.OZ) {
            arrayList.add(new RawDataSet(dataSet, this.Ug, this.Uh));
        }
        return arrayList;
    }

    List<DataSource> zzbem() {
        return this.Ug;
    }

    List<DataType> zzbhd() {
        return this.Uh;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzc.zza(this, parcel, n);
    }
}

