/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.fitness.data.BleDevice;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.result.zza;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BleDevicesResult
extends AbstractSafeParcelable
implements Result {
    private final int mVersionCode;
    private final List<BleDevice> Ud;
    private final Status fp;
    public static final Parcelable.Creator<BleDevicesResult> CREATOR = new zza();

    BleDevicesResult(int n, List<BleDevice> list, Status status) {
        this.mVersionCode = n;
        this.Ud = Collections.unmodifiableList(list);
        this.fp = status;
    }

    public BleDevicesResult(List<BleDevice> list, Status status) {
        this.mVersionCode = 3;
        this.Ud = Collections.unmodifiableList(list);
        this.fp = status;
    }

    public static BleDevicesResult zzba(Status status) {
        return new BleDevicesResult(Collections.emptyList(), status);
    }

    public List<BleDevice> getClaimedBleDevices() {
        return this.Ud;
    }

    public List<BleDevice> getClaimedBleDevices(DataType dataType) {
        ArrayList<BleDevice> arrayList = new ArrayList<BleDevice>();
        for (BleDevice bleDevice : this.Ud) {
            if (!bleDevice.getDataTypes().contains((Object)dataType)) continue;
            arrayList.add(bleDevice);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public Status getStatus() {
        return this.fp;
    }

    public boolean equals(Object object) {
        return this == object || object instanceof BleDevicesResult && this.zzb((BleDevicesResult)((Object)object));
    }

    private boolean zzb(BleDevicesResult bleDevicesResult) {
        return this.fp.equals((Object)bleDevicesResult.fp) && zzab.equal(this.Ud, bleDevicesResult.Ud);
    }

    public int hashCode() {
        return zzab.hashCode((Object[])new Object[]{this.fp, this.Ud});
    }

    public String toString() {
        return zzab.zzx((Object)((Object)this)).zzg("status", (Object)this.fp).zzg("bleDevices", this.Ud).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zza.zza(this, parcel, n);
    }
}

