/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.util.zzb;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.BleScanCallback;
import com.google.android.gms.fitness.request.zza;
import com.google.android.gms.fitness.request.zzag;
import com.google.android.gms.fitness.request.zzs;
import com.google.android.gms.internal.zzuh;
import java.util.Collections;
import java.util.List;

public class StartBleScanRequest
extends AbstractSafeParcelable {
    private final int mVersionCode;
    private final List<DataType> OX;
    private final zzs TZ;
    private final int Ua;
    private final zzuh SP;
    public static final Parcelable.Creator<StartBleScanRequest> CREATOR = new zzag();

    StartBleScanRequest(int n, List<DataType> list, IBinder iBinder, int n2, IBinder iBinder2) {
        this.mVersionCode = n;
        this.OX = list;
        this.TZ = zzs.zza.zzgl(iBinder);
        this.Ua = n2;
        this.SP = zzuh.zza.zzgi(iBinder2);
    }

    private StartBleScanRequest(Builder builder) {
        this(zzb.zzb((Object[])builder.Tl), builder.TZ, builder.Ua, null);
    }

    public StartBleScanRequest(StartBleScanRequest startBleScanRequest, zzuh zzuh2) {
        this(startBleScanRequest.OX, startBleScanRequest.TZ, startBleScanRequest.Ua, zzuh2);
    }

    public StartBleScanRequest(List<DataType> list, zzs zzs2, int n, zzuh zzuh2) {
        this.mVersionCode = 4;
        this.OX = list;
        this.TZ = zzs2;
        this.Ua = n;
        this.SP = zzuh2;
    }

    public List<DataType> getDataTypes() {
        return Collections.unmodifiableList(this.OX);
    }

    public int getTimeoutSecs() {
        return this.Ua;
    }

    public IBinder zzbgx() {
        return this.TZ.asBinder();
    }

    public IBinder getCallbackBinder() {
        return this.SP == null ? null : this.SP.asBinder();
    }

    public String toString() {
        return zzab.zzx((Object)((Object)this)).zzg("dataTypes", this.OX).zzg("timeoutSecs", (Object)this.Ua).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzag.zza(this, parcel, n);
    }

    public static class Builder {
        private DataType[] Tl = new DataType[0];
        private zzs TZ;
        private int Ua = 10;

        public Builder setDataTypes(DataType ... dataTypeArray) {
            this.Tl = dataTypeArray;
            return this;
        }

        public Builder setBleScanCallback(BleScanCallback bleScanCallback) {
            this.zza(zza.zza.zzbfx().zza(bleScanCallback));
            return this;
        }

        public Builder zza(zzs zzs2) {
            this.TZ = zzs2;
            return this;
        }

        public Builder setTimeoutSecs(int n) {
            zzac.zzb((n > 0 ? 1 : 0) != 0, (Object)"Stop time must be greater than zero");
            zzac.zzb((n <= 60 ? 1 : 0) != 0, (Object)"Stop time must be less than 1 minute");
            this.Ua = n;
            return this;
        }

        public StartBleScanRequest build() {
            zzac.zza((this.TZ != null ? 1 : 0) != 0, (Object)"Must set BleScanCallback");
            return new StartBleScanRequest(this);
        }
    }
}

