/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.request.zzad;
import com.google.android.gms.internal.zzuh;
import java.util.concurrent.TimeUnit;

public class SessionStartRequest
extends AbstractSafeParcelable {
    private final int mVersionCode;
    private final Session OP;
    private final zzuh SP;
    public static final Parcelable.Creator<SessionStartRequest> CREATOR = new zzad();

    SessionStartRequest(int n, Session session, IBinder iBinder) {
        this.mVersionCode = n;
        this.OP = session;
        this.SP = zzuh.zza.zzgi(iBinder);
    }

    public SessionStartRequest(Session session, zzuh zzuh2) {
        zzac.zzb((session.getStartTime(TimeUnit.MILLISECONDS) < System.currentTimeMillis() ? 1 : 0) != 0, (Object)"Cannot start a session in the future");
        zzac.zzb((boolean)session.isOngoing(), (Object)"Cannot start a session which has already ended");
        this.mVersionCode = 3;
        this.OP = session;
        this.SP = zzuh2;
    }

    public Session getSession() {
        return this.OP;
    }

    public IBinder getCallbackBinder() {
        return this.SP == null ? null : this.SP.asBinder();
    }

    public boolean equals(Object object) {
        return object == this || object instanceof SessionStartRequest && this.zzb((SessionStartRequest)((Object)object));
    }

    private boolean zzb(SessionStartRequest sessionStartRequest) {
        return zzab.equal((Object)((Object)this.OP), (Object)((Object)sessionStartRequest.OP));
    }

    public int hashCode() {
        return zzab.hashCode((Object[])new Object[]{this.OP});
    }

    public String toString() {
        return zzab.zzx((Object)((Object)this)).zzg("session", (Object)this.OP).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzad.zza(this, parcel, n);
    }
}

