/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.zzab;
import com.google.android.gms.internal.zzuf;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SessionReadRequest
extends AbstractSafeParcelable {
    private final int mVersionCode;
    private final String TT;
    private final String zzcpl;
    private final long bZ;
    private final long GX;
    private final List<DataType> OX;
    private final List<DataSource> SS;
    private boolean TU;
    private final boolean Tc;
    private final List<String> TV;
    private final zzuf TW;
    public static final Parcelable.Creator<SessionReadRequest> CREATOR = new zzab();

    SessionReadRequest(int n, String string, String string2, long l, long l2, List<DataType> list, List<DataSource> list2, boolean bl, boolean bl2, List<String> list3, IBinder iBinder) {
        this.mVersionCode = n;
        this.TT = string;
        this.zzcpl = string2;
        this.bZ = l;
        this.GX = l2;
        this.OX = list;
        this.SS = list2;
        this.TU = bl;
        this.Tc = bl2;
        this.TV = list3;
        this.TW = zzuf.zza.zzgg(iBinder);
    }

    private SessionReadRequest(Builder builder) {
        this(builder.TT, builder.zzcpl, builder.bZ, builder.GX, builder.OX, builder.SS, builder.TU, builder.Tc, builder.TV, null);
    }

    public SessionReadRequest(SessionReadRequest sessionReadRequest, zzuf zzuf2) {
        this(sessionReadRequest.TT, sessionReadRequest.zzcpl, sessionReadRequest.bZ, sessionReadRequest.GX, sessionReadRequest.OX, sessionReadRequest.SS, sessionReadRequest.TU, sessionReadRequest.Tc, sessionReadRequest.TV, zzuf2);
    }

    public SessionReadRequest(String string, String string2, long l, long l2, List<DataType> list, List<DataSource> list2, boolean bl, boolean bl2, List<String> list3, zzuf zzuf2) {
        this(5, string, string2, l, l2, list, list2, bl, bl2, list3, zzuf2 == null ? null : zzuf2.asBinder());
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.bZ, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.GX, TimeUnit.MILLISECONDS);
    }

    public String getSessionName() {
        return this.TT;
    }

    public String getSessionId() {
        return this.zzcpl;
    }

    public List<DataType> getDataTypes() {
        return this.OX;
    }

    public List<DataSource> getDataSources() {
        return this.SS;
    }

    public boolean includeSessionsFromAllApps() {
        return this.TU;
    }

    public List<String> getExcludedPackages() {
        return this.TV;
    }

    public boolean zzbge() {
        return this.Tc;
    }

    public long zzbao() {
        return this.GX;
    }

    public long zzafn() {
        return this.bZ;
    }

    public boolean zzbgv() {
        return this.TU;
    }

    public IBinder getCallbackBinder() {
        return this.TW == null ? null : this.TW.asBinder();
    }

    public boolean equals(Object object) {
        return this == object || object instanceof SessionReadRequest && this.zzb((SessionReadRequest)((Object)object));
    }

    private boolean zzb(SessionReadRequest sessionReadRequest) {
        return com.google.android.gms.common.internal.zzab.equal((Object)this.TT, (Object)sessionReadRequest.TT) && this.zzcpl.equals(sessionReadRequest.zzcpl) && this.bZ == sessionReadRequest.bZ && this.GX == sessionReadRequest.GX && com.google.android.gms.common.internal.zzab.equal(this.OX, sessionReadRequest.OX) && com.google.android.gms.common.internal.zzab.equal(this.SS, sessionReadRequest.SS) && this.TU == sessionReadRequest.TU && this.TV.equals(sessionReadRequest.TV) && this.Tc == sessionReadRequest.Tc;
    }

    public int hashCode() {
        return com.google.android.gms.common.internal.zzab.hashCode((Object[])new Object[]{this.TT, this.zzcpl, this.bZ, this.GX});
    }

    public String toString() {
        return com.google.android.gms.common.internal.zzab.zzx((Object)((Object)this)).zzg("sessionName", (Object)this.TT).zzg("sessionId", (Object)this.zzcpl).zzg("startTimeMillis", (Object)this.bZ).zzg("endTimeMillis", (Object)this.GX).zzg("dataTypes", this.OX).zzg("dataSources", this.SS).zzg("sessionsFromAllApps", (Object)this.TU).zzg("excludedPackages", this.TV).zzg("useServer", (Object)this.Tc).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzab.zza(this, parcel, n);
    }

    public static class Builder {
        private String TT;
        private String zzcpl;
        private long bZ = 0L;
        private long GX = 0L;
        private List<DataType> OX = new ArrayList<DataType>();
        private List<DataSource> SS = new ArrayList<DataSource>();
        private boolean TU = false;
        private boolean Tc = false;
        private List<String> TV = new ArrayList<String>();

        public Builder setTimeInterval(long l, long l2, TimeUnit timeUnit) {
            this.bZ = timeUnit.toMillis(l);
            this.GX = timeUnit.toMillis(l2);
            return this;
        }

        public Builder setSessionName(String string) {
            this.TT = string;
            return this;
        }

        public Builder setSessionId(String string) {
            this.zzcpl = string;
            return this;
        }

        public Builder read(DataSource dataSource) {
            zzac.zzb((Object)((Object)dataSource), (Object)"Attempting to add a null data source");
            if (!this.SS.contains((Object)dataSource)) {
                this.SS.add(dataSource);
            }
            return this;
        }

        public Builder read(DataType dataType) {
            zzac.zzb((Object)((Object)dataType), (Object)"Attempting to use a null data type");
            if (!this.OX.contains((Object)dataType)) {
                this.OX.add(dataType);
            }
            return this;
        }

        public Builder readSessionsFromAllApps() {
            this.TU = true;
            return this;
        }

        public Builder excludePackage(String string) {
            zzac.zzb((Object)string, (Object)"Attempting to use a null package name");
            if (!this.TV.contains(string)) {
                this.TV.add(string);
            }
            return this;
        }

        public Builder enableServerQueries() {
            this.Tc = true;
            return this;
        }

        public SessionReadRequest build() {
            zzac.zzb((this.bZ > 0L ? 1 : 0) != 0, (String)"Invalid start time: %s", (Object[])new Object[]{this.bZ});
            zzac.zzb((this.GX > 0L && this.GX > this.bZ ? 1 : 0) != 0, (String)"Invalid end time: %s", (Object[])new Object[]{this.GX});
            return new SessionReadRequest(this);
        }
    }
}

