/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.request.zzaa;
import com.google.android.gms.internal.zzsx;
import com.google.android.gms.internal.zzuh;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SessionInsertRequest
extends AbstractSafeParcelable {
    private final int versionCode;
    private final Session TO;
    private final List<DataSet> TP;
    private final List<DataPoint> TQ;
    private final zzuh TR;
    public static final Parcelable.Creator<SessionInsertRequest> CREATOR = new zzaa();

    SessionInsertRequest(int n, Session session, List<DataSet> list, List<DataPoint> list2, IBinder iBinder) {
        this.versionCode = n;
        this.TO = session;
        this.TP = Collections.unmodifiableList(list);
        this.TQ = Collections.unmodifiableList(list2);
        this.TR = zzuh.zza.zzgi(iBinder);
    }

    private SessionInsertRequest(Builder builder) {
        this(builder.TO, builder.TP, builder.TQ, null);
    }

    public SessionInsertRequest(SessionInsertRequest sessionInsertRequest, zzuh zzuh2) {
        this(sessionInsertRequest.TO, sessionInsertRequest.TP, sessionInsertRequest.TQ, zzuh2);
    }

    public SessionInsertRequest(Session session, List<DataSet> list, List<DataPoint> list2, zzuh zzuh2) {
        this.versionCode = 3;
        this.TO = session;
        this.TP = Collections.unmodifiableList(list);
        this.TQ = Collections.unmodifiableList(list2);
        this.TR = zzuh2;
    }

    public Session getSession() {
        return this.TO;
    }

    public List<DataSet> getDataSets() {
        return this.TP;
    }

    public List<DataPoint> getAggregateDataPoints() {
        return this.TQ;
    }

    public IBinder getCallbackBinder() {
        return this.TR == null ? null : this.TR.asBinder();
    }

    public boolean equals(Object object) {
        return object == this || object instanceof SessionInsertRequest && this.zzb((SessionInsertRequest)((Object)object));
    }

    private boolean zzb(SessionInsertRequest sessionInsertRequest) {
        return zzab.equal((Object)((Object)this.TO), (Object)((Object)sessionInsertRequest.TO)) && zzab.equal(this.TP, sessionInsertRequest.TP) && zzab.equal(this.TQ, sessionInsertRequest.TQ);
    }

    public int hashCode() {
        return zzab.hashCode((Object[])new Object[]{this.TO, this.TP, this.TQ});
    }

    public String toString() {
        return zzab.zzx((Object)((Object)this)).zzg("session", (Object)this.TO).zzg("dataSets", this.TP).zzg("aggregateDataPoints", this.TQ).toString();
    }

    int getVersionCode() {
        return this.versionCode;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzaa.zza(this, parcel, n);
    }

    public static class Builder {
        private Session TO;
        private List<DataSet> TP = new ArrayList<DataSet>();
        private List<DataPoint> TQ = new ArrayList<DataPoint>();
        private List<DataSource> TS = new ArrayList<DataSource>();

        public Builder setSession(Session session) {
            this.TO = session;
            return this;
        }

        public Builder addDataSet(DataSet dataSet) {
            zzac.zzb((dataSet != null ? 1 : 0) != 0, (Object)"Must specify a valid data set.");
            DataSource dataSource = dataSet.getDataSource();
            zzac.zza((!this.TS.contains((Object)dataSource) ? 1 : 0) != 0, (String)"Data set for this data source %s is already added.", (Object[])new Object[]{dataSource});
            List<DataPoint> list = dataSet.getDataPoints();
            zzac.zzb((!list.isEmpty() ? 1 : 0) != 0, (Object)"No data points specified in the input data set.");
            this.TS.add(dataSource);
            this.TP.add(dataSet);
            return this;
        }

        public Builder addAggregateDataPoint(DataPoint dataPoint) {
            zzac.zzb((dataPoint != null ? 1 : 0) != 0, (Object)"Must specify a valid aggregate data point.");
            DataSource dataSource = dataPoint.getDataSource();
            zzac.zza((!this.TS.contains((Object)dataSource) ? 1 : 0) != 0, (String)"Data set/Aggregate data point for this data source %s is already added.", (Object[])new Object[]{dataSource});
            DataSet.zze(dataPoint);
            this.TS.add(dataSource);
            this.TQ.add(dataPoint);
            return this;
        }

        public SessionInsertRequest build() {
            zzac.zza((this.TO != null ? 1 : 0) != 0, (Object)"Must specify a valid session.");
            zzac.zza((this.TO.getEndTime(TimeUnit.MILLISECONDS) != 0L ? 1 : 0) != 0, (Object)"Must specify a valid end time, cannot insert a continuing session.");
            this.zzbgu();
            return new SessionInsertRequest(this);
        }

        private void zzg(DataPoint dataPoint) {
            this.zzi(dataPoint);
            this.zzh(dataPoint);
        }

        private void zzh(DataPoint dataPoint) {
            long l = this.TO.getStartTime(TimeUnit.NANOSECONDS);
            long l2 = this.TO.getEndTime(TimeUnit.NANOSECONDS);
            long l3 = dataPoint.getStartTime(TimeUnit.NANOSECONDS);
            long l4 = dataPoint.getEndTime(TimeUnit.NANOSECONDS);
            if (l3 != 0L && l4 != 0L) {
                TimeUnit timeUnit = TimeUnit.MILLISECONDS;
                if (l4 > l2) {
                    l4 = zzsx.zza(l4, TimeUnit.NANOSECONDS, timeUnit);
                }
                zzac.zza((l3 >= l && l4 <= l2 ? 1 : 0) != 0, (String)"Data point %s has start and end times outside session interval [%d, %d]", (Object[])new Object[]{dataPoint, l, l2});
                if (l4 != dataPoint.getEndTime(TimeUnit.NANOSECONDS)) {
                    Log.w((String)"Fitness", (String)String.format("Data point end time [%d] is truncated to [%d] to match the precision [%s] of the session start and end time", new Object[]{dataPoint.getEndTime(TimeUnit.NANOSECONDS), l4, timeUnit}));
                    dataPoint.setTimeInterval(l3, l4, TimeUnit.NANOSECONDS);
                }
            }
        }

        private void zzi(DataPoint dataPoint) {
            long l = this.TO.getStartTime(TimeUnit.NANOSECONDS);
            long l2 = this.TO.getEndTime(TimeUnit.NANOSECONDS);
            long l3 = dataPoint.getTimestamp(TimeUnit.NANOSECONDS);
            if (l3 != 0L) {
                TimeUnit timeUnit = TimeUnit.MILLISECONDS;
                if (l3 < l || l3 > l2) {
                    l3 = zzsx.zza(l3, TimeUnit.NANOSECONDS, timeUnit);
                }
                zzac.zza((l3 >= l && l3 <= l2 ? 1 : 0) != 0, (String)"Data point %s has time stamp outside session interval [%d, %d]", (Object[])new Object[]{dataPoint, l, l2});
                if (dataPoint.getTimestamp(TimeUnit.NANOSECONDS) != l3) {
                    Log.w((String)"Fitness", (String)String.format("Data point timestamp [%d] is truncated to [%d] to match the precision [%s] of the session start and end time", new Object[]{dataPoint.getTimestamp(TimeUnit.NANOSECONDS), l3, timeUnit}));
                    dataPoint.setTimestamp(l3, TimeUnit.NANOSECONDS);
                }
            }
        }

        private void zzbgu() {
            for (DataSet abstractSafeParcelable : this.TP) {
                for (DataPoint dataPoint : abstractSafeParcelable.getDataPoints()) {
                    this.zzg(dataPoint);
                }
            }
            for (DataPoint dataPoint : this.TQ) {
                this.zzg(dataPoint);
            }
        }
    }
}

