/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.SystemClock;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.internal.zztb;
import com.google.android.gms.location.LocationRequest;
import java.util.concurrent.TimeUnit;

public class SensorRequest {
    public static final int ACCURACY_MODE_LOW = 1;
    public static final int ACCURACY_MODE_DEFAULT = 2;
    public static final int ACCURACY_MODE_HIGH = 3;
    private final DataSource ON;
    private final DataType OM;
    private final long RH;
    private final long TH;
    private final long TG;
    private final int RI;
    private final LocationRequest TL;
    private final long TM;

    private SensorRequest(Builder builder) {
        this.ON = builder.ON;
        this.OM = builder.OM;
        this.RH = builder.RH;
        this.TH = builder.TH;
        this.TG = builder.TG;
        this.RI = builder.RI;
        this.TL = null;
        this.TM = builder.TM;
    }

    private SensorRequest(DataSource dataSource, LocationRequest locationRequest) {
        this.TL = locationRequest;
        this.RH = TimeUnit.MILLISECONDS.toMicros(locationRequest.getInterval());
        this.TH = TimeUnit.MILLISECONDS.toMicros(locationRequest.getFastestInterval());
        this.TG = this.RH;
        this.OM = dataSource.getDataType();
        this.RI = SensorRequest.zza(locationRequest);
        this.ON = dataSource;
        long l = locationRequest.getExpirationTime();
        this.TM = l == Long.MAX_VALUE ? Long.MAX_VALUE : TimeUnit.MILLISECONDS.toMicros(l - SystemClock.elapsedRealtime());
    }

    public static SensorRequest fromLocationRequest(DataSource dataSource, LocationRequest locationRequest) {
        return new SensorRequest(dataSource, locationRequest);
    }

    private static int zza(LocationRequest locationRequest) {
        switch (locationRequest.getPriority()) {
            case 100: {
                return 3;
            }
            case 104: {
                return 1;
            }
        }
        return 2;
    }

    public DataSource getDataSource() {
        return this.ON;
    }

    public DataType getDataType() {
        return this.OM;
    }

    public long getSamplingRate(TimeUnit timeUnit) {
        return timeUnit.convert(this.RH, TimeUnit.MICROSECONDS);
    }

    public long getFastestRate(TimeUnit timeUnit) {
        return timeUnit.convert(this.TH, TimeUnit.MICROSECONDS);
    }

    public long getMaxDeliveryLatency(TimeUnit timeUnit) {
        return timeUnit.convert(this.TG, TimeUnit.MICROSECONDS);
    }

    public int getAccuracyMode() {
        return this.RI;
    }

    public long zzbgt() {
        return this.TM;
    }

    public String toString() {
        return zzab.zzx((Object)this).zzg("dataSource", (Object)this.ON).zzg("dataType", (Object)this.OM).zzg("samplingRateMicros", (Object)this.RH).zzg("deliveryLatencyMicros", (Object)this.TG).zzg("timeOutMicros", (Object)this.TM).toString();
    }

    public boolean equals(Object object) {
        return this == object || object instanceof SensorRequest && this.zza((SensorRequest)object);
    }

    private boolean zza(SensorRequest sensorRequest) {
        return zzab.equal((Object)((Object)this.ON), (Object)((Object)sensorRequest.ON)) && zzab.equal((Object)((Object)this.OM), (Object)((Object)sensorRequest.OM)) && this.RH == sensorRequest.RH && this.TH == sensorRequest.TH && this.TG == sensorRequest.TG && this.RI == sensorRequest.RI && zzab.equal((Object)this.TL, (Object)sensorRequest.TL) && this.TM == sensorRequest.TM;
    }

    public int hashCode() {
        return zzab.hashCode((Object[])new Object[]{this.ON, this.OM, this.RH, this.TH, this.TG, this.RI, this.TL, this.TM});
    }

    public static class Builder {
        private DataSource ON;
        private DataType OM;
        private long RH = -1L;
        private long TH = 0L;
        private long TG = 0L;
        private boolean TN = false;
        private int RI = 2;
        private long TM = Long.MAX_VALUE;

        public Builder setDataSource(DataSource dataSource) {
            this.ON = dataSource;
            return this;
        }

        public Builder setDataType(DataType dataType) {
            this.OM = dataType;
            return this;
        }

        public Builder setSamplingRate(long l, TimeUnit timeUnit) {
            zzac.zzb((l >= 0L ? 1 : 0) != 0, (Object)"Cannot use a negative sampling interval");
            this.RH = timeUnit.toMicros(l);
            if (!this.TN) {
                this.TH = this.RH / 2L;
            }
            return this;
        }

        public Builder setFastestRate(int n, TimeUnit timeUnit) {
            zzac.zzb((n >= 0 ? 1 : 0) != 0, (Object)"Cannot use a negative interval");
            this.TN = true;
            this.TH = timeUnit.toMicros(n);
            return this;
        }

        public Builder setMaxDeliveryLatency(int n, TimeUnit timeUnit) {
            zzac.zzb((n >= 0 ? 1 : 0) != 0, (Object)"Cannot use a negative delivery interval");
            this.TG = timeUnit.toMicros(n);
            return this;
        }

        public Builder setAccuracyMode(int n) {
            this.RI = zztb.zzou(n);
            return this;
        }

        public Builder setTimeout(long l, TimeUnit timeUnit) {
            zzac.zzb((l > 0L ? 1 : 0) != 0, (String)"Invalid time out value specified: %d", (Object[])new Object[]{l});
            zzac.zzb((timeUnit != null ? 1 : 0) != 0, (Object)"Invalid time unit specified");
            this.TM = timeUnit.toMicros(l);
            return this;
        }

        public SensorRequest build() {
            zzac.zza((this.ON != null || this.OM != null ? 1 : 0) != 0, (Object)"Must call setDataSource() or setDataType()");
            zzac.zza((this.OM == null || this.ON == null || this.OM.equals((Object)this.ON.getDataType()) ? 1 : 0) != 0, (Object)"Specified data type is incompatible with specified data source");
            return new SensorRequest(this);
        }
    }
}

