/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.app.PendingIntent;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.zzt;
import com.google.android.gms.fitness.request.SensorRequest;
import com.google.android.gms.fitness.request.zzy;
import com.google.android.gms.internal.zzuh;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.internal.ClientIdentity;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SensorRegistrationRequest
extends AbstractSafeParcelable {
    private final int mVersionCode;
    private DataSource ON;
    private DataType OM;
    private zzt TD;
    int TE;
    int TF;
    private final long RH;
    private final long TG;
    private final PendingIntent mPendingIntent;
    private final long TH;
    private final int RI;
    private final List<LocationRequest> TI;
    private final long TJ;
    private final List<ClientIdentity> TK;
    private final zzuh SP;
    public static final Parcelable.Creator<SensorRegistrationRequest> CREATOR = new zzy();

    SensorRegistrationRequest(int n, DataSource dataSource, DataType dataType, IBinder iBinder, int n2, int n3, long l, long l2, PendingIntent pendingIntent, long l3, int n4, List<LocationRequest> list, long l4, IBinder iBinder2) {
        this.mVersionCode = n;
        this.ON = dataSource;
        this.OM = dataType;
        this.TD = iBinder == null ? null : zzt.zza.zzfg(iBinder);
        this.RH = l == 0L ? (long)n2 : l;
        this.TH = l3;
        this.TG = l2 == 0L ? (long)n3 : l2;
        this.TI = list;
        this.mPendingIntent = pendingIntent;
        this.RI = n4;
        this.TK = Collections.emptyList();
        this.TJ = l4;
        this.SP = zzuh.zza.zzgi(iBinder2);
    }

    public SensorRegistrationRequest(SensorRequest sensorRequest, zzt zzt2, PendingIntent pendingIntent, zzuh zzuh2) {
        this(sensorRequest.getDataSource(), sensorRequest.getDataType(), zzt2, pendingIntent, sensorRequest.getSamplingRate(TimeUnit.MICROSECONDS), sensorRequest.getFastestRate(TimeUnit.MICROSECONDS), sensorRequest.getMaxDeliveryLatency(TimeUnit.MICROSECONDS), sensorRequest.getAccuracyMode(), null, Collections.emptyList(), sensorRequest.zzbgt(), zzuh2);
    }

    public SensorRegistrationRequest(DataSource dataSource, DataType dataType, zzt zzt2, PendingIntent pendingIntent, long l, long l2, long l3, int n, List<LocationRequest> list, List<ClientIdentity> list2, long l4, zzuh zzuh2) {
        this.mVersionCode = 6;
        this.ON = dataSource;
        this.OM = dataType;
        this.TD = zzt2;
        this.mPendingIntent = pendingIntent;
        this.RH = l;
        this.TH = l2;
        this.TG = l3;
        this.RI = n;
        this.TI = list;
        this.TK = list2;
        this.TJ = l4;
        this.SP = zzuh2;
    }

    public DataSource getDataSource() {
        return this.ON;
    }

    public DataType getDataType() {
        return this.OM;
    }

    public PendingIntent getIntent() {
        return this.mPendingIntent;
    }

    public long zzbgo() {
        return this.TH;
    }

    public long zzbfk() {
        return this.RH;
    }

    public long zzbgp() {
        return this.TG;
    }

    public List<LocationRequest> zzbgq() {
        return this.TI;
    }

    public int getAccuracyMode() {
        return this.RI;
    }

    public long zzbgr() {
        return this.TJ;
    }

    public IBinder getCallbackBinder() {
        return this.SP == null ? null : this.SP.asBinder();
    }

    public String toString() {
        return String.format("SensorRegistrationRequest{type %s source %s interval %s fastest %s latency %s}", new Object[]{this.OM, this.ON, this.RH, this.TH, this.TG});
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    IBinder zzbgs() {
        return this.TD == null ? null : this.TD.asBinder();
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzy.zza(this, parcel, n);
    }

    public boolean equals(Object object) {
        return this == object || object instanceof SensorRegistrationRequest && this.zzb((SensorRegistrationRequest)((Object)object));
    }

    private boolean zzb(SensorRegistrationRequest sensorRegistrationRequest) {
        return zzab.equal((Object)((Object)this.ON), (Object)((Object)sensorRegistrationRequest.ON)) && zzab.equal((Object)((Object)this.OM), (Object)((Object)sensorRegistrationRequest.OM)) && this.RH == sensorRegistrationRequest.RH && this.TH == sensorRegistrationRequest.TH && this.TG == sensorRegistrationRequest.TG && this.RI == sensorRegistrationRequest.RI && zzab.equal(this.TI, sensorRegistrationRequest.TI);
    }

    public int hashCode() {
        return zzab.hashCode((Object[])new Object[]{this.ON, this.OM, this.TD, this.RH, this.TH, this.TG, this.RI, this.TI});
    }
}

