/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.request.zzm;
import com.google.android.gms.internal.zzuh;
import java.util.concurrent.TimeUnit;

public class DataUpdateRequest
extends AbstractSafeParcelable {
    private final int mVersionCode;
    private final long bZ;
    private final long GX;
    private final DataSet RG;
    private final zzuh SP;
    public static final Parcelable.Creator<DataUpdateRequest> CREATOR = new zzm();

    DataUpdateRequest(int n, long l, long l2, DataSet dataSet, IBinder iBinder) {
        this.mVersionCode = n;
        this.bZ = l;
        this.GX = l2;
        this.RG = dataSet;
        this.SP = zzuh.zza.zzgi(iBinder);
    }

    private DataUpdateRequest(Builder builder) {
        this(builder.bZ, builder.GX, builder.RG, null);
    }

    public DataUpdateRequest(long l, long l2, DataSet dataSet, IBinder iBinder) {
        this.mVersionCode = 1;
        this.bZ = l;
        this.GX = l2;
        this.RG = dataSet;
        this.SP = zzuh.zza.zzgi(iBinder);
    }

    public DataUpdateRequest(DataUpdateRequest dataUpdateRequest, IBinder iBinder) {
        this(dataUpdateRequest.zzafn(), dataUpdateRequest.zzbao(), dataUpdateRequest.getDataSet(), iBinder);
    }

    public long zzafn() {
        return this.bZ;
    }

    public long zzbao() {
        return this.GX;
    }

    public DataSet getDataSet() {
        return this.RG;
    }

    public IBinder getCallbackBinder() {
        return this.SP == null ? null : this.SP.asBinder();
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.bZ, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.GX, TimeUnit.MILLISECONDS);
    }

    public boolean equals(Object object) {
        return object == this || object instanceof DataUpdateRequest && this.zzb((DataUpdateRequest)((Object)object));
    }

    private boolean zzb(DataUpdateRequest dataUpdateRequest) {
        return this.bZ == dataUpdateRequest.bZ && this.GX == dataUpdateRequest.GX && zzab.equal((Object)((Object)this.RG), (Object)((Object)dataUpdateRequest.RG));
    }

    public int hashCode() {
        return zzab.hashCode((Object[])new Object[]{this.bZ, this.GX, this.RG});
    }

    public String toString() {
        return zzab.zzx((Object)((Object)this)).zzg("startTimeMillis", (Object)this.bZ).zzg("endTimeMillis", (Object)this.GX).zzg("dataSet", (Object)this.RG).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzm.zza(this, parcel, n);
    }

    public static class Builder {
        private long bZ;
        private long GX;
        private DataSet RG;

        public Builder setTimeInterval(long l, long l2, TimeUnit timeUnit) {
            zzac.zzb((l > 0L ? 1 : 0) != 0, (String)"Invalid start time :%d", (Object[])new Object[]{l});
            zzac.zzb((l2 >= l ? 1 : 0) != 0, (String)"Invalid end time :%d", (Object[])new Object[]{l2});
            this.bZ = timeUnit.toMillis(l);
            this.GX = timeUnit.toMillis(l2);
            return this;
        }

        public Builder setDataSet(DataSet dataSet) {
            zzac.zzb((Object)((Object)dataSet), (Object)"Must set the data set");
            this.RG = dataSet;
            return this;
        }

        public DataUpdateRequest build() {
            this.zzbgl();
            return new DataUpdateRequest(this);
        }

        private void zzbgl() {
            zzac.zza((long)this.bZ, (Object)"Must set a non-zero value for startTimeMillis/startTime");
            zzac.zza((long)this.GX, (Object)"Must set a non-zero value for endTimeMillis/endTime");
            zzac.zzb((Object)((Object)this.RG), (Object)"Must set the data set");
            for (DataPoint dataPoint : this.RG.getDataPoints()) {
                long l;
                long l2 = dataPoint.getStartTime(TimeUnit.MILLISECONDS);
                boolean bl = l2 > (l = dataPoint.getEndTime(TimeUnit.MILLISECONDS)) || l2 != 0L && l2 < this.bZ || l2 != 0L && l2 > this.GX || l > this.GX || l < this.bZ;
                zzac.zza((!bl ? 1 : 0) != 0, (String)"Data Point's startTimeMillis %d, endTimeMillis %d should lie between timeRange provided in the request. StartTimeMillis %d, EndTimeMillis: %d", (Object[])new Object[]{l2, l, this.bZ, this.GX});
            }
        }
    }
}

