/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.fitness.data.Field;
import com.google.android.gms.fitness.request.zzi;
import com.google.android.gms.internal.zztr;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DataTypeCreateRequest
extends AbstractSafeParcelable {
    private final int mVersionCode;
    private final String mName;
    private final List<Field> Tn;
    private final zztr To;
    public static final Parcelable.Creator<DataTypeCreateRequest> CREATOR = new zzi();

    DataTypeCreateRequest(int n, String string, List<Field> list, IBinder iBinder) {
        this.mVersionCode = n;
        this.mName = string;
        this.Tn = Collections.unmodifiableList(list);
        this.To = zztr.zza.zzfs(iBinder);
    }

    private DataTypeCreateRequest(Builder builder) {
        this(builder.mName, builder.Tn, null);
    }

    public DataTypeCreateRequest(DataTypeCreateRequest dataTypeCreateRequest, zztr zztr2) {
        this(dataTypeCreateRequest.mName, dataTypeCreateRequest.Tn, zztr2);
    }

    public DataTypeCreateRequest(String string, List<Field> list, zztr zztr2) {
        this.mVersionCode = 3;
        this.mName = string;
        this.Tn = Collections.unmodifiableList(list);
        this.To = zztr2;
    }

    public String getName() {
        return this.mName;
    }

    public List<Field> getFields() {
        return this.Tn;
    }

    public IBinder getCallbackBinder() {
        return this.To == null ? null : this.To.asBinder();
    }

    public boolean equals(Object object) {
        return object == this || object instanceof DataTypeCreateRequest && this.zzb((DataTypeCreateRequest)((Object)object));
    }

    private boolean zzb(DataTypeCreateRequest dataTypeCreateRequest) {
        return zzab.equal((Object)this.mName, (Object)dataTypeCreateRequest.mName) && zzab.equal(this.Tn, dataTypeCreateRequest.Tn);
    }

    public int hashCode() {
        return zzab.hashCode((Object[])new Object[]{this.mName, this.Tn});
    }

    public String toString() {
        return zzab.zzx((Object)((Object)this)).zzg("name", (Object)this.mName).zzg("fields", this.Tn).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzi.zza(this, parcel, n);
    }

    public static class Builder {
        private String mName;
        private List<Field> Tn = new ArrayList<Field>();

        public Builder setName(String string) {
            this.mName = string;
            return this;
        }

        public Builder addField(Field field) {
            if (!this.Tn.contains((Object)field)) {
                this.Tn.add(field);
            }
            return this;
        }

        public Builder addField(String string, int n) {
            zzac.zzb((string != null && !string.isEmpty() ? 1 : 0) != 0, (Object)"Invalid name specified");
            Field field = Field.zzn(string, n);
            return this.addField(field);
        }

        public DataTypeCreateRequest build() {
            zzac.zza((this.mName != null ? 1 : 0) != 0, (Object)"Must set the name");
            zzac.zza((!this.Tn.isEmpty() ? 1 : 0) != 0, (Object)"Must specify the data fields");
            return new DataTypeCreateRequest(this);
        }
    }
}

