/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Device;
import com.google.android.gms.fitness.request.zzf;
import com.google.android.gms.internal.zztp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DataReadRequest
extends AbstractSafeParcelable {
    public static final int NO_LIMIT = 0;
    private final int mVersionCode;
    private final List<DataType> OX;
    private final List<DataSource> SS;
    private final long bZ;
    private final long GX;
    private final List<DataType> SX;
    private final List<DataSource> SY;
    private final int Pa;
    private final long SZ;
    private final DataSource Ta;
    private final int GT;
    private final boolean Tb;
    private final boolean Tc;
    private final zztp Td;
    private final List<Device> Te;
    private final List<Integer> Tf;
    public static final Parcelable.Creator<DataReadRequest> CREATOR = new zzf();

    DataReadRequest(int n, List<DataType> list, List<DataSource> list2, long l, long l2, List<DataType> list3, List<DataSource> list4, int n2, long l3, DataSource dataSource, int n3, boolean bl, boolean bl2, IBinder iBinder, List<Device> list5, List<Integer> list6) {
        this.mVersionCode = n;
        this.OX = list;
        this.SS = list2;
        this.bZ = l;
        this.GX = l2;
        this.SX = list3;
        this.SY = list4;
        this.Pa = n2;
        this.SZ = l3;
        this.Ta = dataSource;
        this.GT = n3;
        this.Tb = bl;
        this.Tc = bl2;
        this.Td = iBinder == null ? null : zztp.zza.zzfq(iBinder);
        this.Te = list5 == null ? Collections.emptyList() : list5;
        this.Tf = list6 == null ? Collections.emptyList() : list6;
    }

    private DataReadRequest(Builder builder) {
        this(builder.OX, builder.SS, builder.bZ, builder.GX, builder.SX, builder.SY, builder.Pa, builder.SZ, builder.Ta, builder.GT, Builder.zzk(builder), builder.Tc, null, builder.Te, builder.Tf);
    }

    public DataReadRequest(DataReadRequest dataReadRequest, zztp zztp2) {
        this(dataReadRequest.OX, dataReadRequest.SS, dataReadRequest.bZ, dataReadRequest.GX, dataReadRequest.SX, dataReadRequest.SY, dataReadRequest.Pa, dataReadRequest.SZ, dataReadRequest.Ta, dataReadRequest.GT, dataReadRequest.Tb, dataReadRequest.Tc, zztp2, dataReadRequest.Te, dataReadRequest.Tf);
    }

    public DataReadRequest(List<DataType> list, List<DataSource> list2, long l, long l2, List<DataType> list3, List<DataSource> list4, int n, long l3, DataSource dataSource, int n2, boolean bl, boolean bl2, zztp zztp2, List<Device> list5, List<Integer> list6) {
        this(6, list, list2, l, l2, list3, list4, n, l3, dataSource, n2, bl, bl2, zztp2 == null ? null : zztp2.asBinder(), list5, list6);
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.bZ, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.GX, TimeUnit.MILLISECONDS);
    }

    public List<DataType> getDataTypes() {
        return this.OX;
    }

    public List<DataSource> getDataSources() {
        return this.SS;
    }

    public List<DataType> getAggregatedDataTypes() {
        return this.SX;
    }

    public List<DataSource> getAggregatedDataSources() {
        return this.SY;
    }

    public int getBucketType() {
        return this.Pa;
    }

    public long getBucketDuration(TimeUnit timeUnit) {
        return timeUnit.convert(this.SZ, TimeUnit.MILLISECONDS);
    }

    public DataSource getActivityDataSource() {
        return this.Ta;
    }

    public int getLimit() {
        return this.GT;
    }

    public boolean zzbge() {
        return this.Tc;
    }

    public boolean zzbgf() {
        return this.Tb;
    }

    public boolean equals(Object object) {
        return this == object || object instanceof DataReadRequest && this.zzb((DataReadRequest)((Object)object));
    }

    private boolean zzb(DataReadRequest dataReadRequest) {
        return this.OX.equals(dataReadRequest.OX) && this.SS.equals(dataReadRequest.SS) && this.bZ == dataReadRequest.bZ && this.GX == dataReadRequest.GX && this.Pa == dataReadRequest.Pa && this.SY.equals(dataReadRequest.SY) && this.SX.equals(dataReadRequest.SX) && zzab.equal((Object)((Object)this.Ta), (Object)((Object)dataReadRequest.Ta)) && this.SZ == dataReadRequest.SZ && this.Tc == dataReadRequest.Tc && this.GT == dataReadRequest.GT && this.Tb == dataReadRequest.Tb && zzab.equal((Object)this.Td, (Object)dataReadRequest.Td) && zzab.equal(this.Te, dataReadRequest.Te) && zzab.equal(this.Tf, dataReadRequest.Tf);
    }

    public int hashCode() {
        return zzab.hashCode((Object[])new Object[]{this.Pa, this.bZ, this.GX});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DataReadRequest{");
        if (!this.OX.isEmpty()) {
            for (DataType abstractSafeParcelable : this.OX) {
                stringBuilder.append(abstractSafeParcelable.zzbeq()).append(" ");
            }
        }
        if (!this.SS.isEmpty()) {
            for (DataSource dataSource : this.SS) {
                stringBuilder.append(dataSource.toDebugString()).append(" ");
            }
        }
        if (this.Pa != 0) {
            stringBuilder.append("bucket by ").append(Bucket.zznr(this.Pa));
            if (this.SZ > 0L) {
                stringBuilder.append(" >").append(this.SZ).append("ms");
            }
            stringBuilder.append(": ");
        }
        if (!this.SX.isEmpty()) {
            for (DataType dataType : this.SX) {
                stringBuilder.append(dataType.zzbeq()).append(" ");
            }
        }
        if (!this.SY.isEmpty()) {
            for (DataSource dataSource : this.SY) {
                stringBuilder.append(dataSource.toDebugString()).append(" ");
            }
        }
        stringBuilder.append(String.format("(%tF %tT - %tF %tT)", this.bZ, this.bZ, this.GX, this.GX));
        if (this.Ta != null) {
            stringBuilder.append("activities: ").append(this.Ta.toDebugString());
        }
        if (!this.Tf.isEmpty()) {
            stringBuilder.append("quality: ");
            Iterator<Object> iterator = this.Tf.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                stringBuilder.append(DataSource.zzny(n)).append(" ");
            }
        }
        if (this.Tc) {
            stringBuilder.append(" +server");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public long zzbao() {
        return this.GX;
    }

    public long zzafn() {
        return this.bZ;
    }

    public long zzbgg() {
        return this.SZ;
    }

    public IBinder getCallbackBinder() {
        return this.Td == null ? null : this.Td.asBinder();
    }

    public List<Device> zzbgh() {
        return this.Te;
    }

    public List<Integer> zzbgi() {
        return this.Tf;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzf.zza(this, parcel, n);
    }

    public static class Builder {
        private List<DataType> OX = new ArrayList<DataType>();
        private List<DataSource> SS = new ArrayList<DataSource>();
        private List<DataType> SX = new ArrayList<DataType>();
        private List<DataSource> SY = new ArrayList<DataSource>();
        private DataSource Ta;
        private long bZ;
        private long GX;
        private int Pa = 0;
        private long SZ = 0L;
        private int GT = 0;
        private boolean Tb = false;
        private boolean Tc = false;
        private final List<Device> Te = new ArrayList<Device>();
        private final List<Integer> Tf = new ArrayList<Integer>();

        public Builder read(DataSource dataSource) {
            zzac.zzb((Object)((Object)dataSource), (Object)"Attempting to add a null data source");
            zzac.zzb((!this.SY.contains((Object)dataSource) ? 1 : 0) != 0, (Object)"Cannot add the same data source as aggregated and detailed");
            if (!this.SS.contains((Object)dataSource)) {
                this.SS.add(dataSource);
            }
            return this;
        }

        public Builder read(DataType dataType) {
            zzac.zzb((Object)((Object)dataType), (Object)"Attempting to use a null data type");
            zzac.zza((!this.SX.contains((Object)dataType) ? 1 : 0) != 0, (Object)"Cannot add the same data type as aggregated and detailed");
            if (!this.OX.contains((Object)dataType)) {
                this.OX.add(dataType);
            }
            return this;
        }

        public Builder aggregate(DataSource dataSource, DataType dataType) {
            zzac.zzb((Object)((Object)dataSource), (Object)"Attempting to add a null data source");
            zzac.zza((!this.SS.contains((Object)dataSource) ? 1 : 0) != 0, (Object)"Cannot add the same data source for aggregated and detailed");
            DataType dataType2 = dataSource.getDataType();
            zzac.zzb((boolean)DataType.AGGREGATE_INPUT_TYPES.contains((Object)dataType2), (String)"Unsupported input data type specified for aggregation: %s", (Object[])new Object[]{dataType2});
            zzac.zzb((boolean)DataType.getAggregatesForInput(dataType2).contains((Object)dataType), (String)"Invalid output aggregate data type specified: %s -> %s", (Object[])new Object[]{dataType2, dataType});
            if (!this.SY.contains((Object)dataSource)) {
                this.SY.add(dataSource);
            }
            return this;
        }

        public Builder aggregate(DataType dataType, DataType dataType2) {
            zzac.zzb((Object)((Object)dataType), (Object)"Attempting to use a null data type");
            zzac.zza((!this.OX.contains((Object)dataType) ? 1 : 0) != 0, (Object)"Cannot add the same data type as aggregated and detailed");
            zzac.zzb((boolean)DataType.AGGREGATE_INPUT_TYPES.contains((Object)dataType), (String)"Unsupported input data type specified for aggregation: %s", (Object[])new Object[]{dataType});
            zzac.zzb((boolean)DataType.getAggregatesForInput(dataType).contains((Object)dataType2), (String)"Invalid output aggregate data type specified: %s -> %s", (Object[])new Object[]{dataType, dataType2});
            if (!this.SX.contains((Object)dataType)) {
                this.SX.add(dataType);
            }
            return this;
        }

        public Builder bucketByTime(int n, TimeUnit timeUnit) {
            zzac.zzb((this.Pa == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.Pa});
            zzac.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            this.Pa = 1;
            this.SZ = timeUnit.toMillis(n);
            return this;
        }

        public Builder bucketByActivityType(int n, TimeUnit timeUnit) {
            zzac.zzb((this.Pa == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.Pa});
            zzac.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            this.Pa = 3;
            this.SZ = timeUnit.toMillis(n);
            return this;
        }

        public Builder bucketByActivityType(int n, TimeUnit timeUnit, DataSource dataSource) {
            zzac.zzb((this.Pa == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.Pa});
            zzac.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            zzac.zzb((dataSource != null ? 1 : 0) != 0, (Object)"Invalid activity data source specified");
            zzac.zzb((boolean)dataSource.getDataType().equals((Object)DataType.TYPE_ACTIVITY_SEGMENT), (String)"Invalid activity data source specified: %s", (Object[])new Object[]{dataSource});
            this.Ta = dataSource;
            this.Pa = 3;
            this.SZ = timeUnit.toMillis(n);
            return this;
        }

        public Builder bucketByActivitySegment(int n, TimeUnit timeUnit) {
            zzac.zzb((this.Pa == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.Pa});
            zzac.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            this.Pa = 4;
            this.SZ = timeUnit.toMillis(n);
            return this;
        }

        public Builder bucketByActivitySegment(int n, TimeUnit timeUnit, DataSource dataSource) {
            zzac.zzb((this.Pa == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.Pa});
            zzac.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            zzac.zzb((dataSource != null ? 1 : 0) != 0, (Object)"Invalid activity data source specified");
            zzac.zzb((boolean)dataSource.getDataType().equals((Object)DataType.TYPE_ACTIVITY_SEGMENT), (String)"Invalid activity data source specified: %s", (Object[])new Object[]{dataSource});
            this.Ta = dataSource;
            this.Pa = 4;
            this.SZ = timeUnit.toMillis(n);
            return this;
        }

        public Builder bucketBySession(int n, TimeUnit timeUnit) {
            zzac.zzb((this.Pa == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.Pa});
            zzac.zzb((n > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{n});
            this.Pa = 2;
            this.SZ = timeUnit.toMillis(n);
            return this;
        }

        public Builder setTimeRange(long l, long l2, TimeUnit timeUnit) {
            this.bZ = timeUnit.toMillis(l);
            this.GX = timeUnit.toMillis(l2);
            return this;
        }

        public Builder enableServerQueries() {
            this.Tc = true;
            return this;
        }

        public Builder setLimit(int n) {
            zzac.zzb((n > 0 ? 1 : 0) != 0, (String)"Invalid limit %d is specified", (Object[])new Object[]{n});
            this.GT = n;
            return this;
        }

        public DataReadRequest build() {
            zzac.zza((!this.SS.isEmpty() || !this.OX.isEmpty() || !this.SY.isEmpty() || !this.SX.isEmpty() ? 1 : 0) != 0, (Object)"Must add at least one data source (aggregated or detailed)");
            zzac.zza((this.bZ > 0L ? 1 : 0) != 0, (String)"Invalid start time: %s", (Object[])new Object[]{this.bZ});
            zzac.zza((this.GX > 0L && this.GX > this.bZ ? 1 : 0) != 0, (String)"Invalid end time: %s", (Object[])new Object[]{this.GX});
            boolean bl = this.SY.isEmpty() && this.SX.isEmpty();
            zzac.zza((bl && this.Pa == 0 || !bl && this.Pa != 0 ? 1 : 0) != 0, (Object)"Must specify a valid bucketing strategy while requesting aggregation");
            return new DataReadRequest(this);
        }

        static /* synthetic */ boolean zzk(Builder builder) {
            return false;
        }
    }
}

