/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.request.zzd;
import com.google.android.gms.internal.zzuh;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DataDeleteRequest
extends AbstractSafeParcelable {
    private final int mVersionCode;
    private final long bZ;
    private final long GX;
    private final List<DataSource> SS;
    private final List<DataType> OX;
    private final List<Session> ST;
    private final boolean SU;
    private final boolean SV;
    private final zzuh SP;
    public static final Parcelable.Creator<DataDeleteRequest> CREATOR = new zzd();

    DataDeleteRequest(int n, long l, long l2, List<DataSource> list, List<DataType> list2, List<Session> list3, boolean bl, boolean bl2, IBinder iBinder) {
        this.mVersionCode = n;
        this.bZ = l;
        this.GX = l2;
        this.SS = Collections.unmodifiableList(list);
        this.OX = Collections.unmodifiableList(list2);
        this.ST = list3;
        this.SU = bl;
        this.SV = bl2;
        this.SP = zzuh.zza.zzgi(iBinder);
    }

    private DataDeleteRequest(Builder builder) {
        this(builder.bZ, builder.GX, builder.SS, builder.OX, builder.ST, builder.SU, builder.SV, null);
    }

    public DataDeleteRequest(DataDeleteRequest dataDeleteRequest, zzuh zzuh2) {
        this(dataDeleteRequest.bZ, dataDeleteRequest.GX, dataDeleteRequest.SS, dataDeleteRequest.OX, dataDeleteRequest.ST, dataDeleteRequest.SU, dataDeleteRequest.SV, zzuh2);
    }

    public DataDeleteRequest(long l, long l2, List<DataSource> list, List<DataType> list2, List<Session> list3, boolean bl, boolean bl2, zzuh zzuh2) {
        this.mVersionCode = 3;
        this.bZ = l;
        this.GX = l2;
        this.SS = Collections.unmodifiableList(list);
        this.OX = Collections.unmodifiableList(list2);
        this.ST = list3;
        this.SU = bl;
        this.SV = bl2;
        this.SP = zzuh2;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.bZ, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.GX, TimeUnit.MILLISECONDS);
    }

    public List<DataSource> getDataSources() {
        return this.SS;
    }

    public List<DataType> getDataTypes() {
        return this.OX;
    }

    public List<Session> getSessions() {
        return this.ST;
    }

    public boolean deleteAllData() {
        return this.SU;
    }

    public boolean deleteAllSessions() {
        return this.SV;
    }

    public boolean equals(Object object) {
        return object == this || object instanceof DataDeleteRequest && this.zzb((DataDeleteRequest)((Object)object));
    }

    private boolean zzb(DataDeleteRequest dataDeleteRequest) {
        return this.bZ == dataDeleteRequest.bZ && this.GX == dataDeleteRequest.GX && zzab.equal(this.SS, dataDeleteRequest.SS) && zzab.equal(this.OX, dataDeleteRequest.OX) && zzab.equal(this.ST, dataDeleteRequest.ST) && this.SU == dataDeleteRequest.SU && this.SV == dataDeleteRequest.SV;
    }

    public int hashCode() {
        return zzab.hashCode((Object[])new Object[]{this.bZ, this.GX});
    }

    public String toString() {
        return zzab.zzx((Object)((Object)this)).zzg("startTimeMillis", (Object)this.bZ).zzg("endTimeMillis", (Object)this.GX).zzg("dataSources", this.SS).zzg("dateTypes", this.OX).zzg("sessions", this.ST).zzg("deleteAllData", (Object)this.SU).zzg("deleteAllSessions", (Object)this.SV).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public boolean zzbga() {
        return this.SU;
    }

    public boolean zzbgb() {
        return this.SV;
    }

    public long zzbao() {
        return this.GX;
    }

    public long zzafn() {
        return this.bZ;
    }

    public IBinder getCallbackBinder() {
        return this.SP == null ? null : this.SP.asBinder();
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzd.zza(this, parcel, n);
    }

    public static class Builder {
        private long bZ;
        private long GX;
        private List<DataSource> SS = new ArrayList<DataSource>();
        private List<DataType> OX = new ArrayList<DataType>();
        private List<Session> ST = new ArrayList<Session>();
        private boolean SU = false;
        private boolean SV = false;

        public Builder setTimeInterval(long l, long l2, TimeUnit timeUnit) {
            zzac.zzb((l > 0L ? 1 : 0) != 0, (String)"Invalid start time :%d", (Object[])new Object[]{l});
            zzac.zzb((l2 > l ? 1 : 0) != 0, (String)"Invalid end time :%d", (Object[])new Object[]{l2});
            this.bZ = timeUnit.toMillis(l);
            this.GX = timeUnit.toMillis(l2);
            return this;
        }

        public Builder deleteAllData() {
            zzac.zzb((boolean)this.OX.isEmpty(), (Object)"Specific data type already added for deletion. deleteAllData() will delete all data types and cannot be combined with addDataType()");
            zzac.zzb((boolean)this.SS.isEmpty(), (Object)"Specific data source already added for deletion. deleteAllData() will delete all data sources and cannot be combined with addDataSource()");
            this.SU = true;
            return this;
        }

        public Builder addDataType(DataType dataType) {
            zzac.zzb((!this.SU ? 1 : 0) != 0, (Object)"All data is already marked for deletion.  addDataType() cannot be combined with deleteAllData()");
            zzac.zzb((dataType != null ? 1 : 0) != 0, (Object)"Must specify a valid data type");
            if (!this.OX.contains((Object)dataType)) {
                this.OX.add(dataType);
            }
            return this;
        }

        public Builder addDataSource(DataSource dataSource) {
            zzac.zzb((!this.SU ? 1 : 0) != 0, (Object)"All data is already marked for deletion.  addDataSource() cannot be combined with deleteAllData()");
            zzac.zzb((dataSource != null ? 1 : 0) != 0, (Object)"Must specify a valid data source");
            if (!this.SS.contains((Object)dataSource)) {
                this.SS.add(dataSource);
            }
            return this;
        }

        public Builder addSession(Session session) {
            zzac.zzb((!this.SV ? 1 : 0) != 0, (Object)"All sessions already marked for deletion.  addSession() cannot be combined with deleteAllSessions()");
            zzac.zzb((session != null ? 1 : 0) != 0, (Object)"Must specify a valid session");
            zzac.zzb((session.getEndTime(TimeUnit.MILLISECONDS) > 0L ? 1 : 0) != 0, (Object)"Cannot delete an ongoing session. Please stop the session prior to deleting it");
            this.ST.add(session);
            return this;
        }

        public Builder deleteAllSessions() {
            zzac.zzb((boolean)this.ST.isEmpty(), (Object)"Specific session already added for deletion. deleteAllData() will delete all sessions and cannot be combined with addSession()");
            this.SV = true;
            return this;
        }

        public DataDeleteRequest build() {
            zzac.zza((this.bZ > 0L && this.GX > this.bZ ? 1 : 0) != 0, (Object)"Must specify a valid time interval");
            boolean bl = this.SU || !this.SS.isEmpty() || !this.OX.isEmpty();
            boolean bl2 = this.SV || !this.ST.isEmpty();
            zzac.zza((bl || bl2 ? 1 : 0) != 0, (Object)"No data or session marked for deletion");
            this.zzbgc();
            return new DataDeleteRequest(this);
        }

        private void zzbgc() {
            if (this.ST.isEmpty()) {
                return;
            }
            for (Session session : this.ST) {
                zzac.zza((session.getStartTime(TimeUnit.MILLISECONDS) >= this.bZ && session.getEndTime(TimeUnit.MILLISECONDS) <= this.GX ? 1 : 0) != 0, (String)"Session %s is outside the time interval [%d, %d]", (Object[])new Object[]{session, this.bZ, this.GX});
            }
        }
    }
}

