/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.util.zzm;
import com.google.android.gms.fitness.FitnessActivities;
import com.google.android.gms.fitness.data.MapValue;
import com.google.android.gms.fitness.data.zzad;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public final class Value
extends AbstractSafeParcelable {
    private final int versionCode;
    private final int format;
    private boolean RJ;
    private float value;
    private String Dr;
    private Map<String, MapValue> RK;
    private int[] RL;
    private float[] RM;
    private byte[] RN;
    public static final Parcelable.Creator<Value> CREATOR = new zzad();

    public Value(int n) {
        this(3, n, false, 0.0f, null, null, null, null, null);
    }

    Value(int n, int n2, boolean bl, float f, String string, Bundle bundle, int[] nArray, float[] fArray, byte[] byArray) {
        this.versionCode = n;
        this.format = n2;
        this.RJ = bl;
        this.value = f;
        this.Dr = string;
        this.RK = Value.zzaa(bundle);
        this.RL = nArray;
        this.RM = fArray;
        this.RN = byArray;
    }

    public void setInt(int n) {
        zzac.zza((this.format == 1 ? 1 : 0) != 0, (Object)"Attempting to set an int value to a field that is not in INT32 format.  Please check the data type definition and use the right format.");
        this.RJ = true;
        this.value = Float.intBitsToFloat(n);
    }

    public void setFloat(float f) {
        zzac.zza((this.format == 2 ? 1 : 0) != 0, (Object)"Attempting to set an float value to a field that is not in FLOAT format.  Please check the data type definition and use the right format.");
        this.RJ = true;
        this.value = f;
    }

    public void setString(String string) {
        zzac.zza((this.format == 3 ? 1 : 0) != 0, (Object)"Attempting to set a string value to a field that is not in STRING format.  Please check the data type definition and use the right format.");
        this.RJ = true;
        this.Dr = string;
    }

    public void setKeyValue(String string, float f) {
        zzac.zza((this.format == 4 ? 1 : 0) != 0, (Object)"Attempting to set a key's value to a field that is not in FLOAT_MAP format.  Please check the data type definition and use the right format.");
        this.RJ = true;
        if (this.RK == null) {
            this.RK = new HashMap<String, MapValue>();
        }
        this.RK.put(string, MapValue.zzd(f));
    }

    public void clearKey(String string) {
        zzac.zza((this.format == 4 ? 1 : 0) != 0, (Object)"Attempting to set a key's value to a field that is not in FLOAT_MAP format.  Please check the data type definition and use the right format.");
        if (this.RK != null) {
            this.RK.remove(string);
        }
    }

    public void setActivity(String string) {
        this.setInt(FitnessActivities.zzje(string));
    }

    public boolean isSet() {
        return this.RJ;
    }

    public int getFormat() {
        return this.format;
    }

    public int asInt() {
        zzac.zza((this.format == 1 ? 1 : 0) != 0, (Object)"Value is not in int format");
        return Float.floatToRawIntBits(this.value);
    }

    public float asFloat() {
        zzac.zza((this.format == 2 ? 1 : 0) != 0, (Object)"Value is not in float format");
        return this.value;
    }

    public String asString() {
        zzac.zza((this.format == 3 ? 1 : 0) != 0, (Object)"Value is not in string format");
        return this.Dr;
    }

    @Nullable
    public Float getKeyValue(String string) {
        zzac.zza((this.format == 4 ? 1 : 0) != 0, (Object)"Value is not in float map format");
        if (this.RK != null && this.RK.containsKey(string)) {
            return Float.valueOf(this.RK.get(string).asFloat());
        }
        return null;
    }

    public String asActivity() {
        return FitnessActivities.getName(this.asInt());
    }

    public boolean equals(Object object) {
        return this == object || object instanceof Value && this.zza((Value)((Object)object));
    }

    private boolean zza(Value value) {
        if (this.format == value.format && this.RJ == value.RJ) {
            switch (this.format) {
                case 1: {
                    return this.asInt() == value.asInt();
                }
                case 2: {
                    return this.value == value.value;
                }
                case 3: {
                    return zzab.equal((Object)this.Dr, (Object)value.Dr);
                }
                case 4: {
                    return zzab.equal(this.RK, value.RK);
                }
                case 5: {
                    return Arrays.equals(this.RL, value.RL);
                }
                case 6: {
                    return Arrays.equals(this.RM, value.RM);
                }
                case 7: {
                    return Arrays.equals(this.RN, value.RN);
                }
            }
            return this.value == value.value;
        }
        return false;
    }

    public int hashCode() {
        return zzab.hashCode((Object[])new Object[]{Float.valueOf(this.value), this.Dr, this.RK, this.RL, this.RM, this.RN});
    }

    public String toString() {
        if (!this.RJ) {
            return "unset";
        }
        switch (this.format) {
            case 1: {
                return Integer.toString(this.asInt());
            }
            case 2: {
                return Float.toString(this.value);
            }
            case 3: {
                return this.Dr;
            }
            case 4: {
                return new TreeMap<String, MapValue>(this.RK).toString();
            }
            case 5: {
                return Arrays.toString(this.RL);
            }
            case 6: {
                return Arrays.toString(this.RM);
            }
            case 7: {
                return zzm.zza((byte[])this.RN, (int)0, (int)this.RN.length, (boolean)false);
            }
        }
        return "unknown";
    }

    int getVersionCode() {
        return this.versionCode;
    }

    float zzbfi() {
        return this.value;
    }

    String zzbfn() {
        return this.Dr;
    }

    Bundle zzbfo() {
        if (this.RK == null) {
            return null;
        }
        Bundle bundle = new Bundle(this.RK.size());
        for (Map.Entry<String, MapValue> entry : this.RK.entrySet()) {
            bundle.putParcelable(entry.getKey(), (Parcelable)entry.getValue());
        }
        return bundle;
    }

    int[] zzbfp() {
        return this.RL;
    }

    float[] zzbfq() {
        return this.RM;
    }

    byte[] zzbfr() {
        return this.RN;
    }

    private static Map<String, MapValue> zzaa(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        bundle.setClassLoader(MapValue.class.getClassLoader());
        ArrayMap arrayMap = new ArrayMap(bundle.size());
        for (String string : bundle.keySet()) {
            arrayMap.put(string, (MapValue)bundle.getParcelable(string));
        }
        return arrayMap;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzad.zza(this, parcel, n);
    }
}

