/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.zzc;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.fitness.FitnessActivities;
import com.google.android.gms.fitness.data.Application;
import com.google.android.gms.fitness.data.zzaa;
import java.util.concurrent.TimeUnit;

public class Session
extends AbstractSafeParcelable {
    public static final String EXTRA_SESSION = "vnd.google.fitness.session";
    public static final String MIME_TYPE_PREFIX = "vnd.google.fitness.session/";
    private final int mVersionCode;
    private final long bZ;
    private final long GX;
    private final String mName;
    private final String RD;
    private final String Y;
    private final int OY;
    private final Application RE;
    private final Long RF;
    public static final Parcelable.Creator<Session> CREATOR = new zzaa();

    Session(int n, long l, long l2, String string, String string2, String string3, int n2, Application application, Long l3) {
        this.mVersionCode = n;
        this.bZ = l;
        this.GX = l2;
        this.mName = string;
        this.RD = string2;
        this.Y = string3;
        this.OY = n2;
        this.RE = application;
        this.RF = l3;
    }

    public Session(long l, long l2, String string, String string2, String string3, int n, Application application, Long l3) {
        this(3, l, l2, string, string2, string3, n, application, l3);
    }

    private Session(Builder builder) {
        this(builder.bZ, builder.GX, builder.mName, builder.RD, builder.Y, builder.OY, Builder.zzg(builder), builder.RF);
    }

    public static Session extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return (Session)zzc.zza((Intent)intent, (String)EXTRA_SESSION, CREATOR);
    }

    public static String getMimeType(String string) {
        String string2 = String.valueOf(MIME_TYPE_PREFIX);
        String string3 = String.valueOf(string);
        return string3.length() != 0 ? string2.concat(string3) : new String(string2);
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.bZ, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.GX, TimeUnit.MILLISECONDS);
    }

    public long getActiveTime(TimeUnit timeUnit) {
        zzac.zza((this.RF != null ? 1 : 0) != 0, (Object)"Active time is not set");
        return timeUnit.convert(this.RF, TimeUnit.MILLISECONDS);
    }

    public boolean hasActiveTime() {
        return this.RF != null;
    }

    public boolean isOngoing() {
        return this.GX == 0L;
    }

    public String getName() {
        return this.mName;
    }

    public String getIdentifier() {
        return this.RD;
    }

    public String getDescription() {
        return this.Y;
    }

    public String getActivity() {
        return FitnessActivities.getName(this.OY);
    }

    public int zzbeb() {
        return this.OY;
    }

    public Application zzben() {
        return this.RE;
    }

    public String getAppPackageName() {
        return this.RE == null ? null : this.RE.getPackageName();
    }

    public boolean equals(Object object) {
        return object == this || object instanceof Session && this.zza((Session)((Object)object));
    }

    private boolean zza(Session session) {
        return this.bZ == session.bZ && this.GX == session.GX && zzab.equal((Object)this.mName, (Object)session.mName) && zzab.equal((Object)this.RD, (Object)session.RD) && zzab.equal((Object)this.Y, (Object)session.Y) && zzab.equal((Object)((Object)this.RE), (Object)((Object)session.RE)) && this.OY == session.OY;
    }

    public int hashCode() {
        return zzab.hashCode((Object[])new Object[]{this.bZ, this.GX, this.RD});
    }

    public String toString() {
        return zzab.zzx((Object)((Object)this)).zzg("startTime", (Object)this.bZ).zzg("endTime", (Object)this.GX).zzg("name", (Object)this.mName).zzg("identifier", (Object)this.RD).zzg("description", (Object)this.Y).zzg("activity", (Object)this.OY).zzg("application", (Object)this.RE).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public long zzafn() {
        return this.bZ;
    }

    public long zzbao() {
        return this.GX;
    }

    public Long zzbfj() {
        return this.RF;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzaa.zza(this, parcel, n);
    }

    public static class Builder {
        private long bZ = 0L;
        private long GX = 0L;
        private String mName = null;
        private String RD;
        private String Y;
        private int OY = 4;
        private Long RF;

        public Builder setStartTime(long l, TimeUnit timeUnit) {
            zzac.zza((l > 0L ? 1 : 0) != 0, (Object)"Start time should be positive.");
            this.bZ = timeUnit.toMillis(l);
            return this;
        }

        public Builder setEndTime(long l, TimeUnit timeUnit) {
            zzac.zza((l >= 0L ? 1 : 0) != 0, (Object)"End time should be positive.");
            this.GX = timeUnit.toMillis(l);
            return this;
        }

        public Builder setName(String string) {
            zzac.zzb((string.length() <= 100 ? 1 : 0) != 0, (String)"Session name cannot exceed %d characters", (Object[])new Object[]{100});
            this.mName = string;
            return this;
        }

        public Builder setIdentifier(String string) {
            zzac.zzbs((string != null && TextUtils.getTrimmedLength((CharSequence)string) > 0 ? 1 : 0) != 0);
            this.RD = string;
            return this;
        }

        public Builder setDescription(String string) {
            zzac.zzb((string.length() <= 1000 ? 1 : 0) != 0, (String)"Session description cannot exceed %d characters", (Object[])new Object[]{1000});
            this.Y = string;
            return this;
        }

        public Builder setActivity(String string) {
            return this.zzop(FitnessActivities.zzje(string));
        }

        public Builder zzop(int n) {
            this.OY = n;
            return this;
        }

        public Builder setActiveTime(long l, TimeUnit timeUnit) {
            this.RF = timeUnit.toMillis(l);
            return this;
        }

        public Session build() {
            zzac.zza((this.bZ > 0L ? 1 : 0) != 0, (Object)"Start time should be specified.");
            zzac.zza((this.GX == 0L || this.GX > this.bZ ? 1 : 0) != 0, (Object)"End time should be later than start time.");
            if (this.RD == null) {
                String string = this.mName == null ? "" : this.mName;
                long l = this.bZ;
                this.RD = new StringBuilder(20 + String.valueOf(string).length()).append(string).append(l).toString();
            }
            if (this.Y == null) {
                this.Y = "";
            }
            return new Session(this);
        }

        static /* synthetic */ Application zzg(Builder builder) {
            return null;
        }
    }
}

