/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.Value;
import com.google.android.gms.fitness.data.zzx;
import com.google.android.gms.internal.zzsy;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

@KeepName
public final class RawDataPoint
extends AbstractSafeParcelable {
    final int versionCode;
    public final long Ru;
    public final long Rv;
    public final Value[] Rw;
    public final int Rx;
    public final int Ry;
    public final long Rz;
    public final long RA;
    public static final Parcelable.Creator<RawDataPoint> CREATOR = new zzx();

    public RawDataPoint(int n, long l, long l2, Value[] valueArray, int n2, int n3, long l3, long l4) {
        this.versionCode = n;
        this.Ru = l;
        this.Rv = l2;
        this.Rx = n2;
        this.Ry = n3;
        this.Rz = l3;
        this.RA = l4;
        this.Rw = valueArray;
    }

    RawDataPoint(DataPoint dataPoint, List<DataSource> list) {
        this.versionCode = 4;
        this.Ru = dataPoint.getTimestamp(TimeUnit.NANOSECONDS);
        this.Rv = dataPoint.getStartTime(TimeUnit.NANOSECONDS);
        this.Rw = dataPoint.zzbef();
        this.Rx = zzsy.zza(dataPoint.getDataSource(), list);
        this.Ry = zzsy.zza(dataPoint.zzbeg(), list);
        this.Rz = dataPoint.zzbeh();
        this.RA = dataPoint.zzbei();
    }

    public boolean equals(Object object) {
        return this == object || object instanceof RawDataPoint && this.zza((RawDataPoint)((Object)object));
    }

    private boolean zza(RawDataPoint rawDataPoint) {
        return this.Ru == rawDataPoint.Ru && this.Rv == rawDataPoint.Rv && Arrays.equals((Object[])this.Rw, (Object[])rawDataPoint.Rw) && this.Rx == rawDataPoint.Rx && this.Ry == rawDataPoint.Ry && this.Rz == rawDataPoint.Rz;
    }

    public int hashCode() {
        return zzab.hashCode((Object[])new Object[]{this.Ru, this.Rv});
    }

    public String toString() {
        return String.format("RawDataPoint{%s@[%s, %s](%d,%d)}", Arrays.toString((Object[])this.Rw), this.Rv, this.Ru, this.Rx, this.Ry);
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzx.zza(this, parcel, n);
    }
}

