/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.fitness.FitnessActivities;
import com.google.android.gms.fitness.data.zzn;
import com.google.android.gms.fitness.data.zzp;
import com.google.android.gms.fitness.data.zzq;
import com.google.android.gms.fitness.data.zzv;
import com.google.android.gms.fitness.data.zzz;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Goal
extends AbstractSafeParcelable {
    private final int versionCode;
    private final long Pg;
    private final long Qj;
    private final List<Integer> Qk;
    private final Recurrence Ql;
    private final int Qm;
    private final MetricObjective Qn;
    private final DurationObjective Qo;
    private final FrequencyObjective Qp;
    public static final Parcelable.Creator<Goal> CREATOR = new zzq();

    @Nullable
    public Set<String> zzbew() {
        if (this.Qk.isEmpty()) {
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (int n : this.Qk) {
            hashSet.add(FitnessActivities.getName(n));
        }
        return hashSet;
    }

    public Recurrence zzbex() {
        return this.Ql;
    }

    public int zzbey() {
        return this.Qm;
    }

    private static String zzog(int n) {
        switch (n) {
            case 1: {
                return "metric";
            }
            case 2: {
                return "duration";
            }
            case 3: {
                return "frequency";
            }
            case 0: {
                return "unknown";
            }
        }
        throw new IllegalArgumentException("invalid objective type value");
    }

    Goal(int n, long l, long l2, List<Integer> list, Recurrence recurrence, int n2, MetricObjective metricObjective, DurationObjective durationObjective, FrequencyObjective frequencyObjective) {
        this.versionCode = n;
        this.Pg = l;
        this.Qj = l2;
        this.Qk = list == null ? Collections.emptyList() : list;
        this.Ql = recurrence;
        this.Qm = n2;
        this.Qn = metricObjective;
        this.Qo = durationObjective;
        this.Qp = frequencyObjective;
    }

    int getVersionCode() {
        return this.versionCode;
    }

    public long zzbek() {
        return this.Pg;
    }

    public long zzbez() {
        return this.Qj;
    }

    public List<Integer> zzbfa() {
        return this.Qk;
    }

    public MetricObjective zzbfb() {
        return this.Qn;
    }

    public DurationObjective zzbfc() {
        return this.Qo;
    }

    public FrequencyObjective zzbfd() {
        return this.Qp;
    }

    public boolean equals(Object object) {
        return this == object || object instanceof Goal && this.zza((Goal)((Object)object));
    }

    private boolean zza(Goal goal) {
        return this.Pg == goal.Pg && this.Qj == goal.Qj && zzab.equal(this.Qk, goal.Qk) && zzab.equal((Object)((Object)this.Ql), (Object)((Object)goal.Ql)) && this.Qm == goal.Qm && zzab.equal((Object)((Object)this.Qn), (Object)((Object)goal.Qn)) && zzab.equal((Object)((Object)this.Qo), (Object)((Object)goal.Qo)) && zzab.equal((Object)((Object)this.Qp), (Object)((Object)goal.Qp));
    }

    public int hashCode() {
        return zzab.hashCode((Object[])new Object[]{this.Pg, this.Qj, this.zzbew(), this.Ql, this.Qm, this.Qn, this.Qo, this.Qp});
    }

    public String toString() {
        return zzab.zzx((Object)((Object)this)).zzg("startTime", (Object)this.Pg).zzg("endTime", (Object)this.Qj).zzg("activities", this.zzbew()).zzg("recurrence", (Object)this.Ql).zzg("objectiveType", (Object)Goal.zzog(this.Qm)).zzg("metricObjective", (Object)this.Qn).zzg("durationObjective", (Object)this.Qo).zzg("frequencyObjective", (Object)this.Qp).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzq.zza(this, parcel, n);
    }

    public static class FrequencyObjective
    extends AbstractSafeParcelable {
        private final int versionCode;
        private final int frequency;
        public static final Parcelable.Creator<FrequencyObjective> CREATOR = new zzp();

        public int getFrequency() {
            return this.frequency;
        }

        FrequencyObjective(int n, int n2) {
            this.versionCode = n;
            this.frequency = n2;
        }

        int getVersionCode() {
            return this.versionCode;
        }

        public boolean equals(Object object) {
            return this == object || object instanceof FrequencyObjective && this.zza((FrequencyObjective)((Object)object));
        }

        private boolean zza(FrequencyObjective frequencyObjective) {
            return this.frequency == frequencyObjective.frequency;
        }

        public int hashCode() {
            return zzab.hashCode((Object[])new Object[]{this.frequency});
        }

        public String toString() {
            return zzab.zzx((Object)((Object)this)).zzg("frequency", (Object)this.frequency).toString();
        }

        public void writeToParcel(Parcel parcel, int n) {
            zzp.zza(this, parcel, n);
        }
    }

    public static class DurationObjective
    extends AbstractSafeParcelable {
        private final int versionCode;
        private final long Qq;
        public static final Parcelable.Creator<DurationObjective> CREATOR = new zzn();

        public long getDuration() {
            return this.Qq;
        }

        DurationObjective(int n, long l) {
            this.versionCode = n;
            this.Qq = l;
        }

        int getVersionCode() {
            return this.versionCode;
        }

        public boolean equals(Object object) {
            return this == object || object instanceof DurationObjective && this.zza((DurationObjective)((Object)object));
        }

        private boolean zza(DurationObjective durationObjective) {
            return this.Qq == durationObjective.Qq;
        }

        public int hashCode() {
            return zzab.hashCode((Object[])new Object[]{this.Qq});
        }

        public String toString() {
            return zzab.zzx((Object)((Object)this)).zzg("duration", (Object)this.Qq).toString();
        }

        public void writeToParcel(Parcel parcel, int n) {
            zzn.zza(this, parcel, n);
        }
    }

    public static class MetricObjective
    extends AbstractSafeParcelable {
        private final int versionCode;
        private final String Qr;
        private final double value;
        private final double Qs;
        public static final Parcelable.Creator<MetricObjective> CREATOR = new zzv();

        public String zzbfe() {
            return this.Qr;
        }

        public double zzbff() {
            return this.value;
        }

        public double zzbfg() {
            return this.Qs;
        }

        MetricObjective(int n, String string, double d, double d2) {
            this.versionCode = n;
            this.Qr = string;
            this.value = d;
            this.Qs = d2;
        }

        int getVersionCode() {
            return this.versionCode;
        }

        public boolean equals(Object object) {
            return this == object || object instanceof MetricObjective && this.zza((MetricObjective)((Object)object));
        }

        private boolean zza(MetricObjective metricObjective) {
            return zzab.equal((Object)this.Qr, (Object)metricObjective.Qr) && this.value == metricObjective.value && this.Qs == metricObjective.Qs;
        }

        public int hashCode() {
            return zzab.hashCode((Object[])new Object[]{this.Qr, this.value, this.Qs});
        }

        public String toString() {
            return zzab.zzx((Object)((Object)this)).zzg("dataTypeName", (Object)this.Qr).zzg("value", (Object)this.value).zzg("initValue", (Object)this.Qs).toString();
        }

        public void writeToParcel(Parcel parcel, int n) {
            zzv.zza(this, parcel, n);
        }
    }

    public static class Recurrence
    extends AbstractSafeParcelable {
        private final int versionCode;
        private final int count;
        private final int Qt;
        public static final Parcelable.Creator<Recurrence> CREATOR = new zzz();

        public int getCount() {
            return this.count;
        }

        public int zzbfh() {
            return this.Qt;
        }

        private static String zzoh(int n) {
            switch (n) {
                case 1: {
                    return "day";
                }
                case 2: {
                    return "week";
                }
                case 3: {
                    return "month";
                }
            }
            throw new IllegalArgumentException("invalid unit value");
        }

        Recurrence(int n, int n2, int n3) {
            this.versionCode = n;
            this.count = n2;
            zzac.zzbr((n3 > 0 && n3 <= 3 ? 1 : 0) != 0);
            this.Qt = n3;
        }

        int getVersionCode() {
            return this.versionCode;
        }

        public boolean equals(Object object) {
            return this == object || object instanceof Recurrence && this.zza((Recurrence)((Object)object));
        }

        private boolean zza(Recurrence recurrence) {
            return this.count == recurrence.count && this.Qt == recurrence.Qt;
        }

        public int hashCode() {
            return zzab.hashCode((Object[])new Object[]{this.count, this.Qt});
        }

        public String toString() {
            return zzab.zzx((Object)((Object)this)).zzg("count", (Object)this.count).zzg("unit", (Object)Recurrence.zzoh(this.Qt)).toString();
        }

        public void writeToParcel(Parcel parcel, int n) {
            zzz.zza(this, parcel, n);
        }
    }
}

