/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.Settings;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.fitness.data.zzm;
import com.google.android.gms.internal.zztc;
import com.google.android.gms.internal.zzuv;

public final class Device
extends AbstractSafeParcelable {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_PHONE = 1;
    public static final int TYPE_TABLET = 2;
    public static final int TYPE_WATCH = 3;
    public static final int TYPE_CHEST_STRAP = 4;
    public static final int TYPE_SCALE = 5;
    public static final int TYPE_HEAD_MOUNTED = 6;
    private final int versionCode;
    private final String PL;
    private final String PM;
    private final String version;
    private final String PN;
    private final int type;
    private final int PO;
    public static final Parcelable.Creator<Device> CREATOR = new zzm();

    public static Device getLocalDevice(Context context) {
        int n = zztc.zzcy(context);
        String string = Device.zzcw(context);
        return new Device(Build.MANUFACTURER, Build.MODEL, Build.VERSION.RELEASE, string, n, 2);
    }

    private static String zzcw(Context context) {
        return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
    }

    public Device(String string, String string2, String string3, int n) {
        this(string, string2, "", string3, n, 0);
    }

    public Device(String string, String string2, String string3, String string4, int n, int n2) {
        this(1, string, string2, "", string4, n, n2);
    }

    Device(int n, String string, String string2, String string3, String string4, int n2, int n3) {
        this.versionCode = n;
        this.PL = (String)zzac.zzy((Object)string);
        this.PM = (String)zzac.zzy((Object)string2);
        this.version = "";
        this.PN = this.zzji(string4);
        this.type = n2;
        this.PO = n3;
    }

    private String zzji(String string) {
        if (string != null) {
            return string;
        }
        throw new IllegalStateException("Device UID is null.");
    }

    public String getManufacturer() {
        return this.PL;
    }

    public String getModel() {
        return this.PM;
    }

    public String getVersion() {
        return this.version;
    }

    public String getUid() {
        return this.PN;
    }

    public int getType() {
        return this.type;
    }

    public int zzbet() {
        return this.PO;
    }

    private boolean zzbeu() {
        return this.zzbet() == 1;
    }

    String getStreamIdentifier() {
        return String.format("%s:%s:%s", this.PL, this.PM, this.PN);
    }

    public String zzbev() {
        return this.zzbeu() ? this.PN : zzuv.zzju(this.PN);
    }

    public String toString() {
        return String.format("Device{%s:%s:%s:%s}", this.getStreamIdentifier(), this.version, this.type, this.PO);
    }

    public boolean equals(Object object) {
        return this == object || object instanceof Device && this.zza((Device)((Object)object));
    }

    private boolean zza(Device device) {
        return zzab.equal((Object)this.PL, (Object)device.PL) && zzab.equal((Object)this.PM, (Object)device.PM) && zzab.equal((Object)this.version, (Object)device.version) && zzab.equal((Object)this.PN, (Object)device.PN) && this.type == device.type && this.PO == device.PO;
    }

    public int hashCode() {
        return zzab.hashCode((Object[])new Object[]{this.PL, this.PM, this.version, this.PN, this.type});
    }

    int getVersionCode() {
        return this.versionCode;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzm.zza(this, parcel, n);
    }
}

